/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.operation.block;

import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.tag.RecordTag;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.Storage;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.operation.block.BlockOperation;
import dev.huskuraft.effortless.building.operation.block.BlockOperationResultType;
import dev.huskuraft.effortless.building.operation.block.BlockStateCopyOperationResult;
import dev.huskuraft.effortless.building.operation.block.Extras;
import dev.huskuraft.effortless.building.operation.empty.EmptyOperation;
import dev.huskuraft.effortless.building.pattern.MirrorContext;
import dev.huskuraft.effortless.building.pattern.MoveContext;
import dev.huskuraft.effortless.building.pattern.RefactorContext;
import dev.huskuraft.effortless.building.pattern.RotateContext;
import dev.huskuraft.effortless.building.session.Session;

public class BlockStateCopyOperation
extends BlockOperation {
    public BlockStateCopyOperation(Session session, Context context, Storage storage, BlockInteraction interaction, Extras extras) {
        super(session, context, storage, interaction, extras);
    }

    protected BlockOperationResultType saveBlock() {
        if (!this.context.extras().dimensionId().equals(this.getWorld().getDimensionId().location())) {
            return BlockOperationResultType.FAIL_WORLD_INCORRECT_DIM;
        }
        if (this.getPlayer().getGameMode().isSpectator()) {
            return BlockOperationResultType.FAIL_PLAYER_GAME_MODE;
        }
        if (!this.isInBorderBound()) {
            return BlockOperationResultType.FAIL_WORLD_BORDER;
        }
        if (!this.isInHeightBound()) {
            return BlockOperationResultType.FAIL_WORLD_HEIGHT;
        }
        if (this.getBlockState() == null) {
            return BlockOperationResultType.FAIL_BLOCK_STATE_NULL;
        }
        if (this.getBlockState().isAir() && !this.context.clipboard().copyAir()) {
            return BlockOperationResultType.FAIL_BLOCK_STATE_AIR;
        }
        if (!this.context.configs().constraintConfig().allowCopyPasteStructures().booleanValue()) {
            return BlockOperationResultType.FAIL_COPY_NO_PERMISSION;
        }
        if (!this.context.configs().constraintConfig().whitelistedItems().isEmpty() && !this.context.configs().constraintConfig().whitelistedItems().contains(this.getBlockState().getItem().getId())) {
            return BlockOperationResultType.FAIL_COPY_BLACKLISTED;
        }
        if (!this.context.configs().constraintConfig().blacklistedItems().isEmpty() && this.context.configs().constraintConfig().blacklistedItems().contains(this.getBlockState().getItem().getId())) {
            return BlockOperationResultType.FAIL_COPY_BLACKLISTED;
        }
        if (this.getWorld().isClient()) {
            return BlockOperationResultType.CONSUME;
        }
        return BlockOperationResultType.SUCCESS;
    }

    @Override
    public BlockStateCopyOperationResult commit() {
        Extras entityExtrasBeforeOp = Extras.get(this.getPlayer());
        BlockState blockStateBeforeOp = this.getBlockStateInWorld();
        RecordTag entityTagBeforeOp = this.getEntityTagInWorld();
        Extras.set(this.getPlayer(), this.getExtras());
        BlockOperationResultType result = this.saveBlock();
        Extras.set(this.getPlayer(), entityExtrasBeforeOp);
        BlockState blockStateAfterOp = this.getBlockStateInWorld();
        RecordTag entityTagAfterOp = this.getEntityTagInWorld();
        if (this.getContext().isBuildClientType() && this.getBlockPosition().toVector3d().distance(this.getPlayer().getEyePosition()) <= 32.0) {
            this.getPlayer().getClient().getParticleEngine().crack(this.getBlockPosition(), this.getInteraction().getDirection());
        }
        return new BlockStateCopyOperationResult(this, result, blockStateBeforeOp, blockStateAfterOp, entityTagBeforeOp, entityTagAfterOp);
    }

    @Override
    public Operation move(MoveContext moveContext) {
        return new BlockStateCopyOperation(this.session, this.context, this.storage, moveContext.move(this.interaction), this.extras);
    }

    @Override
    public Operation mirror(MirrorContext mirrorContext) {
        if (!mirrorContext.isInBounds(this.getBlockPosition().getCenter())) {
            return new EmptyOperation(this.context);
        }
        return new BlockStateCopyOperation(this.session, this.context, this.storage, mirrorContext.mirror(this.interaction), mirrorContext.mirror(this.extras));
    }

    @Override
    public Operation rotate(RotateContext rotateContext) {
        if (!rotateContext.isInBounds(this.getBlockPosition().getCenter())) {
            return new EmptyOperation(this.context);
        }
        return new BlockStateCopyOperation(this.session, this.context, this.storage, rotateContext.rotate(this.interaction), rotateContext.rotate(this.extras));
    }

    @Override
    public Operation refactor(RefactorContext source) {
        return this;
    }

    @Override
    public BlockOperation.Type getType() {
        return BlockOperation.Type.COPY;
    }
}

