/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.operation.block;

import dev.huskuraft.effortless.api.core.BlockEntity;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.InteractionHand;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.tag.RecordTag;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.Storage;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.operation.block.Extras;
import dev.huskuraft.effortless.building.session.Session;

public abstract class BlockOperation
implements Operation {
    protected final Session session;
    protected final Context context;
    protected final Storage storage;
    protected final BlockInteraction interaction;
    protected final BlockState blockState;
    protected final RecordTag entityTag;
    protected final Extras extras;

    protected BlockOperation(Session session, Context context, Storage storage, BlockInteraction interaction, BlockState blockState, RecordTag entityTag, Extras extras) {
        this.session = session;
        this.context = context;
        this.storage = storage;
        this.interaction = interaction;
        this.blockState = blockState;
        this.entityTag = entityTag;
        this.extras = extras;
    }

    protected BlockOperation(Session session, Context context, Storage storage, BlockInteraction interaction, Extras extras) {
        this.session = session;
        this.context = context;
        this.storage = storage;
        this.interaction = interaction;
        this.blockState = session.getWorld().getBlockState(interaction.getBlockPosition());
        BlockEntity blockEntity = session.getWorld().getBlockEntity(interaction.getBlockPosition());
        this.entityTag = blockEntity != null ? blockEntity.getTag() : null;
        this.extras = extras;
    }

    public final Session getSession() {
        return this.session;
    }

    public final World getWorld() {
        return this.session.getWorld();
    }

    public final Player getPlayer() {
        return this.session.getPlayer();
    }

    @Override
    public final Context getContext() {
        return this.context;
    }

    public final Storage getStorage() {
        return this.storage;
    }

    public final BlockState getBlockState() {
        return this.blockState;
    }

    public final RecordTag getEntityTag() {
        return this.entityTag;
    }

    public final Extras getExtras() {
        return this.getContext().extras().extras();
    }

    public final BlockInteraction getInteraction() {
        return this.interaction;
    }

    public final BlockPosition getBlockPosition() {
        return this.getInteraction().getBlockPosition();
    }

    public final BlockPosition getRelativeBlockPosition() {
        return this.getBlockPosition().relative(this.getInteraction().getDirection());
    }

    public final InteractionHand getHand() {
        return InteractionHand.MAIN;
    }

    public final boolean isInBorderBound() {
        return this.getWorld().getWorldBorder().isInBounds(this.getBlockPosition());
    }

    public final boolean isInHeightBound() {
        return this.getBlockPosition().y() >= this.getWorld().getMinBuildHeight() && this.getBlockPosition().y() <= this.getWorld().getMaxBuildHeight();
    }

    public final boolean allowInteraction() {
        return this.getSession().getInterceptors().stream().allMatch(interceptor -> interceptor.allowInteraction(this.getPlayer(), this.getWorld(), this.getBlockPosition()));
    }

    public abstract Type getType();

    public final BlockState getBlockStateInWorld() {
        return this.getWorld().getBlockState(this.getBlockPosition());
    }

    public final BlockEntity getBlockEntityInWorld() {
        return this.getWorld().getBlockEntity(this.getBlockPosition());
    }

    public RecordTag getEntityTagInWorld() {
        BlockEntity blockEntity = this.getWorld().getBlockEntity(this.getBlockPosition());
        if (blockEntity == null) {
            return null;
        }
        return blockEntity.getTag();
    }

    public static enum Type {
        UPDATE,
        INTERACT,
        COPY;

    }
}

