/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.operation.batch;

import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.operation.batch.BatchOperation;
import dev.huskuraft.effortless.building.operation.batch.BatchOperationResult;
import dev.huskuraft.effortless.building.pattern.MirrorContext;
import dev.huskuraft.effortless.building.pattern.MoveContext;
import dev.huskuraft.effortless.building.pattern.RefactorContext;
import dev.huskuraft.effortless.building.pattern.RotateContext;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class DeferredBatchOperation
extends BatchOperation {
    protected final Supplier<Stream<? extends Operation>> operationsSupplier;

    public DeferredBatchOperation(Context context, Supplier<Stream<? extends Operation>> operationsSupplier) {
        super(context);
        this.operationsSupplier = operationsSupplier;
    }

    @Override
    public BatchOperationResult commit() {
        return new BatchOperationResult(this, this.operations().map(Operation::commit).toList());
    }

    @Override
    public DeferredBatchOperation move(MoveContext moveContext) {
        return new DeferredBatchOperation(this.context, () -> this.operations().map((? super T o) -> (Operation)o.move(moveContext)));
    }

    @Override
    public DeferredBatchOperation mirror(MirrorContext mirrorContext) {
        return new DeferredBatchOperation(this.context, () -> this.operations().map((? super T o) -> (Operation)o.mirror(mirrorContext)));
    }

    @Override
    public DeferredBatchOperation rotate(RotateContext rotateContext) {
        return new DeferredBatchOperation(this.context, () -> this.operations().map((? super T o) -> (Operation)o.rotate(rotateContext)));
    }

    @Override
    public DeferredBatchOperation refactor(RefactorContext source) {
        return new DeferredBatchOperation(this.context, () -> this.operations().map((? super T o) -> (Operation)o.refactor(source)));
    }

    @Override
    public DeferredBatchOperation map(UnaryOperator<Operation> operator) {
        return new DeferredBatchOperation(this.context, () -> this.operations().map(operator));
    }

    @Override
    public DeferredBatchOperation mapEach(UnaryOperator<Operation> operator) {
        return new DeferredBatchOperation(this.context, () -> this.operations().map((? super T op) -> {
            if (op instanceof BatchOperation) {
                BatchOperation op1 = (BatchOperation)op;
                return op1.mapEach(operator);
            }
            return (Operation)operator.apply((Operation)op);
        }));
    }

    @Override
    public DeferredBatchOperation flatten() {
        return new DeferredBatchOperation(this.context, () -> this.operations().flatMap(op -> {
            Stream<Operation> stream;
            if (op instanceof BatchOperation) {
                BatchOperation op1 = (BatchOperation)op;
                stream = op1.flatten().operations();
            } else {
                stream = Stream.of(op);
            }
            return stream;
        }));
    }

    @Override
    public DeferredBatchOperation filter(Predicate<Operation> predicate) {
        return new DeferredBatchOperation(this.context, () -> this.operations().filter(predicate));
    }

    @Override
    public Stream<? extends Operation> operations() {
        return this.operationsSupplier.get();
    }
}

