/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.operation;

import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.operation.block.BlockOperation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public interface OperationFilter<O>
extends Predicate<O> {
    public static <O extends Operation> OperationFilter<O> distinctBlockOperations() {
        return OperationFilter.distinctBy(operation -> {
            BlockPosition blockPosition;
            if (operation instanceof BlockOperation) {
                BlockOperation blockOperation = (BlockOperation)operation;
                blockPosition = blockOperation.getBlockPosition();
            } else {
                blockPosition = null;
            }
            return blockPosition;
        });
    }

    public static <O extends Operation> OperationFilter<O> distinctBy(Function<O, ?> propertyGetter) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> {
            Object property = propertyGetter.apply(t);
            return property != null && seen.add(propertyGetter.apply(t));
        };
    }
}

