/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.history;

import dev.huskuraft.effortless.building.operation.OperationResult;
import java.util.Stack;

public class OperationResultStack {
    private final Stack<OperationResult> undoStack = new Stack();
    private final Stack<OperationResult> redoStack = new Stack();

    public OperationResult push(OperationResult result) {
        this.redoStack.clear();
        return this.undoStack.push(result);
    }

    public synchronized OperationResult undo() {
        return this.redoStack.push(this.undoStack.pop().getReverseOperation().commit());
    }

    public synchronized OperationResult redo() {
        return this.undoStack.push(this.redoStack.pop().getReverseOperation().commit());
    }

    public int undoSize() {
        return this.undoStack.size();
    }

    public int redoSize() {
        return this.redoStack.size();
    }
}

