/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.config.universal;

import dev.huskuraft.effortless.api.config.ConfigSerializer;
import dev.huskuraft.effortless.api.nightconfig.core.Config;
import dev.huskuraft.effortless.api.nightconfig.core.ConfigSpec;
import dev.huskuraft.effortless.building.config.universal.TransformerConfigSerializer;
import dev.huskuraft.effortless.building.pattern.Pattern;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class PatternConfigSerializer
implements ConfigSerializer<Pattern> {
    public static final PatternConfigSerializer INSTANCE = new PatternConfigSerializer();
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_TRANSFORMERS = "transformers";

    private PatternConfigSerializer() {
    }

    public static String randomIdString() {
        return UUID.randomUUID().toString();
    }

    public static boolean isIdCorrect(Object string) {
        try {
            UUID.fromString((String)string);
            return true;
        }
        catch (ClassCastException | IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public ConfigSpec getSpec(Config config) {
        ConfigSpec spec = new ConfigSpec();
        spec.define(KEY_ENABLED, () -> this.getDefault().enabled(), Boolean.class::isInstance);
        spec.defineList(KEY_TRANSFORMERS, () -> this.getDefault().transformers(), Config.class::isInstance);
        return spec;
    }

    @Override
    public Pattern deserialize(Config config) {
        this.validate(config);
        return new Pattern((Boolean)config.get(KEY_ENABLED), ((List)config.get(KEY_TRANSFORMERS)).stream().map(TransformerConfigSerializer.INSTANCE::deserialize).filter(Objects::nonNull).toList());
    }

    @Override
    public Config serialize(Pattern pattern) {
        Config config = Config.inMemory();
        config.set(KEY_ENABLED, (Object)pattern.enabled());
        config.set(KEY_TRANSFORMERS, pattern.transformers().stream().map(TransformerConfigSerializer.INSTANCE::serialize).toList());
        this.validate(config);
        return config;
    }

    @Override
    public Pattern getDefault() {
        return Pattern.DISABLED;
    }
}

