/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building;

import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.lang.Lang;
import dev.huskuraft.effortless.api.text.Text;

public interface Option {
    public String getName();

    public String getCategory();

    default public String getNameKey() {
        return Lang.asKey("effortless", "action.%s".formatted(this.getName()));
    }

    default public String getCategoryKey() {
        return Lang.asKey("effortless", "option.%s".formatted(this.getCategory()));
    }

    default public String getTooltipKey() {
        return Lang.asKey("effortless", "action.%s.tooltip".formatted(this.getName()));
    }

    default public Text getNameText() {
        return Text.translate(this.getNameKey());
    }

    default public Text getCategoryText() {
        return Text.translate(this.getCategoryKey());
    }

    default public Text getTooltipText() {
        if (Lang.hasKey(this.getTooltipKey())) {
            return Text.translate(this.getTooltipKey());
        }
        return Text.empty();
    }

    default public ResourceLocation getIcon() {
        return ResourceLocation.of("effortless", "textures/option/%s.png".formatted(this.getName()));
    }
}

