/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.inventory.IChangeTrackerAccess;
import com.tom.storagemod.inventory.IProxy;
import com.tom.storagemod.inventory.InventorySlot;
import com.tom.storagemod.inventory.PlatformInventoryAccess;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.inventory.filter.ItemPredicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public interface IInventoryAccess
extends IChangeTrackerAccess,
IProxy {
    default public class_1799 pullMatchingStack(class_1799 st, long max) {
        class_1799 e;
        InventorySlot slot = null;
        IInventoryChangeTracker tr = this.tracker();
        StoredItemStack s = new StoredItemStack(st, 1L);
        ItemPredicate ip = s::equalItem;
        class_1799 ext = null;
        for (long ex = 0L; ex < max && (slot = tr.findSlotAfter(slot, ip, false, false)) != null; ex += (long)e.method_7947()) {
            e = slot.extract((int)(max - ex));
            if (ext == null) {
                ext = e;
                continue;
            }
            ext.method_7933(e.method_7947());
        }
        return ext != null ? ext : class_1799.field_8037;
    }

    default public class_1799 pushStack(class_1799 stack) {
        IInventoryChangeTracker tr = this.tracker();
        StoredItemStack s = new StoredItemStack(stack);
        InventorySlot slot = null;
        while (!stack.method_7960() && (slot = tr.findSlotDestAfter(slot, s, false)) != null) {
            stack = slot.insert(stack);
            s.setCount(stack.method_7947());
        }
        return stack;
    }

    public int getFreeSlotCount();

    public int getSlotCount();

    @Deprecated
    public Object get();

    @Override
    public IInventoryAccess getRootHandler();

    default public <T> T getPlatformHandler() {
        Storage<ItemVariant> t = this.get();
        return (T)(t != null ? t : PlatformInventoryAccess.EMPTY.get());
    }

    default public void markInvalid() {
    }

    public static interface IInventoryChangeTracker {
        public long getChangeTracker(class_1937 var1);

        public Stream<StoredItemStack> streamWrappedStacks(boolean var1);

        public long countItems(StoredItemStack var1);

        public InventorySlot findSlot(ItemPredicate var1, boolean var2);

        public InventorySlot findSlotAfter(InventorySlot var1, ItemPredicate var2, boolean var3, boolean var4);

        public InventorySlot findSlotDest(StoredItemStack var1);

        public InventorySlot findSlotDestAfter(InventorySlot var1, StoredItemStack var2, boolean var3);

        public static class Delegate
        implements IInventoryChangeTracker,
        IMultiThreadedTracker<Object, Object> {
            private IInventoryChangeTracker delegate;

            @Override
            public Stream<StoredItemStack> streamWrappedStacks(boolean parallel) {
                return this.delegate.streamWrappedStacks(parallel);
            }

            @Override
            public long countItems(StoredItemStack filter) {
                return this.delegate.countItems(filter);
            }

            @Override
            public long getChangeTracker(class_1937 level) {
                return this.delegate.getChangeTracker(level);
            }

            public void setDelegate(IInventoryChangeTracker delegate) {
                this.delegate = delegate;
            }

            @Override
            public InventorySlot findSlot(ItemPredicate filter, boolean findEmpty) {
                return this.delegate.findSlot(filter, findEmpty);
            }

            @Override
            public Object prepForOffThread(class_1937 level) {
                IInventoryChangeTracker iInventoryChangeTracker = this.delegate;
                if (iInventoryChangeTracker instanceof IMultiThreadedTracker) {
                    IMultiThreadedTracker t = (IMultiThreadedTracker)((Object)iInventoryChangeTracker);
                    return t.prepForOffThread(level);
                }
                return null;
            }

            @Override
            public Object processOffThread(Object array) {
                return ((IMultiThreadedTracker)((Object)this.delegate)).processOffThread(array);
            }

            @Override
            public long finishOffThreadProcess(class_1937 level, Object ct) {
                return ((IMultiThreadedTracker)((Object)this.delegate)).finishOffThreadProcess(level, ct);
            }

            @Override
            public InventorySlot findSlotDest(StoredItemStack forStack) {
                return this.delegate.findSlotDest(forStack);
            }

            @Override
            public InventorySlot findSlotAfter(InventorySlot slot, ItemPredicate filter, boolean findEmpty, boolean loop) {
                return this.delegate.findSlotAfter(slot, filter, findEmpty, loop);
            }

            @Override
            public InventorySlot findSlotDestAfter(InventorySlot slot, StoredItemStack forStack, boolean loop) {
                return this.delegate.findSlotDestAfter(slot, forStack, loop);
            }
        }
    }

    public static interface IInventory {
        public IInventoryAccess getInventoryAccess();
    }

    public static interface IChangeNotifier {
        public void onSlotChanged(InventorySlot var1);
    }

    public static interface IMultiThreadedTracker<A, B> {
        public A prepForOffThread(class_1937 var1);

        public B processOffThread(A var1);

        public long finishOffThreadProcess(class_1937 var1, B var2);
    }
}

