/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.staminaattributes.mixin.entity;

import com.github.theredbrain.staminaattributes.StaminaAttributes;
import com.github.theredbrain.staminaattributes.entity.StaminaUsingEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements StaminaUsingEntity {
    @Shadow
    protected class_1799 field_6277;
    @Unique
    private int staminaTickTimer = 0;
    @Unique
    private int depletedStaminaRegenerationDelayTimer = 0;
    @Unique
    private int staminaRegenerationDelayTimer = 0;
    @Unique
    private boolean delayStaminaRegeneration = false;
    @Unique
    private static final class_2940<Float> STAMINA = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13320);

    @Shadow
    public abstract double method_45325(class_6880<class_1320> var1);

    @Shadow
    public abstract boolean method_6115();

    @Shadow
    public abstract void method_6075();

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="RETURN")})
    protected void staminaattributes$initDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(STAMINA, (Object)Float.valueOf(0.0f));
    }

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static void staminaattributes$createLivingAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(StaminaAttributes.STAMINA_REGENERATION).method_26867(StaminaAttributes.MAX_STAMINA).method_26867(StaminaAttributes.DEPLETED_STAMINA_REGENERATION_DELAY_THRESHOLD).method_26867(StaminaAttributes.STAMINA_REGENERATION_DELAY_THRESHOLD).method_26867(StaminaAttributes.STAMINA_TICK_THRESHOLD).method_26867(StaminaAttributes.RESERVED_STAMINA).method_26867(StaminaAttributes.ITEM_USE_STAMINA_COST);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void staminaattributes$readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10573("stamina", 99)) {
            this.staminaattributes$setStamina(nbt.method_10583("stamina"));
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void staminaattributes$writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10548("stamina", this.staminaattributes$getStamina());
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void staminaattributes$tick(CallbackInfo ci) {
        if (!this.method_37908().field_9236) {
            ++this.staminaTickTimer;
            if (this.staminaattributes$getStamina() <= 0.0f && this.delayStaminaRegeneration) {
                this.depletedStaminaRegenerationDelayTimer = 0;
                this.staminaRegenerationDelayTimer = this.staminaattributes$getStaminaRegenerationDelayThreshold();
                this.delayStaminaRegeneration = false;
            }
            if (this.staminaattributes$getStamina() > 0.0f && !this.delayStaminaRegeneration) {
                this.delayStaminaRegeneration = true;
            }
            if (this.depletedStaminaRegenerationDelayTimer <= this.staminaattributes$getDepletedStaminaRegenerationDelayThreshold()) {
                ++this.depletedStaminaRegenerationDelayTimer;
            }
            if (this.staminaRegenerationDelayTimer <= this.staminaattributes$getStaminaRegenerationDelayThreshold()) {
                ++this.staminaRegenerationDelayTimer;
            }
            if (this.staminaTickTimer > this.staminaattributes$getStaminaTickThreshold() && this.depletedStaminaRegenerationDelayTimer > this.staminaattributes$getDepletedStaminaRegenerationDelayThreshold() && this.staminaRegenerationDelayTimer > this.staminaattributes$getStaminaRegenerationDelayThreshold()) {
                if (this.staminaattributes$getStamina() < this.staminaattributes$getUnreservedStamina()) {
                    this.staminaattributes$addStamina(this.staminaattributes$getRegeneratedStamina());
                }
                if (this.staminaattributes$getStamina() > this.staminaattributes$getUnreservedStamina() || this.staminaattributes$getRegeneratedStamina() < 0.0f) {
                    this.staminaattributes$setStamina(this.staminaattributes$getUnreservedStamina());
                }
                this.staminaTickTimer = 0;
            }
            if (this.method_6115() && this.field_6277.method_31573(StaminaAttributes.CONTINUOUS_USING_COSTS_STAMINA) && this.staminaattributes$getItemUseStaminaCost() > 0.0f && this.staminaattributes$getStamina() <= 0.0f) {
                class_1309 class_13092 = (class_1309)this;
                if (class_13092 instanceof class_1657) {
                    class_1657 playerEntity = (class_1657)class_13092;
                    playerEntity.method_7357().method_7906(this.field_6277.method_7909(), StaminaAttributes.SERVER_CONFIG.item_use_cooldown_when_no_stamina);
                }
                this.method_6075();
            }
        }
    }

    @Inject(method={"tickItemStackUsage"}, at={@At(value="HEAD")})
    protected void staminaattributes$tickItemStackUsage(class_1799 stack, CallbackInfo ci) {
        if (stack.method_31573(StaminaAttributes.CONTINUOUS_USING_COSTS_STAMINA) && this.staminaattributes$getItemUseStaminaCost() > 0.0f && this.staminaattributes$getStamina() > 0.0f) {
            this.staminaattributes$addStamina(-this.staminaattributes$getItemUseStaminaCost());
        }
    }

    @Override
    public int staminaattributes$getDepletedStaminaRegenerationDelayThreshold() {
        return (int)this.method_45325(StaminaAttributes.DEPLETED_STAMINA_REGENERATION_DELAY_THRESHOLD);
    }

    @Override
    public int staminaattributes$getStaminaRegenerationDelayThreshold() {
        return (int)this.method_45325(StaminaAttributes.STAMINA_REGENERATION_DELAY_THRESHOLD);
    }

    @Override
    public int staminaattributes$getStaminaTickThreshold() {
        return (int)this.method_45325(StaminaAttributes.STAMINA_TICK_THRESHOLD);
    }

    @Override
    public float staminaattributes$getRegeneratedStamina() {
        return this.staminaattributes$getStaminaRegeneration();
    }

    @Override
    public float staminaattributes$getStaminaRegeneration() {
        return (float)this.method_45325(StaminaAttributes.STAMINA_REGENERATION);
    }

    @Override
    public float staminaattributes$getUnreservedStamina() {
        return this.staminaattributes$getMaxStamina() - this.staminaattributes$getMaxStamina() * this.staminaattributes$getReservedStamina() / 100.0f;
    }

    @Override
    public float staminaattributes$getMaxStamina() {
        return (float)this.method_45325(StaminaAttributes.MAX_STAMINA);
    }

    @Override
    public float staminaattributes$getReservedStamina() {
        return (float)this.method_45325(StaminaAttributes.RESERVED_STAMINA);
    }

    @Override
    public float staminaattributes$getItemUseStaminaCost() {
        return (float)this.method_45325(StaminaAttributes.ITEM_USE_STAMINA_COST);
    }

    @Override
    public void staminaattributes$addStamina(float amount) {
        float f = this.staminaattributes$getStamina();
        this.staminaattributes$setStamina(f + amount);
        if (amount < 0.0f) {
            this.staminaRegenerationDelayTimer = 0;
            this.staminaTickTimer = 0;
        }
    }

    @Override
    public float staminaattributes$getStamina() {
        return ((Float)this.field_6011.method_12789(STAMINA)).floatValue();
    }

    @Override
    public void staminaattributes$setStamina(float stamina) {
        this.field_6011.method_12778(STAMINA, (Object)Float.valueOf(class_3532.method_15363((float)stamina, (float)-100.0f, (float)this.staminaattributes$getUnreservedStamina())));
    }
}

