/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.villagesandpillages.world.structures;

import com.faboslav.villagesandpillages.init.VillagesAndPillagesStructureTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.api.YungJigsawManager;
import com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.adaptations.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.adaptations.EnhancedTerrainAdaptationType;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_4966;
import net.minecraft.class_5434;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import net.minecraft.class_9778;
import net.minecraft.class_9822;

public class VillageWitchStructure
extends YungJigsawStructure {
    public static final int MAX_TOTAL_STRUCTURE_RADIUS = 128;
    public static final MapCodec<VillageWitchStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)VillageWitchStructure.method_42697((RecordCodecBuilder.Instance)builder), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)128).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_6017.method_35004((int)0, (int)15).optionalFieldOf("x_offset_in_chunk", (Object)class_6016.method_34998((int)0)).forGetter(structure -> structure.xOffsetInChunk), (App)class_6017.method_35004((int)0, (int)15).optionalFieldOf("z_offset_in_chunk", (Object)class_6016.method_34998((int)0)).forGetter(structure -> structure.zOffsetInChunk), (App)Codec.BOOL.optionalFieldOf("use_expansion_hack", (Object)false).forGetter(structure -> structure.useExpansionHack), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.INT.optionalFieldOf("max_y").forGetter(structure -> structure.maxY), (App)Codec.INT.optionalFieldOf("min_y").forGetter(structure -> structure.minY), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation), (App)class_9778.field_51952.optionalFieldOf("dimension_padding", (Object)class_9778.field_51953).forGetter(structure -> structure.dimensionPadding), (App)class_9822.field_52239.optionalFieldOf("liquid_settings", (Object)class_9822.field_52238).forGetter(structure -> structure.liquidSettings)).apply((Applicative)builder, VillageWitchStructure::new));
    public final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    public final int maxDepth;
    public final class_6122 startHeight;
    public final class_6017 xOffsetInChunk;
    public final class_6017 zOffsetInChunk;
    public final boolean useExpansionHack;
    public final Optional<class_2902.class_2903> projectStartToHeightmap;
    public final int maxDistanceFromCenter;
    public final Optional<Integer> maxY;
    public final Optional<Integer> minY;
    public final EnhancedTerrainAdaptation enhancedTerrainAdaptation;
    public final class_9778 dimensionPadding;
    public final class_9822 liquidSettings;

    public VillageWitchStructure(class_3195.class_7302 structureSettings, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int maxDepth, class_6122 startHeight, class_6017 xOffsetInChunk, class_6017 zOffsetInChunk, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxBlockDistanceFromCenter, Optional<Integer> maxY, Optional<Integer> minY, EnhancedTerrainAdaptation enhancedTerrainAdaptation, class_9778 dimensionPadding, class_9822 liquidSettings) {
        super(structureSettings, startPool, startJigsawName, maxDepth, startHeight, xOffsetInChunk, zOffsetInChunk, useExpansionHack, projectStartToHeightmap, maxBlockDistanceFromCenter, maxY, minY, enhancedTerrainAdaptation, dimensionPadding, liquidSettings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.xOffsetInChunk = xOffsetInChunk;
        this.zOffsetInChunk = zOffsetInChunk;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxBlockDistanceFromCenter;
        this.maxY = maxY;
        this.minY = minY;
        this.enhancedTerrainAdaptation = enhancedTerrainAdaptation;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        int offsetY = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 blockPos = new class_2338(context.comp_568().method_8326(), offsetY, context.comp_568().method_8328());
        if (!this.extraSpawningChecks(context, blockPos)) {
            return Optional.empty();
        }
        class_1923 chunkPos = context.comp_568();
        class_2919 randomSource = context.comp_566();
        int xOffset = this.xOffsetInChunk.method_35008((class_5819)randomSource);
        int zOffset = this.zOffsetInChunk.method_35008((class_5819)randomSource);
        int startY = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 startPos = new class_2338(chunkPos.method_33939(xOffset), startY, chunkPos.method_33941(zOffset));
        return YungJigsawManager.assembleJigsawStructure((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.maxDepth, (class_2338)startPos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, this.maxY, this.minY, (class_9778)class_5434.field_51911, (class_9822)class_5434.field_52235);
    }

    private boolean extraSpawningChecks(class_3195.class_7149 context, class_2338 blockPos) {
        int checkRadius = 64;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int negativeFluidChecks = 0;
        for (int xOffset = -checkRadius; xOffset <= checkRadius; xOffset += 8) {
            for (int zOffset = -checkRadius; zOffset <= checkRadius; zOffset += 8) {
                int x = xOffset + blockPos.method_10263();
                int z = zOffset + blockPos.method_10260();
                if (xOffset % checkRadius == 0 && zOffset % checkRadius == 0) {
                    class_3195.class_7150 structurePosition = new class_3195.class_7150(new class_2338(x, 68, z), collector -> {});
                    if (!this.isBiomeValid(structurePosition, context.comp_562(), context.comp_564(), arg_0 -> ((class_6885)this.method_41607()).method_40241(arg_0))) {
                        return false;
                    }
                }
                class_4966 blockView = context.comp_562().method_26261(x, z, context.comp_569(), context.comp_564());
                mutable.method_10101((class_2382)blockPos).method_10100(xOffset, -6, zOffset);
                if (!this.isViableBlockState(blockView.method_32892(mutable.method_10264())) || ++negativeFluidChecks <= 64) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isViableBlockState(class_2680 blockState) {
        return !blockState.method_26227().method_15769() && blockState.method_27852(class_2246.field_10124);
    }

    private boolean isBiomeValid(class_3195.class_7150 result, class_2794 chunkGenerator, class_7138 noiseConfig, Predicate<class_6880<class_1959>> validBiomes) {
        class_2338 blockPos = result.comp_571();
        return validBiomes.test((class_6880<class_1959>)chunkGenerator.method_12098().method_38109(class_5742.method_33100((int)blockPos.method_10263()), class_5742.method_33100((int)blockPos.method_10264()), class_5742.method_33100((int)blockPos.method_10260()), noiseConfig.method_42371()));
    }

    public class_7151<?> method_41618() {
        return VillagesAndPillagesStructureTypes.VILLAGE_WITCH_STRUCTURE;
    }
}

