/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.object.FixedNearestVisibleLivingEntities;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class NearbyLivingEntitySensor<E extends class_1309>
extends PredicateSensor<class_1309, E> {
    private static final List<class_4140<?>> MEMORIES = ObjectArrayList.of((Object[])new class_4140[]{class_4140.field_18441, class_4140.field_18442});
    @Nullable
    protected SquareRadius radius = null;

    public NearbyLivingEntitySensor() {
        super((target, entity) -> target != entity && target.method_5805());
    }

    public NearbyLivingEntitySensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyLivingEntitySensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    public List<class_4140<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public class_4149<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEARBY_LIVING_ENTITY.get();
    }

    @Override
    protected void method_19101(class_3218 level, E entity) {
        SquareRadius radius = this.radius;
        if (radius == null) {
            double dist = entity.method_45325(class_5134.field_23717);
            radius = new SquareRadius(dist, dist);
        }
        List<class_1309> entities = EntityRetrievalUtil.getEntities(entity, radius.xzRadius(), radius.yRadius(), radius.xzRadius(), class_1309.class, livingEntity -> this.predicate().test(livingEntity, entity));
        entities.sort(Comparator.comparingDouble(arg_0 -> entity.method_5858(arg_0)));
        BrainUtils.setMemory(entity, class_4140.field_18441, entities);
        BrainUtils.setMemory(entity, class_4140.field_18442, new FixedNearestVisibleLivingEntities((class_1309)entity, entities));
    }
}

