/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5134;
import net.minecraft.class_6025;
import net.minecraft.class_6670;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class TargetOrRetaliate<E extends class_1308>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(4).usesMemories(class_4140.field_22355, class_4140.field_18451, class_4140.field_30243, class_4140.field_18442);
    protected Predicate<class_1309> canAttackPredicate = entity -> {
        if (!entity.method_5805()) return false;
        if (!(entity instanceof class_1657)) return true;
        class_1657 player = (class_1657)entity;
        if (player.method_31549().field_7480) return false;
        return true;
    };
    protected BiPredicate<E, class_1297> alertAlliesPredicate = (owner, attacker) -> false;
    protected BiPredicate<E, class_1309> allyPredicate = (owner, ally) -> {
        class_6025 pet;
        if (!owner.getClass().isAssignableFrom(ally.getClass()) || BrainUtils.getTargetOfEntity(ally) != null) {
            return false;
        }
        if (owner instanceof class_6025 && (pet = (class_6025)owner).method_35057() != ((class_6025)ally).method_35057()) {
            return false;
        }
        class_1297 lastHurtBy = (class_1297)BrainUtils.getMemory(ally, class_4140.field_18452);
        return lastHurtBy == null || !ally.method_5722(lastHurtBy);
    };
    protected boolean canSwapTarget = true;
    protected class_1309 toTarget = null;
    protected class_4140<? extends class_1309> priorityTargetMemory = class_4140.field_30243;

    public TargetOrRetaliate<E> attackablePredicate(Predicate<class_1309> predicate) {
        this.canAttackPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> useMemory(class_4140<? extends class_1309> memory) {
        this.priorityTargetMemory = memory;
        return this;
    }

    public TargetOrRetaliate<E> alertAlliesWhen(BiPredicate<E, class_1297> predicate) {
        this.alertAlliesPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> isAllyIf(BiPredicate<E, class_1309> predicate) {
        this.allyPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> noTargetSwapping() {
        this.canSwapTarget = false;
        return this;
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean doStartCheck(class_3218 level, E entity, long gameTime) {
        return (!BrainUtils.hasMemory(entity, class_4140.field_22355) || this.canSwapTarget && ((class_1308)entity).field_6012 % 100 == 0) && super.doStartCheck(level, entity, gameTime);
    }

    protected boolean checkExtraStartConditions(class_3218 level, E owner) {
        this.toTarget = this.getTarget(owner, level, BrainUtils.getTargetOfEntity(owner));
        return this.toTarget != null;
    }

    @Nullable
    protected class_1309 getTarget(E owner, class_3218 level, @Nullable class_1309 existingTarget) {
        class_4095 brain = owner.method_18868();
        class_1309 newTarget = BrainUtils.getMemory(brain, this.priorityTargetMemory);
        if (newTarget == null && (newTarget = (class_1309)BrainUtils.getMemory(brain, class_4140.field_18452)) == null) {
            class_6670 nearbyEntities = (class_6670)BrainUtils.getMemory(brain, class_4140.field_18442);
            if (nearbyEntities != null) {
                newTarget = nearbyEntities.method_38975(this.canAttackPredicate).orElse(null);
            }
            if (newTarget == null) {
                return null;
            }
        }
        if (newTarget == existingTarget) {
            return null;
        }
        return this.canAttackPredicate.test(newTarget) ? newTarget : null;
    }

    @Override
    protected void start(E entity) {
        class_1309 existingTarget = BrainUtils.getTargetOfEntity(entity);
        BrainUtils.setTargetOfEntity(entity, this.toTarget);
        BrainUtils.clearMemory(entity, class_4140.field_19293);
        if (this.alertAlliesPredicate.test(entity, (class_1297)this.toTarget) && existingTarget == null) {
            this.alertAllies((class_3218)entity.method_37908(), entity);
        }
        this.toTarget = null;
    }

    protected void alertAllies(class_3218 level, E owner) {
        double followRange = owner.method_45325(class_5134.field_23717);
        for (class_1309 ally : EntityRetrievalUtil.getEntities(owner, followRange, 10.0, followRange, class_1309.class, entity -> this.allyPredicate.test(owner, (class_1309)entity))) {
            BrainUtils.setTargetOfEntity(ally, this.toTarget);
        }
    }
}

