/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class InvalidateAttackTarget<E extends class_1309>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(2).hasMemory(class_4140.field_22355).usesMemory(class_4140.field_19293);
    protected BiPredicate<E, class_1309> customPredicate = (entity, target) -> {
        if (target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            if (player.method_31549().field_7480) return true;
        }
        if (!entity.method_6127().method_45331(class_5134.field_23717)) return false;
        if (!(entity.method_5858((class_1297)target) >= Math.pow(entity.method_45325(class_5134.field_23717), 2.0))) return false;
        return true;
    };
    protected long pathfindingAttentionSpan = 200L;

    public InvalidateAttackTarget<E> invalidateIf(BiPredicate<E, class_1309> predicate) {
        this.customPredicate = predicate;
        return this;
    }

    public InvalidateAttackTarget<E> ignoreFailedPathfinding() {
        return this.stopTryingToPathAfter(0L);
    }

    public InvalidateAttackTarget<E> stopTryingToPathAfter(long ticks) {
        this.pathfindingAttentionSpan = ticks;
        return this;
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected void start(E entity) {
        class_1309 target = BrainUtils.getTargetOfEntity(entity);
        if (target == null) {
            return;
        }
        if (this.isTargetInvalid(entity, target) || !this.canAttack(entity, target) || this.isTiredOfPathing(entity) || this.customPredicate.test(entity, target)) {
            BrainUtils.clearMemory(entity, class_4140.field_22355);
        }
    }

    protected boolean isTargetInvalid(E entity, class_1309 target) {
        if (entity.method_37908() != target.method_37908()) {
            return true;
        }
        return target.method_29504() || target.method_31481();
    }

    protected boolean canAttack(E entity, class_1309 target) {
        return entity.method_18395(target);
    }

    protected boolean isTiredOfPathing(E entity) {
        if (this.pathfindingAttentionSpan <= 0L) {
            return false;
        }
        Long time = (Long)BrainUtils.getMemory(entity, class_4140.field_19293);
        return time != null && entity.method_37908().method_8510() - time > this.pathfindingAttentionSpan;
    }
}

