/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.rpgmana.mixin;

import com.cleannrooster.rpgmana.Rpgmana;
import com.cleannrooster.rpgmana.api.ManaInterface;
import com.cleannrooster.rpgmana.api.SpellcostMixinInterface;
import com.cleannrooster.rpgmana.item.ItemInit;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.Ammo;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Ammo.class})
public class AmmoMixin {
    @Inject(at={@At(value="HEAD")}, method={"consume"}, cancellable=true)
    private static void consumeMana(Ammo.Result result, class_1657 player, CallbackInfo callbackInfo) {
        if (result != null && result.item() != null && result.item().matches(ItemInit.MANA.method_7854()) && ((ManaInterface)player).getMana() > 0.0) {
            ((ManaInterface)player).spendMana(-result.consume());
            callbackInfo.cancel();
        }
    }

    private static float getManaCost(class_1657 player, Spell spell, SpellCast.Action action, float progress) {
        if (spell.cost == null) {
            return 0.0f;
        }
        if (spell.cost.item == null) {
            return 0.0f;
        }
        if (!spell.cost.item.id.contains("rune") || spell.cost.item.id.contains("arrow") || spell.cost.item.id.contains("bullet") || spell.cost.item.id.contains("jacket") || spell.cost.item.id.contains("round") || spell.cost.item.id.contains("cartrdge")) {
            return 0.0f;
        }
        float channelMultiplier = 1.0f;
        switch (action) {
            case CHANNEL: {
                channelMultiplier = SpellHelper.channelValueMultiplier((Spell)spell);
                break;
            }
            case RELEASE: {
                channelMultiplier = SpellHelper.isChanneled((Spell)spell) ? 0.0f : (progress >= 1.0f ? 1.0f : 0.0f);
            }
        }
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext(channelMultiplier, 1.0f, (class_243)null, SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)player), SpellTarget.FocusMode.DIRECT, 0);
        float coeff = 0.0f;
        int proj = 1;
        if (spell.impacts != null && ((SpellcostMixinInterface)spell.cost).calculateManaCost()) {
            for (Spell.Impact impact : spell.impacts) {
                if (impact.action == null || impact.action.damage == null) continue;
                coeff += impact.action.damage.spell_power_coefficient;
            }
            if (spell.impacts != null && spell.impacts.size() > 0) {
                coeff /= (float)spell.impacts.size();
            }
            if (spell.release != null && spell.target != null && spell.deliver != null && spell.deliver.projectile != null) {
                proj += spell.deliver.projectile.launch_properties.extra_launch_count;
            }
        }
        float mult = (float)(player.method_45325(Rpgmana.MANA_COST_ATTRIBUTE) * (double)0.01f);
        return mult * context.total() * (((SpellcostMixinInterface)spell.cost).calculateManaCost() ? Math.max(20.0f, 40.0f * coeff * (float)proj) : ((SpellcostMixinInterface)spell.cost).getManaCost());
    }

    private static boolean matches(String subject, String nullableRegex) {
        if (subject == null) {
            return false;
        }
        if (nullableRegex == null || nullableRegex.isEmpty()) {
            return false;
        }
        Pattern pattern = Pattern.compile(nullableRegex, 2);
        Matcher matcher = pattern.matcher(subject);
        return matcher.find();
    }

    @Inject(at={@At(value="HEAD")}, method={"ammoForSpell"}, cancellable=true)
    private static void ammoForSpellRPG(class_1657 player, Spell spell, class_1799 casterStack, CallbackInfoReturnable<Ammo.Result> cir) {
        if (!AmmoMixin.matches(SpellRegistry.from((class_1937)player.method_37908()).method_10221((Object)spell).toString(), Rpgmana.config.blacklist_spell_casting_regex) && spell.active != null && spell.cost != null && spell.cost.item != null && ((ManaInterface)player).getMana() > 0.0 && (AmmoMixin.getManaCost(player, spell, SpellCast.Action.RELEASE, 1.0f) > 0.0f || AmmoMixin.getManaCost(player, spell, SpellCast.Action.CHANNEL, 1.0f) > 0.0f)) {
            cir.setReturnValue((Object)new Ammo.Result(true, Ammo.Searched.from((String)"rpgmana:mana"), (int)AmmoMixin.getManaCost(player, spell, spell.active.cast.channel_ticks == 0 ? SpellCast.Action.RELEASE : SpellCast.Action.CHANNEL, 1.0f), List.of()));
        }
    }
}

