/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.network;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.kleeslabs.registry.SlabRegistry;
import net.blay09.mods.kleeslabs.registry.SlabRegistryData;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;

public class KleeSlabsRegistryMessage
implements class_8710 {
    public static class_8710.class_9154<KleeSlabsRegistryMessage> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"kleeslabs", (String)"registry"));
    private final boolean isFirst;
    private final List<SlabRegistryData> data;

    public KleeSlabsRegistryMessage(boolean isFirst, List<SlabRegistryData> data) {
        this.isFirst = isFirst;
        this.data = data;
    }

    public static void encode(class_2540 buf, KleeSlabsRegistryMessage message) {
        buf.method_52964(message.isFirst);
        buf.method_52998(message.data.size());
        for (SlabRegistryData data : message.data) {
            buf.method_10814(data.getConverterClass().getName());
            buf.method_10812(Balm.getRegistries().getKey(data.getSingleSlab()));
            buf.method_10812(Balm.getRegistries().getKey(data.getDoubleSlab()));
        }
    }

    public static KleeSlabsRegistryMessage decode(class_2540 buf) {
        boolean isFirst = buf.readBoolean();
        int size = buf.readShort();
        ArrayList<SlabRegistryData> data = new ArrayList<SlabRegistryData>();
        for (int i = 0; i < size; ++i) {
            try {
                String converterClassName = buf.method_10800(Short.MAX_VALUE);
                class_2960 singleBlockId = buf.method_10810();
                class_2960 doubleBlockId = buf.method_10810();
                Class<?> converterClass = Class.forName(converterClassName);
                class_2248 singleSlab = Balm.getRegistries().getBlock(singleBlockId);
                class_2248 doubleSlab = Balm.getRegistries().getBlock(doubleBlockId);
                if (singleSlab == null || doubleSlab == null) continue;
                data.add(new SlabRegistryData(converterClass, singleSlab, doubleSlab));
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return new KleeSlabsRegistryMessage(isFirst, data);
    }

    public static void handle(class_1657 player, KleeSlabsRegistryMessage message) {
        if (message.isFirst) {
            SlabRegistry.clearRegistry();
        }
        for (SlabRegistryData data : message.data) {
            SlabRegistry.registerSlab(data);
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

