/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config.dynamic;

import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.player.config.dynamic.PlayerConfigDynamicOptions;
import xaero.pac.common.server.claims.protection.ChunkProtectionExceptionType;
import xaero.pac.common.server.claims.protection.group.ChunkProtectionExceptionGroup;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigListIterationOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigStaticListIterationOptionSpec;

public class PlayerConfigExceptionDynamicOptionsLoader {
    public static final String OPTION_ROOT = "playerConfig.claims.protection.exceptionGroups.";
    public static final String TRANSLATION_ROOT = "gui.xaero_pac_player_config_playerConfig.claims.protection.exceptionGroups.";
    public static final String COMMENT_TRANSLATION_ROOT = "gui.xaero_pac_player_config_tooltip_playerConfig.claims.protection.exceptionGroups.";
    public static final String INTERACT = "interact";
    public static final String HAND_INTERACT = "handInteract";
    public static final String ANY_ITEM_INTERACT = "anyItemInteract";
    public static final String BREAK = "break";
    public static final String BARRIER = "barrier";
    public static final String BLOCK_ACCESS = "blockAccess";
    public static final String BLOCK_BREAK_ACCESS = "blockBreakAccess";
    public static final String BLOCK_INTERACT_ACCESS = "blockInteractAccess";
    public static final String ENTITY_ACCESS = "entityAccess";
    public static final String ENTITY_BREAK_ACCESS = "entityKillAccess";
    public static final String ENTITY_INTERACT_ACCESS = "entityInteractAccess";
    public static final String DROPPED_ITEM_ACCESS = "droppedItemAccess";

    <T> void handleGroup(ChunkProtectionExceptionGroup<T> group, PlayerConfigDynamicOptions.Builder builder, String category, String categoryPlural) {
        String commentTranslation;
        String translation;
        Object comment;
        String optionId;
        String interactionOptionsTooltip = "\n\n1) Party - players or entities owned by players in the same party as you.\n2) Allies - players or entities owned by players in parties that are allied by yours.\n3) Every - all players/entities.";
        if (group.isOfSubjects() && group.getType() == ChunkProtectionExceptionType.INTERACTION) {
            optionId = OPTION_ROOT + category + ".interact";
            comment = "When enabled, claimed chunk protection makes an exception for interaction with the following " + categoryPlural + ": %1$s." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + ".interact";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".interact";
        } else if (group.isOfSubjects() && group.getType() == ChunkProtectionExceptionType.EMPTY_HAND_INTERACTION) {
            optionId = OPTION_ROOT + category + ".handInteract";
            comment = "When enabled, claimed chunk protection makes an exception for interaction with an empty hand with the following " + categoryPlural + ": %1$s." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + ".handInteract";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".handInteract";
        } else if (group.isOfSubjects() && group.getType() == ChunkProtectionExceptionType.ANY_ITEM_INTERACTION) {
            optionId = OPTION_ROOT + category + ".anyItemInteract";
            comment = "When enabled, claimed chunk protection makes an exception for interaction with any item held with the following " + categoryPlural + ": %1$s." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + ".anyItemInteract";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".anyItemInteract";
        } else if (group.isOfSubjects() && group.getType() == ChunkProtectionExceptionType.BREAK) {
            optionId = OPTION_ROOT + category + ".break";
            comment = "When enabled, claimed chunk protection makes an exception for destruction of the following " + categoryPlural + ": %1$s." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + ".break";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".break";
        } else if (group.getType() == ChunkProtectionExceptionType.BARRIER) {
            optionId = OPTION_ROOT + category + ".barrier";
            comment = "When enabled, claimed chunk protection prevents the following additional " + categoryPlural + " from entering the claim (except wilderness): %1$s.\n\n1) Every - protected from all players/entities that don't have chunk access.\n2) Not Party - only players/entities not in the same party as you.\n3) Not Ally - only players/entities not in any party allied by yours.";
            translation = TRANSLATION_ROOT + category + ".barrier";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".barrier";
        } else if (!group.isOfSubjects() && group.getType() == ChunkProtectionExceptionType.FULL) {
            String string = group.getSubjectType() == class_2248.class ? BLOCK_ACCESS : (accessType = group.getSubjectType() == class_1299.class ? ENTITY_ACCESS : DROPPED_ITEM_ACCESS);
            String accessName = group.getSubjectType() == class_2248.class ? "block" : (group.getSubjectType() == class_1299.class ? "entity" : "dropped item");
            optionId = OPTION_ROOT + category + "." + accessType;
            comment = "When enabled, claimed chunk protection makes an exception for unlimited " + accessName + " access by the following " + categoryPlural + ": %1$s. If the " + accessName + " protection is based on the mob griefing rule check, then the claimed neighbor chunks must also allow the " + accessName + " access." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + "." + accessType;
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + "." + accessType;
        } else if (!group.isOfSubjects()) {
            String accessName;
            if (group.getType() == ChunkProtectionExceptionType.BREAK) {
                accessType = group.getSubjectType() == class_2248.class ? BLOCK_BREAK_ACCESS : ENTITY_BREAK_ACCESS;
                accessName = group.getSubjectType() == class_2248.class ? "block breaking" : "entity killing";
            } else {
                accessType = group.getSubjectType() == class_2248.class ? BLOCK_INTERACT_ACCESS : ENTITY_INTERACT_ACCESS;
                accessName = group.getSubjectType() == class_2248.class ? "block interaction" : "entity interaction";
            }
            optionId = OPTION_ROOT + category + "." + accessType;
            comment = "When enabled, claimed chunk protection makes an exception for " + accessName + " by the following " + categoryPlural + ": %1$s. If the " + accessName + " protection is based on the mob griefing rule check, then the claimed neighbor chunks must also allow the " + accessName + "." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + "." + accessType;
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + "." + accessType;
        } else {
            OpenPartiesAndClaims.LOGGER.error("Invalid group type " + String.valueOf((Object)group.getType()) + " for " + category + " exception group " + group.getName());
            return;
        }
        optionId = optionId + "." + group.getName();
        comment = String.format((String)comment, group.getContentString());
        PlayerConfigListIterationOptionSpec option = ((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)PlayerConfigStaticListIterationOptionSpec.Builder.begin(Integer.class).setId(optionId)).setList(PlayerConfig.PROTECTION_LEVELS).setTranslation(translation, group.getName())).setCommentTranslation(commentTranslation, group.getContentString())).setDefaultValue(0)).setComment((String)comment)).setCategory(group.getOptionCategory())).setDynamic(true)).build((Map)null);
        group.setPlayerConfigOption(option);
        builder.addOption(option);
    }
}

