/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.player.config.IPlayerConfigClientStorage;
import xaero.pac.client.player.config.IPlayerConfigClientStorageManager;
import xaero.pac.client.player.config.IPlayerConfigStringableOptionClientStorage;
import xaero.pac.client.player.config.api.IPlayerConfigClientStorageAPI;
import xaero.pac.common.packet.config.PlayerConfigPacket;
import xaero.pac.common.packet.config.PlayerConfigPacketUtil;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public abstract class ClientboundPlayerConfigAbstractStatePacket
extends PlayerConfigPacket {
    private final PlayerConfigType type;
    private final boolean otherPlayer;
    private final String subId;

    protected ClientboundPlayerConfigAbstractStatePacket(PlayerConfigType type, boolean otherPlayer, String subId) {
        this.type = type;
        this.otherPlayer = otherPlayer;
        this.subId = subId;
    }

    public PlayerConfigType getType() {
        return this.type;
    }

    public boolean isOtherPlayer() {
        return this.otherPlayer;
    }

    public String getSubId() {
        return this.subId;
    }

    public static abstract class ClientHandler<P extends ClientboundPlayerConfigAbstractStatePacket>
    implements Consumer<P> {
        protected abstract void accept(P var1, IPlayerConfigClientStorageManager<IPlayerConfigClientStorage<IPlayerConfigStringableOptionClientStorage<?>>> var2, IPlayerConfigClientStorage<IPlayerConfigStringableOptionClientStorage<?>> var3);

        @Override
        public void accept(P t) {
            IPlayerConfigClientStorageManager<IPlayerConfigClientStorage<IPlayerConfigStringableOptionClientStorage<?>>> playerConfigStorageManager = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigStorageManager();
            IPlayerConfigClientStorageAPI storage = PlayerConfigPacketUtil.getTargetConfig(((ClientboundPlayerConfigAbstractStatePacket)t).isOtherPlayer(), ((ClientboundPlayerConfigAbstractStatePacket)t).getType(), playerConfigStorageManager);
            if (storage == null) {
                return;
            }
            String subId = ((ClientboundPlayerConfigAbstractStatePacket)t).getSubId();
            if (subId.isEmpty() || !subId.equals("main") && !storage.subConfigExists(subId)) {
                return;
            }
            storage = storage.getEffectiveSubConfig(subId);
            this.accept(t, playerConfigStorageManager, (IPlayerConfigClientStorage<IPlayerConfigStringableOptionClientStorage<?>>)storage);
        }
    }

    public static abstract class Codec<P extends ClientboundPlayerConfigAbstractStatePacket>
    implements BiConsumer<P, class_2540>,
    Function<class_2540, P> {
        protected abstract P decode(class_2487 var1, PlayerConfigType var2, boolean var3, String var4);

        protected abstract void encode(P var1, class_2487 var2);

        protected abstract int getExtraSizeLimit();

        @Override
        public P apply(class_2540 input) {
            try {
                String subId;
                if (input.readableBytes() > 2048 + this.getExtraSizeLimit()) {
                    return null;
                }
                class_2487 nbt = (class_2487)input.method_30616(class_2505.method_53898());
                if (nbt == null) {
                    return null;
                }
                String typeString = nbt.method_10558("t");
                if (typeString.length() > 100) {
                    OpenPartiesAndClaims.LOGGER.info("Player config type string is too long!");
                    return null;
                }
                PlayerConfigType type = null;
                try {
                    type = PlayerConfigType.valueOf(typeString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (type == null) {
                    OpenPartiesAndClaims.LOGGER.info("Received unknown player config type!");
                    return null;
                }
                boolean otherPlayer = false;
                if (type == PlayerConfigType.PLAYER) {
                    if (!nbt.method_10573("o", 1)) {
                        OpenPartiesAndClaims.LOGGER.info("Unknown player config owner!");
                        return null;
                    }
                    otherPlayer = nbt.method_10577("o");
                }
                if ((subId = nbt.method_10558("si")).length() > 100) {
                    OpenPartiesAndClaims.LOGGER.info("Player config sub ID string is too long!");
                    return null;
                }
                return this.decode(nbt, type, otherPlayer, subId);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(P t, class_2540 u) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("t", ((ClientboundPlayerConfigAbstractStatePacket)t).getType().toString());
            nbt.method_10582("si", ((ClientboundPlayerConfigAbstractStatePacket)t).getSubId());
            if (((ClientboundPlayerConfigAbstractStatePacket)t).getType() == PlayerConfigType.PLAYER) {
                nbt.method_10556("o", ((ClientboundPlayerConfigAbstractStatePacket)t).isOtherPlayer());
            }
            this.encode(t, nbt);
            u.method_10794((class_2520)nbt);
        }
    }
}

