/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundLoadingPacket
extends LazyPacket<ClientboundLoadingPacket> {
    public static final LazyPacket.Encoder<ClientboundLoadingPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    public static final ClientboundLoadingPacket START_PARTY = new ClientboundLoadingPacket(true, false);
    public static final ClientboundLoadingPacket END_PARTY = new ClientboundLoadingPacket(false, false);
    public static final ClientboundLoadingPacket START_CLAIMS = new ClientboundLoadingPacket(true, true);
    public static final ClientboundLoadingPacket END_CLAIMS = new ClientboundLoadingPacket(false, true);
    private final boolean start;
    private final boolean claims;

    private ClientboundLoadingPacket(boolean start, boolean claims) {
        this.start = start;
        this.claims = claims;
    }

    @Override
    protected void writeOnPrepare(class_2540 u) {
        class_2487 tag = new class_2487();
        tag.method_10556("s", this.start);
        tag.method_10556("c", this.claims);
        u.method_10794((class_2520)tag);
    }

    @Override
    protected Function<class_2540, ClientboundLoadingPacket> getDecoder() {
        return DECODER;
    }

    public static class Decoder
    implements Function<class_2540, ClientboundLoadingPacket> {
        @Override
        public ClientboundLoadingPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 1024) {
                    return null;
                }
                class_2487 tag = (class_2487)input.method_30616(class_2505.method_53898());
                if (tag == null) {
                    return null;
                }
                boolean start = tag.method_10577("s");
                boolean claims = tag.method_10577("c");
                return new ClientboundLoadingPacket(start, claims);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundLoadingPacket> {
        @Override
        public void handle(ClientboundLoadingPacket t) {
            if (!t.claims) {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().setLoading(t.start);
            } else {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onLoading(t.start);
            }
        }
    }
}

