/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.bettercombatextension.mixin.client.network;

import com.github.theredbrain.bettercombatextension.BetterCombatExtension;
import com.github.theredbrain.bettercombatextension.BetterCombatExtensionClient;
import com.github.theredbrain.bettercombatextension.bettercombat.DuckWeaponAttributesMixin;
import com.github.theredbrain.bettercombatextension.config.ServerConfig;
import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.List;
import java.util.Optional;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.Platform;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.BetterCombatClientMod;
import net.bettercombat.client.animation.AttackAnimationSubStack;
import net.bettercombat.client.animation.CustomAnimationPlayer;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.client.animation.PoseSubStack;
import net.bettercombat.client.animation.StateCollectionHelper;
import net.bettercombat.client.animation.modifier.HarshAdjustmentModifier;
import net.bettercombat.client.animation.modifier.TransmissionSpeedModifier;
import net.bettercombat.client.compat.FirstPersonAnimationCompatibility;
import net.bettercombat.logic.AnimatedHand;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.mixin.player.LivingEntityAccessor;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerEntity_BetterCombatReplacementMixin
extends class_1657
implements PlayerAttackAnimatable {
    @Unique
    private final AttackAnimationSubStack attackAnimation = new AttackAnimationSubStack(this.createAttackAdjustment());
    @Unique
    private final PoseSubStack mainHandBodyPose = new PoseSubStack((AbstractModifier)this.createPoseAdjustment(), true, true);
    @Unique
    private final PoseSubStack mainHandItemPose = new PoseSubStack((AbstractModifier)null, false, true);
    @Unique
    private final PoseSubStack offHandBodyPose = new PoseSubStack((AbstractModifier)null, true, false);
    @Unique
    private final PoseSubStack offHandItemPose = new PoseSubStack((AbstractModifier)null, false, true);

    public AbstractClientPlayerEntity_BetterCombatReplacementMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(class_638 world, GameProfile profile, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).getAnimationStack();
        stack.addAnimLayer(1, (IAnimation)this.offHandItemPose.base);
        stack.addAnimLayer(2, (IAnimation)this.offHandBodyPose.base);
        stack.addAnimLayer(3, (IAnimation)this.mainHandItemPose.base);
        stack.addAnimLayer(4, (IAnimation)this.mainHandBodyPose.base);
        stack.addAnimLayer(2000, (IAnimation)this.attackAnimation.base);
        this.mainHandBodyPose.configure = this::updateAnimationByCurrentActivity;
        this.offHandBodyPose.configure = this::updateAnimationByCurrentActivity;
    }

    public void updateAnimationsOnTick() {
        AbstractClientPlayerEntity_BetterCombatReplacementMixin player = this;
        boolean isLeftHanded = this.isLeftHanded();
        boolean hasActiveAttackAnimation = this.attackAnimation.base.getAnimation() != null && this.attackAnimation.base.getAnimation().isActive();
        class_1799 mainHandStack = player.method_6047();
        class_1799 offHandStack = player.method_6079();
        if (!(player.field_6252 || player.method_5681() || player.method_6115() || !((Boolean)BetterCombatExtensionClient.CLIENT_CONFIG.enable_poses_while_sprinting.get()).booleanValue() && player.method_5624() || !((Boolean)BetterCombatExtensionClient.CLIENT_CONFIG.enable_poses_while_mounted.get()).booleanValue() && player.method_5854() != null || player.method_6101() || player.method_6128() || Platform.isCastingSpell((class_1657)player) || class_1764.method_7781((class_1799)mainHandStack))) {
            boolean isAlternativeTwoHandedWieldingActive;
            if (hasActiveAttackAnimation) {
                ((LivingEntityAccessor)player).invokeTurnHead(player.method_5791(), 0.0f);
            }
            KeyframeAnimation newMainHandPose = null;
            KeyframeAnimation newOffHandPose = null;
            WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes((class_1799)mainHandStack);
            WeaponAttributes offHandAttributes = WeaponRegistry.getAttributes((class_1799)player.method_6079());
            boolean isWeaponTwoHanded = mainHandAttributes != null && mainHandAttributes.isTwoHanded();
            boolean bl = isAlternativeTwoHandedWieldingActive = mainHandAttributes != null && !mainHandAttributes.isTwoHanded() && offHandStack.method_7960() && (Boolean)BetterCombatExtension.SERVER_CONFIG.empty_offhand_equals_two_handing_mainhand.get() != false;
            if (isWeaponTwoHanded) {
                if (mainHandAttributes.pose() != null) {
                    newMainHandPose = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)class_2960.method_60654((String)mainHandAttributes.pose()));
                }
            } else if (isAlternativeTwoHandedWieldingActive) {
                String two_handed_pose = ((DuckWeaponAttributesMixin)mainHandAttributes).bettercombatextension$getTwoHandedPose();
                if (two_handed_pose != null) {
                    newMainHandPose = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)class_2960.method_60654((String)two_handed_pose));
                }
            } else {
                if (mainHandAttributes != null && mainHandAttributes.pose() != null) {
                    newMainHandPose = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)class_2960.method_60654((String)mainHandAttributes.pose()));
                }
                if (offHandAttributes != null && offHandAttributes.offHandPose() != null) {
                    newOffHandPose = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)class_2960.method_60654((String)offHandAttributes.offHandPose()));
                }
            }
            this.mainHandItemPose.setPose(newMainHandPose, isLeftHanded);
            this.offHandItemPose.setPose(newOffHandPose, isLeftHanded);
            this.mainHandBodyPose.setPose(newMainHandPose, isLeftHanded);
            this.offHandBodyPose.setPose(newOffHandPose, isLeftHanded);
        } else {
            this.mainHandBodyPose.setPose((KeyframeAnimation)null, isLeftHanded);
            this.mainHandItemPose.setPose((KeyframeAnimation)null, isLeftHanded);
            this.offHandBodyPose.setPose((KeyframeAnimation)null, isLeftHanded);
            this.offHandItemPose.setPose((KeyframeAnimation)null, isLeftHanded);
        }
    }

    public void playAttackAnimation(String name, AnimatedHand animatedHand, float length, float upswing) {
        try {
            KeyframeAnimation animation = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)class_2960.method_60654((String)name));
            KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
            this.updateAnimationByCurrentActivity(copy);
            copy.torso.fullyEnablePart(true);
            copy.head.pitch.setEnabled(false);
            float speed = (float)animation.endTick / length;
            boolean mirror = animatedHand.isOffHand();
            if (this.isLeftHanded()) {
                mirror = !mirror;
            }
            int fadeIn = copy.beginTick;
            float upswingSpeed = speed / BetterCombatMod.config.getUpswingMultiplier();
            float downwindSpeed = (float)((double)speed * class_3532.method_16436((double)(Math.max((double)BetterCombatMod.config.getUpswingMultiplier() - 0.5, 0.0) / 0.5), (double)(1.0f - upswing), (double)(upswing / (1.0f - upswing))));
            this.attackAnimation.speed.set(upswingSpeed, List.of(new TransmissionSpeedModifier.Gear(length * upswing, downwindSpeed), new TransmissionSpeedModifier.Gear(length, speed)));
            this.attackAnimation.mirror.setEnabled(mirror);
            CustomAnimationPlayer player = new CustomAnimationPlayer(copy.build(), 0);
            player.setFirstPersonMode(FirstPersonAnimationCompatibility.firstPersonMode());
            player.setFirstPersonConfiguration(this.firstPersonConfig(animatedHand));
            this.attackAnimation.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeIn, (Ease)Ease.INOUTSINE), (IAnimation)player);
        }
        catch (Exception var13) {
            var13.printStackTrace();
        }
    }

    @Unique
    private AdjustmentModifier createAttackAdjustment() {
        return new AdjustmentModifier(partName -> {
            float offsetZ;
            float offsetY;
            float offsetX;
            float rotationZ;
            float rotationY;
            float rotationX;
            block20: {
                float pitch;
                block19: {
                    rotationX = 0.0f;
                    rotationY = 0.0f;
                    rotationZ = 0.0f;
                    offsetX = 0.0f;
                    offsetY = 0.0f;
                    offsetZ = 0.0f;
                    ServerConfig serverConfig = BetterCombatExtension.SERVER_CONFIG;
                    pitch = (Boolean)serverConfig.restrict_attack_pitch.get() != false ? class_3532.method_15363((float)this.method_36455(), (float)(-((Float)serverConfig.attack_pitch_range.get()).floatValue()), (float)((Float)serverConfig.attack_pitch_range.get()).floatValue()) : this.method_36455();
                    pitch = (float)Math.toRadians(pitch);
                    if (!FirstPersonMode.isFirstPersonPass()) break block19;
                    switch (partName) {
                        case "body": {
                            rotationX -= pitch;
                            if (pitch < 0.0f) {
                                double offset = Math.abs(Math.sin(pitch));
                                offsetY = (float)((double)offsetY + offset * 0.5);
                                offsetZ = (float)((double)offsetZ - offset);
                                break;
                            }
                            break block20;
                        }
                        default: {
                            return Optional.empty();
                        }
                    }
                    break block20;
                }
                switch (partName) {
                    case "body": {
                        rotationX -= pitch * 0.75f;
                        break;
                    }
                    case "rightArm": 
                    case "leftArm": {
                        rotationX += pitch * 0.25f;
                        break;
                    }
                    case "rightLeg": 
                    case "leftLeg": {
                        rotationX = (float)((double)rotationX - (double)pitch * 0.75);
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    @Unique
    private AdjustmentModifier createPoseAdjustment() {
        AbstractClientPlayerEntity_BetterCombatReplacementMixin player = this;
        return new HarshAdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (!FirstPersonMode.isFirstPersonPass()) {
                switch (partName) {
                    case "rightArm": 
                    case "leftArm": {
                        if (this.mainHandItemPose.lastAnimationUsesBodyChannel || !player.method_18276()) break;
                        offsetY += 3.0f;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    @Unique
    private void updateAnimationByCurrentActivity(KeyframeAnimation.AnimationBuilder animation) {
        class_4050 pose = this.method_18376();
        switch (pose) {
            case field_18079: {
                StateCollectionHelper.configure((KeyframeAnimation.StateCollection)animation.rightLeg, (boolean)false, (boolean)false);
                StateCollectionHelper.configure((KeyframeAnimation.StateCollection)animation.leftLeg, (boolean)false, (boolean)false);
            }
        }
        if (this.isMounting()) {
            StateCollectionHelper.configure((KeyframeAnimation.StateCollection)animation.rightLeg, (boolean)false, (boolean)false);
            StateCollectionHelper.configure((KeyframeAnimation.StateCollection)animation.leftLeg, (boolean)false, (boolean)false);
        }
    }

    @Unique
    private boolean isWalking() {
        return !this.method_29504() && (this.method_5681() || this.method_18798().method_37267() > 0.03);
    }

    @Unique
    private boolean isMounting() {
        return this.method_5854() != null;
    }

    @Unique
    public boolean isLeftHanded() {
        return this.method_6068() == class_1306.field_6182;
    }

    public void stopAttackAnimation(float length) {
        IAnimation currentAnimation = this.attackAnimation.base.getAnimation();
        if (currentAnimation != null && currentAnimation instanceof KeyframeAnimationPlayer) {
            int fadeOut = Math.round(length);
            this.attackAnimation.adjustmentModifier.fadeOut(fadeOut);
            this.attackAnimation.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeOut, (Ease)Ease.INOUTSINE), (IAnimation)null);
        }
    }

    @Unique
    private FirstPersonConfiguration firstPersonConfig(AnimatedHand animatedHand) {
        boolean showRightItem = true;
        boolean showLeftItem = BetterCombatClientMod.config.isShowingOtherHandFirstPerson || animatedHand == AnimatedHand.TWO_HANDED;
        boolean showRightArm = showRightItem && BetterCombatClientMod.config.isShowingArmsInFirstPerson;
        boolean showLeftArm = showLeftItem && BetterCombatClientMod.config.isShowingArmsInFirstPerson;
        FirstPersonConfiguration config = new FirstPersonConfiguration(showRightArm, showLeftArm, showRightItem, showLeftItem);
        return config;
    }
}

