/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.bettercombatextension.mixin.client;

import com.github.theredbrain.bettercombatextension.BetterCombatExtension;
import com.github.theredbrain.bettercombatextension.bettercombat.DuckWeaponAttributesAttackMixin;
import com.github.theredbrain.bettercombatextension.client.DuckMinecraftClientMixin;
import com.github.theredbrain.bettercombatextension.config.ServerConfig;
import com.github.theredbrain.bettercombatextension.entity.DuckLivingEntityMixin;
import com.github.theredbrain.bettercombatextension.network.packet.AttackStaminaCostPacket;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.Platform;
import net.bettercombat.PlatformClient;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.MinecraftClient_BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.client.BetterCombatClientEvents;
import net.bettercombat.client.BetterCombatClientMod;
import net.bettercombat.client.Keybindings;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.client.collision.TargetFinder;
import net.bettercombat.config.ClientConfigWrapper;
import net.bettercombat.logic.AnimatedHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.mixin.client.MinecraftClientAccessor;
import net.bettercombat.network.Packets;
import net.bettercombat.utils.PatternMatching;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class})
public abstract class MinecraftClient_BetterCombatReplacementMixin
implements MinecraftClient_BetterCombat,
DuckMinecraftClientMixin {
    @Shadow
    public class_638 field_1687;
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    private int field_1752;
    @Shadow
    public int field_1771;
    @Shadow
    @Final
    public class_329 field_1705;
    @Shadow
    @Nullable
    public class_239 field_1765;
    @Unique
    private boolean isHoldingAttackInput = false;
    @Unique
    private boolean isHarvesting = false;
    @Unique
    private class_1799 upswingStack;
    @Unique
    private class_1799 lastAttacedWithItemStack;
    @Unique
    private int upswingTicks = 0;
    @Unique
    private int lastAttacked = 1000;
    @Unique
    private float lastSwingDuration = 0.0f;
    @Unique
    private int comboReset = 0;
    @Unique
    private List<class_1297> targetsInReach = null;

    @Unique
    private class_310 thisClient() {
        return (class_310)this;
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;)V"}, at={@At(value="TAIL")})
    private void disconnect_TAIL(class_437 screen, CallbackInfo ci) {
        BetterCombatClientMod.ENABLED = false;
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_doAttack(CallbackInfoReturnable<Boolean> info) {
        if (BetterCombatClientMod.ENABLED) {
            class_310 client = this.thisClient();
            WeaponAttributes attributes = WeaponRegistry.getAttributes((class_1799)client.field_1724.method_6047());
            if (attributes != null && attributes.attacks() != null) {
                if (this.isTargetingMineableBlock() || this.isHarvesting) {
                    this.isHarvesting = true;
                    return;
                }
                this.startUpswing(attributes);
                info.setReturnValue((Object)false);
                info.cancel();
            }
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_handleBlockBreaking(boolean bl, CallbackInfo ci) {
        if (BetterCombatClientMod.ENABLED) {
            class_310 client = this.thisClient();
            WeaponAttributes attributes = WeaponRegistry.getAttributes((class_1799)client.field_1724.method_6047());
            if (attributes != null && attributes.attacks() != null) {
                boolean isPressed = client.field_1690.field_1886.method_1434();
                if (isPressed && !this.isHoldingAttackInput) {
                    if (this.isTargetingMineableBlock() || this.isHarvesting) {
                        this.isHarvesting = true;
                        return;
                    }
                    ci.cancel();
                }
                if (BetterCombatClientMod.config.isHoldToAttackEnabled && !((Boolean)BetterCombatExtension.SERVER_CONFIG.disable_better_combat_hold_to_attack.get()).booleanValue() && isPressed) {
                    this.isHoldingAttackInput = true;
                    this.startUpswing(attributes);
                    ci.cancel();
                } else {
                    this.isHarvesting = false;
                    this.isHoldingAttackInput = false;
                }
            }
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_doItemUse(CallbackInfo ci) {
        AttackHand hand;
        if (BetterCombatClientMod.ENABLED && (hand = this.getCurrentHand()) != null) {
            double upswingRate = hand.upswingRate();
            if (this.upswingTicks > 0 || (double)this.field_1724.method_7261(0.0f) < 1.0 - upswingRate) {
                ci.cancel();
            }
        }
    }

    @Unique
    private boolean isTargetingMineableBlock() {
        class_1799 itemStack;
        String id;
        if (!BetterCombatClientMod.config.isMiningWithWeaponsEnabled) {
            return false;
        }
        String regex = BetterCombatClientMod.config.mineWithWeaponBlacklist;
        if (regex != null && !regex.isEmpty() && PatternMatching.matches((String)(id = class_7923.field_41178.method_10221((Object)(itemStack = this.field_1724.method_6047()).method_7909()).toString()), (String)regex)) {
            return false;
        }
        if (BetterCombatClientMod.config.isAttackInsteadOfMineWhenEnemiesCloseEnabled && this.hasTargetsInReach()) {
            return false;
        }
        class_310 client = this.thisClient();
        class_239 crosshairTarget = client.field_1765;
        if (crosshairTarget != null && crosshairTarget.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)crosshairTarget;
            class_2338 pos = blockHitResult.method_17777();
            class_2680 clicked = this.field_1687.method_8320(pos);
            if (!this.shouldSwingThruGrass()) {
                return true;
            }
            if (!clicked.method_26220((class_1922)this.field_1687, pos).method_1110() || clicked.method_26214((class_1922)this.field_1687, pos) != 0.0f) {
                return true;
            }
        }
        return false;
    }

    @Unique
    private boolean shouldSwingThruGrass() {
        if (!BetterCombatClientMod.config.isSwingThruGrassEnabled) {
            return false;
        }
        if (BetterCombatClientMod.config.isSwingThruGrassSmart && !this.hasTargetsInReach()) {
            return false;
        }
        String regex = BetterCombatClientMod.config.swingThruGrassBlacklist;
        if (regex != null && !regex.isEmpty()) {
            class_1799 itemStack = this.field_1724.method_6047();
            String id = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
            return !PatternMatching.matches((String)id, (String)regex);
        }
        return true;
    }

    @Unique
    private void startUpswing(WeaponAttributes attributes) {
        AttackHand hand;
        if (!this.field_1724.method_3144() && (hand = this.getCurrentHand()) != null) {
            float upswingRate = (float)hand.upswingRate();
            if (this.upswingTicks <= 0 && this.field_1771 <= 0 && !this.field_1724.method_6115() && !((double)this.field_1724.method_7261(0.0f) < 1.0 - (double)upswingRate)) {
                if (BetterCombatExtension.isStaminaAttributesLoaded && ((DuckWeaponAttributesAttackMixin)hand.attack()).bettercombatextension$getStaminaCostMultiplier() > 0.0f && ((DuckLivingEntityMixin)this.field_1724).bettercombatextension$getAttackStaminaCost() > 0.0f && BetterCombatExtension.getCurrentStamina((class_1309)this.field_1724) <= 0.0f && !this.field_1724.method_7337()) {
                    this.field_1724.method_7353((class_2561)class_2561.method_43471((String)"hud.message.staminaTooLow"), true);
                    return;
                }
                this.field_1724.method_6075();
                this.lastAttacked = 0;
                this.upswingStack = this.field_1724.method_6047();
                float attackCooldownTicksFloat = PlayerAttackHelper.getAttackCooldownTicksCapped((class_1657)this.field_1724);
                int attackCooldownTicks = Math.round(attackCooldownTicksFloat);
                this.comboReset = Math.round(attackCooldownTicksFloat * BetterCombatMod.config.combo_reset_rate);
                this.upswingTicks = Math.max(Math.round(attackCooldownTicksFloat * upswingRate), 1);
                this.lastSwingDuration = attackCooldownTicksFloat;
                this.field_1752 = attackCooldownTicks;
                this.setMiningCooldown(attackCooldownTicks);
                String animationName = hand.attack().animation();
                boolean isOffHand = hand.isOffHand();
                AnimatedHand animatedHand = AnimatedHand.from((boolean)isOffHand, (boolean)attributes.isTwoHanded());
                ((PlayerAttackAnimatable)this.field_1724).playAttackAnimation(animationName, animatedHand, attackCooldownTicksFloat, upswingRate);
                Packets.AttackAnimation packet = new Packets.AttackAnimation(this.field_1724.method_5628(), animatedHand, animationName, attackCooldownTicksFloat, upswingRate);
                Platform.networkC2S_Send((class_8710)packet);
                BetterCombatClientEvents.ATTACK_START.invoke(handler -> handler.onPlayerAttackStart(this.field_1724, hand));
            }
        }
    }

    @Unique
    private void cancelSwingIfNeeded() {
        if (this.upswingStack != null && !MinecraftClient_BetterCombatReplacementMixin.areItemStackEqual(this.field_1724.method_6047(), this.upswingStack)) {
            this.cancelWeaponSwing();
        }
    }

    @Unique
    private void attackFromUpswingIfNeeded() {
        if (this.upswingTicks > 0) {
            --this.upswingTicks;
            if (this.upswingTicks == 0) {
                this.performAttack();
                this.upswingStack = null;
            }
        }
    }

    @Unique
    private void resetComboIfNeeded() {
        if (this.lastAttacked > this.comboReset && this.getComboCount() > 0) {
            this.setComboCount(0);
        }
        if (!PlayerAttackHelper.shouldAttackWithOffHand((class_1657)this.field_1724, (int)this.getComboCount()) && (this.field_1724.method_6047() == null || this.lastAttacedWithItemStack != null && !this.lastAttacedWithItemStack.method_7909().equals(this.field_1724.method_6047().method_7909()))) {
            this.setComboCount(0);
        }
    }

    @Unique
    private boolean shouldUpdateTargetsInReach() {
        if (!BetterCombatClientMod.config.isHighlightCrosshairEnabled && !BetterCombatClientMod.config.isAttackInsteadOfMineWhenEnemiesCloseEnabled) {
            return false;
        }
        return this.targetsInReach == null;
    }

    @Unique
    private void updateTargetsInReach(List<class_1297> targets) {
        this.targetsInReach = targets;
    }

    @Unique
    private void updateTargetsIfNeeded() {
        if (this.shouldUpdateTargetsInReach()) {
            List targets = List.of();
            AttackHand hand = PlayerAttackHelper.getCurrentAttack((class_1657)this.field_1724, (int)this.getComboCount());
            if (hand != null) {
                WeaponAttributes attributes = WeaponRegistry.getAttributes((class_1799)hand.itemStack());
                double range = PlayerAttackHelper.getRangeForItem((class_1657)this.field_1724, (class_1799)hand.itemStack());
                if (attributes != null && attributes.attacks() != null) {
                    targets = TargetFinder.findAttackTargets((class_1657)this.field_1724, (class_1297)this.getCursorTarget(), (WeaponAttributes.Attack)hand.attack(), (double)range);
                }
            }
            this.updateTargetsInReach(targets);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void pre_Tick(CallbackInfo ci) {
        if (this.field_1724 != null) {
            this.targetsInReach = null;
            ++this.lastAttacked;
            this.cancelSwingIfNeeded();
            this.attackFromUpswingIfNeeded();
            this.updateTargetsIfNeeded();
            this.resetComboIfNeeded();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void post_Tick(CallbackInfo ci) {
        if (this.field_1724 != null && Keybindings.toggleMineKeyBinding.method_1436()) {
            BetterCombatClientMod.config.isMiningWithWeaponsEnabled = !BetterCombatClientMod.config.isMiningWithWeaponsEnabled;
            AutoConfig.getConfigHolder(ClientConfigWrapper.class).save();
            String message = class_1074.method_4662((String)(BetterCombatClientMod.config.isMiningWithWeaponsEnabled ? "hud.bettercombat.mine_with_weapons_on" : "hud.bettercombat.mine_with_weapons_off"), (Object[])new Object[0]);
            this.field_1705.method_1758((class_2561)class_2561.method_43470((String)message), false);
        }
    }

    @Unique
    private void performAttack() {
        ServerConfig serverConfig = BetterCombatExtension.SERVER_CONFIG;
        if (this.field_1724 != null) {
            if (Keybindings.feintKeyBinding.method_1434()) {
                this.field_1724.method_7350();
                this.cancelWeaponSwing();
                AttackHand hand = this.getCurrentHand();
                if (hand != null && BetterCombatExtension.isStaminaAttributesLoaded) {
                    ClientPlayNetworking.send((class_8710)new AttackStaminaCostPacket(((DuckLivingEntityMixin)this.field_1724).bettercombatextension$getAttackStaminaCost() * ((DuckWeaponAttributesAttackMixin)hand.attack()).bettercombatextension$getStaminaCostMultiplier() * ((Float)serverConfig.global_feint_stamina_cost_multiplier.get()).floatValue()));
                }
                if (((Boolean)serverConfig.feinting_increases_combo_count.get()).booleanValue()) {
                    this.setComboCount(this.getComboCount() + 1);
                }
            } else {
                AttackHand hand = this.getCurrentHand();
                if (hand != null) {
                    WeaponAttributes.Attack attack = hand.attack();
                    if (BetterCombatExtension.isStaminaAttributesLoaded) {
                        ClientPlayNetworking.send((class_8710)new AttackStaminaCostPacket(((DuckLivingEntityMixin)this.field_1724).bettercombatextension$getAttackStaminaCost() * ((DuckWeaponAttributesAttackMixin)attack).bettercombatextension$getStaminaCostMultiplier() * ((Float)serverConfig.global_attack_stamina_cost_multiplier.get()).floatValue()));
                    }
                    double upswingRate = hand.upswingRate();
                    if (!((double)this.field_1724.method_7261(0.0f) < 1.0 - upswingRate)) {
                        class_1297 cursorTarget = this.getCursorTarget();
                        double range = PlayerAttackHelper.getRangeForItem((class_1657)this.field_1724, (class_1799)hand.itemStack());
                        List targets = TargetFinder.findAttackTargets((class_1657)this.field_1724, (class_1297)cursorTarget, (WeaponAttributes.Attack)attack, (double)range);
                        this.updateTargetsInReach(targets);
                        if (targets.size() == 0) {
                            PlatformClient.onEmptyLeftClick((class_1657)this.field_1724);
                            if (this.field_1765.method_17783() == class_239.class_240.field_1332) {
                                class_3965 blockHitResult = (class_3965)this.field_1765;
                                class_2338 pos = blockHitResult.method_17777();
                                Packets.C2S_BlockHit packet = new Packets.C2S_BlockHit(pos);
                                Platform.networkC2S_Send((class_8710)packet);
                            }
                        }
                        Packets.C2S_AttackRequest packet = new Packets.C2S_AttackRequest(this.getComboCount(), this.field_1724.method_5715(), this.field_1724.method_31548().field_7545, cursorTarget, targets);
                        Platform.networkC2S_Send((class_8710)packet);
                        for (class_1297 target : targets) {
                            this.field_1724.method_7324(target);
                        }
                        this.field_1724.method_7350();
                        BetterCombatClientEvents.ATTACK_HIT.invoke(handler -> handler.onPlayerAttackStart(this.field_1724, hand, targets, cursorTarget));
                        this.setComboCount(this.getComboCount() + 1);
                        if (!hand.isOffHand()) {
                            this.lastAttacedWithItemStack = hand.itemStack();
                        }
                    }
                }
            }
        }
    }

    @Unique
    private AttackHand getCurrentHand() {
        return PlayerAttackHelper.getCurrentAttack((class_1657)this.field_1724, (int)this.getComboCount());
    }

    @Override
    public class_1268 bettercombatextension$getCurrentAttackHand() {
        return this.getCurrentHand() != null && this.getCurrentHand().isOffHand() ? class_1268.field_5810 : class_1268.field_5808;
    }

    @Unique
    private void setComboCount(int comboCount) {
        ((PlayerAttackProperties)this.field_1724).setComboCount(comboCount);
    }

    @Unique
    private static boolean areItemStackEqual(class_1799 left, class_1799 right) {
        if (left == null && right == null) {
            return true;
        }
        return left != null && right != null ? class_1799.method_7973((class_1799)left, (class_1799)right) : false;
    }

    @Unique
    private void setMiningCooldown(int ticks) {
        class_310 client = this.thisClient();
        ((MinecraftClientAccessor)client).setAttackCooldown(ticks);
    }

    @Unique
    private void cancelWeaponSwing() {
        int downWind = (int)Math.round((double)PlayerAttackHelper.getAttackCooldownTicksCapped((class_1657)this.field_1724) * (1.0 - 0.5 * (double)BetterCombatMod.config.upswing_multiplier));
        ((PlayerAttackAnimatable)this.field_1724).stopAttackAnimation((float)downWind);
        Packets.AttackAnimation packet = Packets.AttackAnimation.stop((int)this.field_1724.method_5628(), (int)downWind);
        Platform.networkC2S_Send((class_8710)packet);
        this.upswingStack = null;
        this.field_1752 = 0;
        this.setMiningCooldown(0);
    }

    public int getComboCount() {
        return ((PlayerAttackProperties)this.field_1724).getComboCount();
    }

    public boolean hasTargetsInReach() {
        return this.targetsInReach != null && !this.targetsInReach.isEmpty();
    }

    public float getSwingProgress() {
        return !((float)this.lastAttacked > this.lastSwingDuration) && !(this.lastSwingDuration <= 0.0f) ? (float)this.lastAttacked / this.lastSwingDuration : 1.0f;
    }

    public int getUpswingTicks() {
        return this.upswingTicks;
    }

    public void cancelUpswing() {
        if (this.upswingTicks > 0) {
            this.cancelWeaponSwing();
        }
    }
}

