/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.bettercombatextension.config;

import com.github.theredbrain.bettercombatextension.BetterCombatExtension;
import me.fzzyhmstrs.fzzy_config.annotations.Comment;
import me.fzzyhmstrs.fzzy_config.annotations.ConvertFrom;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedBoolean;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;

@ConvertFrom(fileName="server.json5", folder="bettercombatextension")
public class ServerConfig
extends Config {
    @Comment(value="When set to true, changing the players orientation and position while attacking is disabled.\nIt is recommended to install Shoulder Surfing Reloaded, play in the third person perspective and activate the decoupled camera setting.\nSince the movement_multiplier setting in the Better Combat server config has no effect when this is set to true, it is recommended to set it to its default of 1.0.\nUse the item tag \"disables_movement_locking_during_attack\" and the entity type tag \"disables_movement_locking_when_ridden\" to control when the movement locking is applied.\n\nDefault: false\n")
    public ValidatedBoolean enable_movement_locking_attacks = new ValidatedBoolean(false);
    @Comment(value="When set to true, jumping is disabled during attacks.\nUse the item tag \"disables_jump_restriction_during_attack\" and the entity type tag \"disables_jump_restriction_when_ridden\" to control when the jump restriction is applied.\n\nDefault: false\n")
    public ValidatedBoolean enable_jump_restriction_during_attacks = new ValidatedBoolean(false);
    @Comment(value="When set to true, the pitch of the players attack is restricted.\n\nDefault: false\n")
    public ValidatedBoolean restrict_attack_pitch = new ValidatedBoolean(false);
    @Comment(value="Only has an effect when 'restrict_attack_pitch' is set to 'true'.\nDescribes the angle from 0, which means the final range is from -'attack_pitch_range' to 'attack_pitch_range'.\n\nDefault: 15.0\n")
    public ValidatedFloat attack_pitch_range = new ValidatedFloat(15.0f);
    @Comment(value="Enables an alternative two_handed condition.\nIf the offhand stack is empty and this is true, the mainhand stack is two_handed\nThis is not active if the \"two_handed\" field in the weapon_attribute file is set to true.\n\nDefault: false\n")
    public ValidatedBoolean empty_offhand_equals_two_handing_mainhand = new ValidatedBoolean(false);
    public ValidatedBoolean enable_attack_range_attribute_integration = new ValidatedBoolean(true);
    @Comment(value="Disables Better Combat's formerly client feature of continuously attacking while holding down the attack key.\n\nDefault: false\n")
    public ValidatedBoolean disable_better_combat_hold_to_attack = new ValidatedBoolean(false);
    @Comment(value="When set to true, feinting an attack skips it.\n\nDefault: false\n")
    public ValidatedBoolean feinting_increases_combo_count = new ValidatedBoolean(false);
    @Comment(value="\n\nThe stamina cost of all attacks is multiplied with this value when the attack is feinted.\n\nDefault: 1.0\n")
    public ValidatedFloat global_feint_stamina_cost_multiplier = new ValidatedFloat(1.0f);
    @Comment(value="The stamina cost of all attacks is multiplied with this value when the attack is executed.\n\nDefault: 1.0\n")
    public ValidatedFloat global_attack_stamina_cost_multiplier = new ValidatedFloat(1.0f);
    @Comment(value="The global movement speed modifier while attacking is clamped by these two values.\n")
    public ValidatedFloat minimum_global_attack_movement_speed_multiplier = new ValidatedFloat(0.0f);
    public ValidatedFloat maximum_global_attack_movement_speed_multiplier = new ValidatedFloat(1.0f);
    @Comment(value="The attack specific movement speed modifiers are clamped by these two values.\n")
    public ValidatedFloat minimum_attack_specific_movement_speed_multiplier = new ValidatedFloat(0.0f);
    public ValidatedFloat maximum_attack_specific_movement_speed_multiplier = new ValidatedFloat(1.0f);
    @Comment(value="Better Combat Extension fixes an incompatibility between Better Combats offhand attacking and RPG Inventory's hand slot overhaul.\n\nThis fix is only active when RPG Inventory is installed and the hand slot overhaul is enabled.\n\nThis setting can disables the fix completely.\n\nWARNING:\nSetting this option to false will disable the RPG Inventory hand slot overhaul. This is done to prevent item duplication glitches.\n\nDefault: true\n")
    public ValidatedBoolean enable_experimental_swap_hand_attributes_algorithm = new ValidatedBoolean(true);

    public ServerConfig() {
        super(BetterCombatExtension.identifier("server"));
    }
}

