/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.bettercombatextension;

import com.github.theredbrain.bettercombatextension.compat.AttackRangeAttributeCompat;
import com.github.theredbrain.bettercombatextension.compat.RPGInventoryCompat;
import com.github.theredbrain.bettercombatextension.compat.StaminaAttributesCompat;
import com.github.theredbrain.bettercombatextension.config.ServerConfig;
import com.github.theredbrain.bettercombatextension.network.packet.AttackStaminaCostPacket;
import com.github.theredbrain.bettercombatextension.network.packet.AttackStaminaCostPacketReceiver;
import com.github.theredbrain.bettercombatextension.network.packet.CancelAttackPacket;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetterCombatExtension
implements ModInitializer {
    public static final String MOD_ID = "bettercombatextension";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"bettercombatextension");
    public static ServerConfig SERVER_CONFIG;
    public static final boolean isAttackRangeAttributeLoaded;
    public static final boolean isRPGInventoryLoaded;
    public static final boolean isShoulderSurfingLoaded;
    public static final boolean isStaminaAttributesLoaded;
    public static class_6880<class_1320> ATTACK_STAMINA_COST;
    public static final class_6862<class_1299<?>> DISABLES_JUMP_RESTRICTION_WHEN_RIDDEN;
    public static final class_6862<class_1299<?>> DISABLES_MOVEMENT_LOCKING_WHEN_RIDDEN;
    public static final class_6862<class_1792> DISABLES_JUMP_RESTRICTION_DURING_ATTACK;
    public static final class_6862<class_1792> DISABLES_MOVEMENT_LOCKING_DURING_ATTACK;
    public static final class_6862<class_1792> IGNORES_ATTACK_MOVEMENT_PENALTY;
    public static final class_6862<class_1792> EMPTY_HAND_WEAPONS;

    public static double getAttackRange(class_1657 playerEntity) {
        if (isAttackRangeAttributeLoaded && ((Boolean)BetterCombatExtension.SERVER_CONFIG.enable_attack_range_attribute_integration.get()).booleanValue()) {
            return AttackRangeAttributeCompat.getAttackRange(playerEntity);
        }
        return playerEntity.method_55755();
    }

    public static class_6880<class_1320> getAttackRangeAttribute() {
        if (isAttackRangeAttributeLoaded && ((Boolean)BetterCombatExtension.SERVER_CONFIG.enable_attack_range_attribute_integration.get()).booleanValue()) {
            return AttackRangeAttributeCompat.getAttackRangeAttribute();
        }
        return class_5134.field_47759;
    }

    public static double getAttackRangeBaseValue(class_1657 playerEntity) {
        if (isAttackRangeAttributeLoaded && ((Boolean)BetterCombatExtension.SERVER_CONFIG.enable_attack_range_attribute_integration.get()).booleanValue()) {
            return AttackRangeAttributeCompat.getAttackRangeBaseValue(playerEntity);
        }
        return playerEntity.method_45326(class_5134.field_47759);
    }

    public static boolean isRPGInventoryHandSlotOverhaulActive() {
        if (isRPGInventoryLoaded) {
            return RPGInventoryCompat.isHandSlotOverhaulActive();
        }
        return false;
    }

    public static void setRPGInventoryMainHandSlot(class_1661 playerInventory, class_1799 itemStack) {
        if (isRPGInventoryLoaded) {
            RPGInventoryCompat.setMainHandSlot(playerInventory, itemStack);
        } else {
            playerInventory.field_7547.set(playerInventory.field_7545, (Object)itemStack);
        }
    }

    public static boolean shouldAlternativeHandSwapAlgorithmBeEnabled() {
        return BetterCombatExtension.isRPGInventoryHandSlotOverhaulActive() && (Boolean)BetterCombatExtension.SERVER_CONFIG.enable_experimental_swap_hand_attributes_algorithm.get() != false;
    }

    public static float getCurrentStamina(class_1309 livingEntity) {
        float currentStamina = 0.0f;
        if (isStaminaAttributesLoaded) {
            currentStamina = StaminaAttributesCompat.getCurrentStamina(livingEntity);
        }
        return currentStamina;
    }

    public static void addStamina(class_1309 livingEntity, float amount) {
        if (isStaminaAttributesLoaded) {
            StaminaAttributesCompat.addStamina(livingEntity, amount);
        }
    }

    public void onInitialize() {
        LOGGER.info("BetterCombat was extended!");
        SERVER_CONFIG = (ServerConfig)ConfigApiJava.registerAndLoadConfig(ServerConfig::new, (RegisterType)RegisterType.BOTH);
        PayloadTypeRegistry.playS2C().register(CancelAttackPacket.PACKET_ID, CancelAttackPacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(AttackStaminaCostPacket.PACKET_ID, AttackStaminaCostPacket.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(AttackStaminaCostPacket.PACKET_ID, (ServerPlayNetworking.PlayPayloadHandler)new AttackStaminaCostPacketReceiver());
    }

    public static class_2960 identifier(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    static {
        isAttackRangeAttributeLoaded = FabricLoader.getInstance().isModLoaded("minecrawl");
        isRPGInventoryLoaded = FabricLoader.getInstance().isModLoaded("rpginventory");
        isShoulderSurfingLoaded = FabricLoader.getInstance().isModLoaded("shouldersurfing");
        isStaminaAttributesLoaded = FabricLoader.getInstance().isModLoaded("staminaattributes");
        DISABLES_JUMP_RESTRICTION_WHEN_RIDDEN = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)BetterCombatExtension.identifier("disables_jump_restriction_when_ridden"));
        DISABLES_MOVEMENT_LOCKING_WHEN_RIDDEN = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)BetterCombatExtension.identifier("disables_movement_locking_when_ridden"));
        DISABLES_JUMP_RESTRICTION_DURING_ATTACK = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)BetterCombatExtension.identifier("disables_jump_restriction_during_attack"));
        DISABLES_MOVEMENT_LOCKING_DURING_ATTACK = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)BetterCombatExtension.identifier("disables_movement_locking_during_attack"));
        IGNORES_ATTACK_MOVEMENT_PENALTY = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)BetterCombatExtension.identifier("ignores_attack_movement_penalty"));
        EMPTY_HAND_WEAPONS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)BetterCombatExtension.identifier("empty_hand_weapons"));
    }
}

