/*
 * Decompiled with CFR 0.152.
 */
package elocindev.customentityattributes.event;

import elocindev.customentityattributes.CustomEntityAttributes;
import elocindev.customentityattributes.api.AdvancedEntityAttributeHolder;
import elocindev.customentityattributes.api.BasicEntityAttributeHolder;
import elocindev.customentityattributes.api.GenericAttribute;
import elocindev.customentityattributes.api.InvalidAttributeException;
import elocindev.customentityattributes.config.CEAAdvancedConfig;
import elocindev.customentityattributes.config.CEABasicConfig;
import elocindev.necronomicon.api.NecUtilsAPI;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class EntityLoadCallback {
    public static void register() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                float old_hp = livingEntity.method_6063();
                float old_percentage = livingEntity.method_6032() / old_hp;
                EntityLoadCallback.applyBasicConfig(livingEntity, old_hp, old_percentage);
                EntityLoadCallback.applyAdvancedConfig(livingEntity, old_hp, old_percentage);
            }
        });
    }

    public static void applyBasicConfig(class_1309 livingEntity, float old_hp, float old_percentage) {
        CEABasicConfig basic = CustomEntityAttributes.BASIC_CONFIG;
        for (BasicEntityAttributeHolder property : basic.modifiers) {
            String ent_regex = property.entity_regex;
            if (!EntityLoadCallback.isValid(NecUtilsAPI.getEntityId((class_1297)livingEntity), ent_regex)) continue;
            for (GenericAttribute<String, ?> attribute : property.attributes) {
                try {
                    class_1324 instance;
                    if (property.apply_chance < 100.0f && Math.random() * 100.0 > (double)property.apply_chance) continue;
                    UUID uuid = UUID.nameUUIDFromBytes(("cea" + attribute.toString() + attribute.getOperation().method_56082() + (int)attribute.getDouble()).getBytes());
                    if (class_7923.field_41190.method_55841(class_2960.method_12829((String)attribute.getString())).isEmpty() || (instance = livingEntity.method_5996((class_6880)class_7923.field_41190.method_55841(class_2960.method_12829((String)attribute.getString())).get())) == null) continue;
                    instance.method_6200(class_2960.method_60655((String)"customentityattributes", (String)uuid.toString()));
                    instance.method_26835(new class_1322(class_2960.method_60655((String)"customentityattributes", (String)uuid.toString()), attribute.getDouble(), attribute.getOperation()));
                }
                catch (InvalidAttributeException e) {
                    e.printStackTrace();
                }
            }
            float final_hp = livingEntity.method_6063();
            if (old_hp == final_hp) continue;
            livingEntity.method_6033(final_hp * old_percentage);
        }
    }

    public static void applyAdvancedConfig(class_1309 livingEntity, float old_hp, float old_percentage) {
        CEAAdvancedConfig config = CustomEntityAttributes.ADVANCED_CONFIG;
        class_1937 world = livingEntity.method_5770();
        String entityId = NecUtilsAPI.getEntityId((class_1297)livingEntity);
        String dimensionId = world.method_27983().method_29177().toString();
        String biomeId = ((class_5321)world.method_23753(livingEntity.method_24515()).method_40230().get()).method_29177().toString();
        String difficulty = world.method_8407().method_5460();
        for (AdvancedEntityAttributeHolder property : config.advanced_modifiers) {
            if (!EntityLoadCallback.isValid(entityId, property.entity_regex) || !EntityLoadCallback.isValid(dimensionId, property.dimension_regex) || !EntityLoadCallback.isValid(biomeId, property.biome_regex) || !EntityLoadCallback.isValidDifficulty(world, difficulty, property.difficulty_regex) || !livingEntity.method_6109() && property.only_apply_to_babies) continue;
            for (GenericAttribute<String, ?> attribute : property.attributes) {
                try {
                    class_1324 instance;
                    if (property.apply_chance < 100.0f && Math.random() * 100.0 > (double)property.apply_chance || world.method_8530() && property.time_regex.equals("night") || world.method_23886() && property.time_regex.equals("day")) continue;
                    UUID uuid = UUID.nameUUIDFromBytes(("cea" + attribute.toString() + attribute.getOperation().method_56082() + (int)attribute.getDouble()).getBytes());
                    System.out.println(attribute.getAttribute().toString());
                    if (class_7923.field_41190.method_55841(class_2960.method_12829((String)attribute.getString())).isEmpty() || (instance = livingEntity.method_5996((class_6880)class_7923.field_41190.method_55841(class_2960.method_12829((String)attribute.getString())).get())) == null) continue;
                    instance.method_6200(class_2960.method_60655((String)"customentityattributes", (String)uuid.toString()));
                    instance.method_26835(new class_1322(class_2960.method_60655((String)"customentityattributes", (String)uuid.toString()), attribute.getDouble(), attribute.getOperation()));
                }
                catch (InvalidAttributeException e) {
                    e.printStackTrace();
                }
            }
            float final_hp = livingEntity.method_6063();
            if (old_hp != final_hp && property.default_hp == -1.0) {
                livingEntity.method_6033(final_hp * old_percentage);
                continue;
            }
            if (property.default_hp == -1.0) continue;
            livingEntity.method_6033((float)property.default_hp);
        }
    }

    public static boolean isValidDifficulty(class_1937 world, String source, String regex) {
        if (("hard_only".equals(regex) || "hard_only".matches(regex)) && world.method_8401().method_152()) {
            return false;
        }
        if ("hardcore".matches(regex) && world.method_8401().method_152()) {
            return true;
        }
        return EntityLoadCallback.isValid(source, regex);
    }

    public static boolean isValid(String source, String regex) {
        if (regex.equals("*")) {
            return true;
        }
        return source.equals(regex) || source.matches(regex);
    }
}

