/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.rpg_minibosses.data;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.api.tags.SpellEngineItemTags;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;
import net.spell_power.api.SpellPowerTags;

public class RPGMINIDatagen {
    @SafeVarargs
    public static <E> List<E> combine(List<E> ... smallLists) {
        ArrayList<E> bigList = new ArrayList<E>();
        for (List<E> list : smallLists) {
            bigList.addAll(list);
        }
        return bigList;
    }

    public static abstract class ItemTagGenerator
    extends FabricTagProvider<class_1792> {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41197, registriesFuture);
        }

        public void generateWeaponTags(List<Weapon.Entry> weapons) {
            for (Weapon.Entry weapon : weapons) {
                String lootTheme;
                class_6862 weaponType = RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)weapon.category());
                FabricTagProvider.FabricTagBuilder weaponTag = this.getOrCreateTagBuilder(weaponType);
                weaponTag.addOptional(weapon.id());
                int tier = weapon.lootProperties().tier();
                if (tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)tier, (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.WEAPONS));
                    tierTag.addOptional(weapon.id());
                }
                if ((lootTheme = weapon.lootProperties().theme()) == null || lootTheme.isEmpty()) continue;
                FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get((String)lootTheme));
                themeTag.addOptional(weapon.id());
            }
        }

        public void generateArmorTags(List<Armor.Entry> armors) {
            this.generateArmorTags(armors, EnumSet.noneOf(RPGSeriesItemTags.ArmorMetaType.class));
        }

        public void generateArmorTags(List<Armor.Entry> armors, RPGSeriesDataGen.ItemTagGenerator.ArmorOptions options) {
            this.generateArmorTags(armors, EnumSet.noneOf(RPGSeriesItemTags.ArmorMetaType.class), options);
        }

        public void generateArmorTags(List<Armor.Entry> armors, RPGSeriesItemTags.ArmorMetaType metaType) {
            this.generateArmorTags(armors, EnumSet.of(metaType));
        }

        public void generateArmorTags(List<Armor.Entry> armors, RPGSeriesItemTags.ArmorMetaType metaType, RPGSeriesDataGen.ItemTagGenerator.ArmorOptions options) {
            this.generateArmorTags(armors, EnumSet.of(metaType), options);
        }

        public void generateArmorTags(List<Armor.Entry> armors, EnumSet<RPGSeriesItemTags.ArmorMetaType> metaTypes) {
            this.generateArmorTags(armors, metaTypes, RPGSeriesDataGen.ItemTagGenerator.ArmorOptions.DEFAULT);
        }

        public void generateArmorTags(List<Armor.Entry> armors, EnumSet<RPGSeriesItemTags.ArmorMetaType> metaTypes, RPGSeriesDataGen.ItemTagGenerator.ArmorOptions options) {
            for (Armor.Entry armor : armors) {
                Armor.Set set = armor.armorSet();
                FabricTagProvider.FabricTagBuilder chestTag = this.getOrCreateTagBuilder(class_3489.field_48296);
                chestTag.add((Object)set.chest);
                FabricTagProvider.FabricTagBuilder legsTag = this.getOrCreateTagBuilder(class_3489.field_48295);
                legsTag.add((Object)set.legs);
                int tier = armor.lootProperties().tier();
                if (options.allowLootTierTags() && tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)tier, (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.ARMORS));
                    for (Object id : armor.armorSet().pieceIds()) {
                        tierTag.addOptional((class_2960)id);
                    }
                }
                String lootTheme = armor.lootProperties().theme();
                if (options.allowLootThemeTags() && lootTheme != null && !lootTheme.isEmpty()) {
                    Object id;
                    FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get((String)lootTheme));
                    id = armor.armorSet().pieceIds().iterator();
                    while (id.hasNext()) {
                        Object id2 = id.next();
                        themeTag.addOptional((class_2960)id2);
                    }
                }
                for (RPGSeriesItemTags.ArmorMetaType metaType : metaTypes) {
                    FabricTagProvider.FabricTagBuilder metaTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.ArmorType.get((RPGSeriesItemTags.ArmorMetaType)metaType));
                    for (Object id : armor.armorSet().pieceIds()) {
                        metaTag.addOptional((class_2960)id);
                    }
                }
            }
        }

        public void generateBowTags(List<RPGSeriesDataGen.BowEntry> bows) {
            for (RPGSeriesDataGen.BowEntry entry : bows) {
                class_2960 id = entry.id();
                class_6862 weaponType = RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)entry.weaponType());
                FabricTagProvider.FabricTagBuilder weaponTag = this.getOrCreateTagBuilder(weaponType);
                weaponTag.addOptional(id);
            }
            this.generateLootTags(bows.stream().collect(Collectors.toMap(RPGSeriesDataGen.BowEntry::id, RPGSeriesDataGen.BowEntry::lootProperties)), RPGSeriesItemTags.LootCategory.WEAPONS);
        }

        public void generateShieldTags(List<RPGSeriesDataGen.ShieldEntry> shields) {
            for (RPGSeriesDataGen.ShieldEntry entry : shields) {
                class_2960 id = entry.id();
                class_6862 weaponType = RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)Equipment.WeaponType.SHIELD);
                FabricTagProvider.FabricTagBuilder weaponTag = this.getOrCreateTagBuilder(weaponType);
                weaponTag.addOptional(id);
            }
            this.generateLootTags(shields.stream().collect(Collectors.toMap(RPGSeriesDataGen.ShieldEntry::id, RPGSeriesDataGen.ShieldEntry::lootProperties)), RPGSeriesItemTags.LootCategory.WEAPONS);
        }

        public void generateAccessoryTags(Map<class_2960, Equipment.LootProperties> accessories) {
            this.generateLootTags(accessories, RPGSeriesItemTags.LootCategory.ACCESSORIES);
        }

        public void generateRelicTags(Map<class_2960, Equipment.LootProperties> relics) {
            this.generateLootTags(relics, RPGSeriesItemTags.LootCategory.RELICS);
        }

        public void generateLootTags(Map<class_2960, Equipment.LootProperties> items, RPGSeriesItemTags.LootCategory category) {
            for (Map.Entry<class_2960, Equipment.LootProperties> entry : items.entrySet()) {
                String lootTheme;
                class_2960 id = entry.getKey();
                Equipment.LootProperties lootProperties = entry.getValue();
                int tier = lootProperties.tier();
                if (tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)tier, (RPGSeriesItemTags.LootCategory)category));
                    tierTag.addOptional(id);
                }
                if ((lootTheme = lootProperties.theme()) == null || lootTheme.isEmpty()) continue;
                FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get((String)lootTheme));
                themeTag.addOptional(id);
            }
        }

        public record ArmorOptions(boolean allowLootTierTags, boolean allowLootThemeTags) {
            public static final RPGSeriesDataGen.ItemTagGenerator.ArmorOptions DEFAULT = new RPGSeriesDataGen.ItemTagGenerator.ArmorOptions(true, true);
        }
    }

    public record BowEntry(class_2960 id, Equipment.WeaponType weaponType, Equipment.LootProperties lootProperties) {
    }

    public record ShieldEntry(class_2960 id, Equipment.LootProperties lootProperties) {
    }

    public static class BaselineTagGenerator
    extends FabricTagProvider<class_1792> {
        public BaselineTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41197, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            FabricTagProvider.FabricTagBuilder tag;
            for (Map.Entry entry : RPGSeriesItemTags.WeaponType.ALL.entrySet()) {
                this.getOrCreateTagBuilder((class_6862)entry.getValue());
            }
            for (RPGSeriesItemTags.RoleArchetype archetype : RPGSeriesItemTags.RoleArchetype.values()) {
                FabricTagProvider.FabricTagBuilder tag2 = this.getOrCreateTagBuilder(RPGSeriesItemTags.Archetype.tag((RPGSeriesItemTags.RoleArchetype)archetype));
                for (Map.Entry entry : RPGSeriesItemTags.WeaponType.ALL.entrySet()) {
                    if (RPGSeriesItemTags.Archetype.classify((Equipment.WeaponType)((Equipment.WeaponType)entry.getKey())) != archetype) continue;
                    tag2.addTag((class_6862)entry.getValue());
                }
            }
            for (Map.Entry entry : RPGSeriesItemTags.LootThemes.ALL.entrySet()) {
                this.getOrCreateTagBuilder((class_6862)entry.getValue());
            }
            for (int i = 0; i < 10; ++i) {
                for (RPGSeriesItemTags.LootCategory category : RPGSeriesItemTags.LootCategory.values()) {
                    this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)i, (RPGSeriesItemTags.LootCategory)category));
                }
            }
            for (Map.Entry entry : RPGSeriesItemTags.ArmorType.ALL.entrySet()) {
                this.getOrCreateTagBuilder((class_6862)entry.getValue());
            }
            List<Equipment.WeaponType> fullSpellWeaponTypes = List.of(Equipment.WeaponType.DAMAGE_STAFF, Equipment.WeaponType.DAMAGE_WAND, Equipment.WeaponType.HEALING_STAFF, Equipment.WeaponType.HEALING_WAND, Equipment.WeaponType.SPELL_BLADE, Equipment.WeaponType.SPELL_SCYTHE);
            List<Equipment.WeaponType> list = List.of(Equipment.WeaponType.SWORD, Equipment.WeaponType.CLAYMORE, Equipment.WeaponType.MACE, Equipment.WeaponType.HAMMER, Equipment.WeaponType.GLAIVE);
            List spellInfinityTypes = RPGSeriesDataGen.combine((List[])new List[]{fullSpellWeaponTypes, list});
            FabricTagProvider.FabricTagBuilder spellInfinityTag = this.getOrCreateTagBuilder(SpellEngineItemTags.ENCHANTABLE_SPELL_INFINITY);
            for (Object type : spellInfinityTypes) {
                spellInfinityTag.addTag(RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)type));
            }
            FabricTagProvider.FabricTagBuilder spellHasteTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.HASTE);
            for (Equipment.WeaponType weaponType : fullSpellWeaponTypes) {
                spellHasteTag.addTag(RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)weaponType));
            }
            FabricTagProvider.FabricTagBuilder criticalDamageTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.CRITICAL_DAMAGE);
            for (Equipment.WeaponType type : fullSpellWeaponTypes) {
                criticalDamageTag.addTag(RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)type));
            }
            List list2 = RPGSeriesDataGen.combine((List[])new List[]{fullSpellWeaponTypes, list});
            FabricTagProvider.FabricTagBuilder spellPowerTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.SPELL_POWER_GENERIC);
            for (Equipment.WeaponType type : list2) {
                spellPowerTag.addTag(RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)type));
            }
            FabricTagProvider.FabricTagBuilder spellVolatilityTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.CRITICAL_CHANCE);
            spellVolatilityTag.addTag(RPGSeriesItemTags.ArmorType.get((RPGSeriesItemTags.ArmorMetaType)RPGSeriesItemTags.ArmorMetaType.MAGIC));
            Equipment.WeaponType[] unbreakingTypes = Equipment.WeaponType.values();
            FabricTagProvider.FabricTagBuilder unbreakingTag = this.getOrCreateTagBuilder(class_3489.field_48310);
            for (Equipment.WeaponType type : unbreakingTypes) {
                unbreakingTag.addTag(RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)type));
            }
            List<Equipment.WeaponType> sharpWeaponTypes = List.of(Equipment.WeaponType.SWORD, Equipment.WeaponType.SPEAR, Equipment.WeaponType.CLAYMORE, Equipment.WeaponType.MACE, Equipment.WeaponType.HAMMER, Equipment.WeaponType.DAGGER, Equipment.WeaponType.SICKLE, Equipment.WeaponType.DOUBLE_AXE, Equipment.WeaponType.GLAIVE, Equipment.WeaponType.SPELL_BLADE, Equipment.WeaponType.SPELL_SCYTHE);
            FabricTagProvider.FabricTagBuilder sharpTag = this.getOrCreateTagBuilder(class_3489.field_50108);
            for (Equipment.WeaponType type : sharpWeaponTypes) {
                sharpTag.addTag(RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)type));
            }
            List<Equipment.WeaponType> meleeWeaponTypes = List.of(Equipment.WeaponType.SWORD, Equipment.WeaponType.CLAYMORE, Equipment.WeaponType.MACE, Equipment.WeaponType.HAMMER, Equipment.WeaponType.SPEAR, Equipment.WeaponType.DAGGER, Equipment.WeaponType.SICKLE, Equipment.WeaponType.DOUBLE_AXE, Equipment.WeaponType.GLAIVE);
            FabricTagProvider.FabricTagBuilder meleeTag = this.getOrCreateTagBuilder(class_3489.field_42611);
            for (Equipment.WeaponType type : meleeWeaponTypes) {
                meleeTag.addTag(RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)type));
            }
            for (Equipment.WeaponType type : List.of(Equipment.WeaponType.SHORT_BOW, Equipment.WeaponType.LONG_BOW)) {
                tag = this.getOrCreateTagBuilder(class_3489.field_48311);
                tag.addTag(RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)type));
            }
            for (Equipment.WeaponType type : List.of(Equipment.WeaponType.RAPID_CROSSBOW, Equipment.WeaponType.HEAVY_CROSSBOW)) {
                tag = this.getOrCreateTagBuilder(class_3489.field_48313);
                tag.addTag(RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)type));
            }
        }
    }
}

