/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.fabric.container;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9335;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.fabric.utility.AmountedFluidVariant;

public class KegFluidTankFabric
extends SingleFluidStorage
implements AbstractedFluidTank {
    private final long capacity;

    public KegFluidTankFabric(long capacity) {
        this.capacity = capacity;
    }

    protected long getCapacity(FluidVariant variant) {
        return this.getFluidCapacity();
    }

    @Override
    public long getFluidCapacity(int slot) {
        return this.capacity;
    }

    @Override
    public AbstractedFluidStack getAbstractedFluid() {
        return new AbstractedFluidStack(((FluidVariant)this.variant).getFluid(), this.getAmount(), ((FluidVariant)this.variant).getComponentMap(), FluidUnit.DROPLET, new AmountedFluidVariant((FluidVariant)this.variant, this.getAmount(), FluidUnit.DROPLET));
    }

    @Override
    public void setAbstractedFluid(AbstractedFluidStack stack) {
        try (Transaction t = Transaction.openOuter();){
            this.extract((TransferVariant)((FluidVariant)this.variant), this.capacity, (TransactionContext)t);
            AmountedFluidVariant variant = this.unwrapFluid(stack);
            this.insert((TransferVariant)variant.variant(), FluidUnit.convertToLoader(stack.amount(), stack.unit()), (TransactionContext)t);
            t.commit();
        }
    }

    @Override
    public AbstractedFluidStack fill(AbstractedFluidStack fluidStack, boolean simulate) {
        long newAmount = fluidStack.unit().convertToLoader(fluidStack.amount());
        try {
            class_9326 class_93262;
            Transaction t = Transaction.openOuter();
            class_3611 class_36112 = fluidStack.fluid();
            class_9323 class_93232 = fluidStack.components();
            if (class_93232 instanceof class_9335) {
                class_9335 patched = (class_9335)class_93232;
                class_93262 = patched.method_57940();
            } else {
                class_93262 = class_9326.field_49588;
            }
            FluidVariant variant = FluidVariant.of((class_3611)class_36112, (class_9326)class_93262);
            long newFill = this.insert((TransferVariant)variant, newAmount, (TransactionContext)t);
            if (!simulate) {
                t.commit();
            }
            t.close();
            return new AbstractedFluidStack(variant.getFluid(), newFill, variant.getComponentMap(), FluidUnit.DROPLET, new AmountedFluidVariant(variant, newFill, FluidUnit.DROPLET));
        }
        catch (Exception e) {
            BrewinAndChewin.LOG.error("Failed to fill keg with {} of fluid {}.", (Object)fluidStack.fluid(), (Object)fluidStack.unit().shortFormat(String.valueOf(fluidStack.unit().convertToLoader(fluidStack.amount()))));
            return AbstractedFluidStack.EMPTY;
        }
    }

    @Override
    public AbstractedFluidStack drain(int slot, long maxDrain, FluidUnit unit, boolean simulate) {
        long newMax = unit.convertToLoader(maxDrain);
        try {
            Transaction t = Transaction.openOuter();
            long extractedAmount = this.extract((TransferVariant)((FluidVariant)this.variant), newMax, (TransactionContext)t);
            AbstractedFluidStack stack = new AbstractedFluidStack(((FluidVariant)this.variant).getFluid(), extractedAmount, ((FluidVariant)this.variant).getComponentMap(), FluidUnit.DROPLET, new AmountedFluidVariant((FluidVariant)this.variant, extractedAmount, FluidUnit.DROPLET));
            if (!simulate) {
                t.commit();
            }
            t.close();
            return stack;
        }
        catch (Exception e) {
            BrewinAndChewin.LOG.error("Failed to extract {} from keg.", (Object)unit.shortFormat(String.valueOf(unit.convertToLoader(maxDrain))));
            return AbstractedFluidStack.EMPTY;
        }
    }

    @Override
    public void readFromNbt(class_2487 tag, class_7225.class_7874 provider) {
        this.readNbt(tag, provider);
    }

    @Override
    public class_2487 writeToNbt(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        this.writeNbt(tag, provider);
        return tag;
    }

    @Override
    public boolean isEmpty() {
        return this.isResourceBlank();
    }

    private AmountedFluidVariant unwrapFluid(AbstractedFluidStack stack) {
        class_9326 class_93262;
        Object object = stack.loaderSpecific();
        if (object instanceof AmountedFluidVariant) {
            AmountedFluidVariant fluidVariant = (AmountedFluidVariant)object;
            return fluidVariant;
        }
        if (stack.isEmpty()) {
            return AmountedFluidVariant.EMPTY;
        }
        class_3611 class_36112 = stack.fluid();
        object = stack.components();
        if (object instanceof class_9335) {
            class_9335 patched = (class_9335)object;
            class_93262 = patched.method_57940();
        } else {
            class_93262 = class_9326.field_49588;
        }
        return new AmountedFluidVariant(FluidVariant.of((class_3611)class_36112, (class_9326)class_93262), stack.unit().convertToLoader(stack.amount()), FluidUnit.DROPLET);
    }
}

