/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1275;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.block.KegBlock;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.block.entity.container.SidedKegWrapper;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.container.AbstractedItemHandler;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCBlockEntityTypes;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.tag.BnCTags;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.BnCTextUtils;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class KegBlockEntity
extends SyncedBlockEntity
implements class_3908,
class_1275,
class_1732 {
    public static final int CONTAINER_SLOT = 4;
    public static final int OUTPUT_SLOT = 5;
    public static final int INVENTORY_SIZE = 6;
    public static final int RANGE = 2;
    private final AbstractedItemHandler inventory = this.createHandler();
    private final SidedKegWrapper inputHandler = BrewinAndChewin.getHelper().createSidedKegWrapper(this.inventory, class_2350.field_11036);
    private final SidedKegWrapper outputHandler = BrewinAndChewin.getHelper().createSidedKegWrapper(this.inventory, class_2350.field_11033);
    private final AbstractedFluidTank fluidTank = this.createFluidTank();
    private final KegRecipeWrapper recipeWrapper;
    private int fermentTime;
    private int fermentTimeTotal;
    private class_2561 customName;
    private boolean deferFluidExtraction = false;
    private boolean currentlyOperating = false;
    public int kegTemperature;
    private boolean initialisedTemperature = false;
    protected final class_3913 kegData = this.createIntArray();
    private final Object2IntOpenHashMap<class_2960> usedRecipeTracker = new Object2IntOpenHashMap();
    private class_2960 lastRecipeID;
    private boolean checkNewRecipe = true;

    public KegBlockEntity(class_2338 pos, class_2680 state) {
        super(BnCBlockEntityTypes.KEG, pos, state);
        this.recipeWrapper = BrewinAndChewin.getHelper().createRecipeWrapper(this.inventory, this.fluidTank);
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 provider) {
        super.method_11014(compound, provider);
        this.inventory.readFromNbt(compound.method_10562("Inventory"), provider);
        this.fluidTank.readFromNbt(compound.method_10562("FluidTank"), provider);
        this.fermentTime = compound.method_10550("FermentTime");
        this.fermentTimeTotal = compound.method_10550("FermentTimeTotal");
        if (compound.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)compound.method_10558("CustomName"), (class_7225.class_7874)provider);
        }
        class_2487 compoundRecipes = compound.method_10562("RecipesUsed");
        for (String key : compoundRecipes.method_10541()) {
            this.usedRecipeTracker.put((Object)class_2960.method_12829((String)key), compoundRecipes.method_10550(key));
        }
        if (compound.method_10573("Temperature", 3)) {
            this.kegTemperature = compound.method_10550("Temperature");
        }
        this.checkNewRecipe = true;
    }

    public static AbstractedFluidStack getMealFromItem(class_1799 kegStack, class_7225.class_7874 provider) {
        if (!kegStack.method_31574(BnCItems.KEG)) {
            return AbstractedFluidStack.EMPTY;
        }
        class_9279 data = (class_9279)kegStack.method_57825(class_9334.field_49611, (Object)class_9279.field_49302);
        class_2487 tag = data.method_57461();
        if (!tag.method_33133() && tag.method_10573("FluidTank", 10)) {
            return BrewinAndChewin.getHelper().deserializeTankFluidStack(tag.method_10562("FluidTank"), provider);
        }
        return AbstractedFluidStack.EMPTY;
    }

    public AbstractedFluidStack getOutput() {
        return this.fluidTank.getAbstractedFluid();
    }

    public SidedKegWrapper getSidedHandler(class_2350 direction) {
        if (direction == class_2350.field_11036) {
            return this.inputHandler;
        }
        return this.outputHandler;
    }

    public class_9279 writeMeal(class_2487 tag, class_7225.class_7874 provider) {
        this.writeDrink(tag, provider);
        return class_9279.method_57456((class_2487)tag);
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 provider) {
        super.method_11007(compound, provider);
        compound.method_10566("Inventory", (class_2520)this.inventory.writeToNbt(provider));
        compound.method_10566("FluidTank", (class_2520)this.fluidTank.writeToNbt(provider));
        compound.method_10569("FermentTime", this.fermentTime);
        compound.method_10569("FermentTimeTotal", this.fermentTimeTotal);
        if (this.customName != null) {
            compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName, (class_7225.class_7874)provider));
        }
        class_2487 compoundRecipes = new class_2487();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.method_10569(recipeId.toString(), craftedAmount.intValue()));
        compound.method_10566("RecipesUsed", (class_2520)compoundRecipes);
    }

    private class_2487 writeUpdateTag(class_2487 compound, class_7225.class_7874 provider) {
        super.method_11007(compound, provider);
        compound.method_10566("Inventory", (class_2520)this.inventory.writeToNbt(provider));
        compound.method_10566("FluidTank", (class_2520)this.fluidTank.writeToNbt(provider));
        compound.method_10569("FermentTime", this.fermentTime);
        compound.method_10569("FermentTimeTotal", this.fermentTimeTotal);
        compound.method_10569("Temperature", this.kegTemperature);
        return compound;
    }

    protected void method_57567(class_9323.class_9324 components) {
        components.method_57840(class_9334.field_49628, (Object)this.writeMeal(new class_2487(), (class_7225.class_7874)this.field_11863.method_30349()));
    }

    public class_2487 writeDrink(class_2487 compound, class_7225.class_7874 provider) {
        compound.method_10582("id", BnCBlockEntityTypes.KEG.method_53254().method_55840());
        if (this.customName != null) {
            compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName, (class_7225.class_7874)provider));
        }
        if (!this.fluidTank.isEmpty()) {
            compound.method_10566("FluidTank", (class_2520)this.fluidTank.writeToNbt(provider));
        }
        return compound;
    }

    public static boolean isValidTemp(int kegTemp, int want) {
        return switch (want) {
            case 1 -> {
                if (kegTemp <= 1) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (kegTemp <= 2) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (kegTemp < 5 && kegTemp > 1) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (kegTemp >= 4) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (kegTemp >= 5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    protected boolean canFerment(KegFermentingRecipe recipe, KegBlockEntity keg) {
        if (!this.hasInput()) {
            return false;
        }
        if (this.field_11863 == null) {
            return false;
        }
        if (!KegBlockEntity.isValidTemp(keg.getTemperature(), recipe.getTemperature())) {
            return false;
        }
        if (recipe.getFluidIngredient().isEmpty()) {
            return keg.fluidTank.isEmpty();
        }
        if (!recipe.getFluidIngredient().get().ingredient().matches(keg.fluidTank.getAbstractedFluid())) {
            return false;
        }
        return keg.fluidTank.getAbstractedFluid().amount() % recipe.getFluidIngredient().get().amount() == 0L;
    }

    public static void fermentingTick(class_1937 level, class_2338 pos, class_2680 state, KegBlockEntity keg) {
        boolean didInventoryChange = false;
        if (level.method_8510() % 80L == 0L) {
            keg.updateTemperature();
        }
        if (keg.deferFluidExtraction) {
            keg.deferFluidExtraction = false;
            List<class_1799> out = keg.extractInGui(keg.inventory.getStackInSlot(4), keg.inventory.getSlotLimit(5));
            if (!out.isEmpty()) {
                keg.inventory.insertItem(5, out.getFirst(), false);
            }
        }
        if (keg.hasInput()) {
            Optional<class_8786<KegFermentingRecipe>> recipe = keg.getMatchingRecipe(keg.recipeWrapper);
            if (recipe.isPresent()) {
                if (keg.canFerment((KegFermentingRecipe)recipe.get().comp_1933(), keg)) {
                    didInventoryChange = keg.processFermenting((KegFermentingRecipe)recipe.get().comp_1933(), keg);
                } else {
                    keg.fermentTime = Math.max(0, keg.fermentTime - 20);
                }
            } else {
                keg.fermentTime = Math.max(0, keg.fermentTime - 20);
            }
        } else if (keg.fermentTime > 0) {
            keg.fermentTime = Math.max(0, keg.fermentTime - 20);
        }
        if (didInventoryChange) {
            keg.inventoryChanged();
        }
    }

    public Optional<class_8786<KegFermentingRecipe>> getRecipeWithoutTemperature() {
        if (!this.hasInput()) {
            return Optional.empty();
        }
        Optional<class_8786<KegFermentingRecipe>> recipe = this.getMatchingRecipe(this.recipeWrapper);
        if (recipe.isEmpty()) {
            return Optional.empty();
        }
        if (((KegFermentingRecipe)recipe.get().comp_1933()).getFluidIngredient().isEmpty()) {
            if (!this.fluidTank.isEmpty()) {
                return Optional.empty();
            }
        } else {
            if (!((KegFermentingRecipe)recipe.get().comp_1933()).getFluidIngredient().get().ingredient().matches(this.fluidTank.getAbstractedFluid())) {
                return Optional.empty();
            }
            if (this.fluidTank.getAbstractedFluid().amount() % ((KegFermentingRecipe)recipe.get().comp_1933()).getFluidIngredient().get().amount() != 0L) {
                return Optional.empty();
            }
        }
        return recipe;
    }

    private Optional<class_8786<KegFermentingRecipe>> getMatchingRecipe(KegRecipeWrapper inventoryWrapper) {
        Optional recipe;
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        if (this.checkNewRecipe && (recipe = this.field_11863.method_8433().method_30027(BnCRecipeTypes.FERMENTING).stream().filter(a -> ((KegFermentingRecipe)a.comp_1933()).matches(inventoryWrapper, this.field_11863)).findFirst()).isPresent()) {
            class_2960 newRecipeID = recipe.get().comp_1932();
            if (this.lastRecipeID != null && !this.lastRecipeID.equals((Object)newRecipeID)) {
                this.fermentTime = 0;
            }
            this.lastRecipeID = newRecipeID;
            return recipe;
        }
        this.checkNewRecipe = false;
        if (this.lastRecipeID != null && (recipe = this.field_11863.method_8433().method_42299(BnCRecipeTypes.FERMENTING, (class_9695)inventoryWrapper, this.field_11863, this.lastRecipeID)).isPresent() && ((KegFermentingRecipe)((class_8786)recipe.get()).comp_1933()).matches(inventoryWrapper, this.field_11863)) {
            return recipe;
        }
        return Optional.empty();
    }

    private boolean hasInput() {
        for (int i = 0; i < 5; ++i) {
            if (this.inventory.getStackInSlot(i).method_7960()) continue;
            return true;
        }
        return false;
    }

    private boolean processFermenting(KegFermentingRecipe recipe, KegBlockEntity keg) {
        if (this.field_11863 == null) {
            return false;
        }
        ++this.fermentTime;
        this.fermentTimeTotal = recipe.getFermentTime();
        if (this.fermentTime < this.fermentTimeTotal) {
            this.method_5431();
            return false;
        }
        this.fermentTime = 0;
        if (recipe.getResult().left().isPresent()) {
            this.deferFluidExtraction = true;
            keg.fluidTank.setAbstractedFluid((AbstractedFluidStack)recipe.getResult().left().get());
            if (!keg.field_11863.method_8608()) {
                class_243 center = keg.method_11016().method_46558();
                keg.field_11863.method_43128(null, center.method_10216(), center.method_10214(), center.method_10215(), class_3417.field_14978, class_3419.field_15245, 0.6f, 0.8f);
            }
        }
        if (recipe.getResult().right().isPresent()) {
            if (recipe.getFluidIngredient().isPresent()) {
                keg.fluidTank.drain(recipe.getFluidIngredient().get().amount(), recipe.getUnit(), false);
            }
            keg.inventory.insertItem(5, ((class_1799)recipe.getResult().right().get()).method_7972(), false);
        }
        for (int i = 0; i < 5; ++i) {
            class_1799 slotStack = this.inventory.getStackInSlot(i);
            if (!BrewinAndChewin.getHelper().getCraftingRemainingItem(slotStack).method_7960()) {
                this.ejectIngredientRemainder(BrewinAndChewin.getHelper().getCraftingRemainingItem(slotStack));
            }
            this.inventory.extractItem(i, 1, false);
        }
        return true;
    }

    public List<class_1799> extractInGui(class_1799 slotIn, int maxTakeAmount) {
        return this.fluidExtract(slotIn, maxTakeAmount, true, false);
    }

    public List<class_1799> extractInWorld(class_1799 slotIn, int maxTakeAmount, boolean isCreative) {
        return this.fluidExtract(slotIn, maxTakeAmount, false, isCreative);
    }

    private List<class_1799> fluidExtract(class_1799 slotIn, int maxTakeAmount, boolean inGui, boolean isCreative) {
        if (slotIn.method_7960() || this.deferFluidExtraction || this.inventory.getStackInSlot(5).method_7947() >= Math.min(this.inventory.getSlotLimit(5), this.inventory.getStackInSlot(5).method_7914())) {
            return List.of();
        }
        Optional<KegPouringRecipe> recipe = this.getPouringRecipe(slotIn);
        boolean changed = false;
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        this.currentlyOperating = true;
        if (recipe.isPresent() && (this.fluidTank.isEmpty() || this.fluidTank.getAbstractedFluid().fluid() == recipe.get().getRawFluid().fluid())) {
            class_1799 resultItem = recipe.get().assemble(this.recipeWrapper, (class_7225.class_7874)this.field_11863.method_30349());
            if (class_1799.method_7984((class_1799)slotIn, (class_1799)recipe.get().getContainer(resultItem)) && recipe.get().getRawFluid().amount() <= this.fluidTank.getAbstractedFluid().amount() && (!inGui || this.inventory.getStackInSlot(5).method_7960() || class_1799.method_31577((class_1799)resultItem, (class_1799)this.inventory.getStackInSlot(5)))) {
                containerAmount = (int)class_3532.method_53062((long)Math.min(Math.min(slotIn.method_7947(), resultItem.method_7914()), maxTakeAmount), (long)1L, (long)(this.fluidTank.getAbstractedFluid().amount() / recipe.get().getLoaderAmount()));
                this.fluidTank.drain(recipe.get().getRawFluid().amount() * (long)containerAmount, recipe.get().getUnit(), false);
                if (!isCreative) {
                    for (long overflow = (long)containerAmount; !(overflow <= 0L || inGui && !outputs.isEmpty() || slotIn.method_7960()); overflow -= (long)newResult.method_7947()) {
                        newResult = resultItem.method_46651((int)Math.min((long)Math.min(slotIn.method_7947(), maxTakeAmount), overflow));
                        outputs.add(newResult);
                        slotIn.method_7934(newResult.method_7947());
                    }
                    if (!slotIn.method_7960()) {
                        outputs.add(slotIn);
                    }
                } else {
                    outputs.add(slotIn);
                }
                changed = true;
            } else if (recipe.filter(KegPouringRecipe::canFill).isPresent() && (recipe.get().isStrict() && class_1799.method_31577((class_1799)resultItem, (class_1799)slotIn) || !recipe.get().isStrict() && class_1799.method_7984((class_1799)slotIn, (class_1799)resultItem)) && (this.fluidTank.isEmpty() || this.fluidTank.getAbstractedFluid().matches(recipe.get().getFluid(slotIn)) && this.fluidTank.getAbstractedFluid().amount() < this.fluidTank.getFluidCapacity()) && (!inGui || this.inventory.getStackInSlot(5).method_7960() || class_1799.method_31577((class_1799)recipe.get().getContainer(slotIn), (class_1799)this.inventory.getStackInSlot(5)))) {
                containerAmount = (int)class_3532.method_53062((long)Math.min((long)Math.min(slotIn.method_7947(), recipe.get().getContainer(slotIn).method_7914()), this.fluidTank.getFluidCapacity() / recipe.get().getLoaderAmount()), (long)1L, (long)maxTakeAmount);
                this.fluidTank.fill(new AbstractedFluidStack(recipe.get().getFluid(slotIn).fluid(), recipe.get().getRawFluid().amount() * (long)containerAmount, recipe.get().getFluid(slotIn).components(), recipe.get().getUnit(), null), false);
                if (!isCreative) {
                    class_1799 recipeItem = recipe.get().getContainer(slotIn);
                    for (int overflow = containerAmount; overflow > 0 && !slotIn.method_7960(); overflow -= newResult.method_7947()) {
                        newResult = recipeItem.method_46651(Math.min(Math.min(slotIn.method_7947(), maxTakeAmount), overflow));
                        outputs.add(newResult);
                        slotIn.method_7934(newResult.method_7947());
                    }
                    if (!slotIn.method_7960()) {
                        outputs.add(slotIn);
                    }
                } else {
                    outputs.add(slotIn);
                }
                changed = true;
            }
            if (changed) {
                this.inventoryChanged();
            }
        }
        if (!outputs.isEmpty() || recipe.isPresent()) {
            this.currentlyOperating = false;
            return outputs;
        }
        AbstractedFluidTank itemFluidContainer = BrewinAndChewin.getHelper().getFluidContainerFromItem(slotIn);
        if (itemFluidContainer != null && !slotIn.method_7960()) {
            if ((this.fluidTank.getAbstractedFluid().matches(itemFluidContainer.getAbstractedFluid()) || this.fluidTank.getAbstractedFluid().isEmpty()) && (!inGui || this.inventory.getStackInSlot(5).method_7960() || this.inventory.getStackInSlot(5).method_31574(itemFluidContainer.getContainer().method_7909())) && this.field_11863.method_8433().method_30027(BnCRecipeTypes.KEG_POURING).stream().anyMatch(pouringRecipe -> ((KegPouringRecipe)pouringRecipe.comp_1933()).getFluid(slotIn).matches(this.fluidTank.getAbstractedFluid()))) {
                long amountToDrain = this.fluidTank.getFluidCapacity() - this.fluidTank.getAbstractedFluid().amount();
                long amount = this.fluidTank.fill(itemFluidContainer.drain(amountToDrain, FluidUnit.getLoaderUnit(), true), true).amount();
                if (amount <= amountToDrain && amount > 0L) {
                    this.fluidTank.fill(itemFluidContainer.drain(amountToDrain, FluidUnit.getLoaderUnit(), true), true);
                    if (!isCreative) {
                        class_1799 newResult;
                        class_1799 recipeItem = BrewinAndChewin.getHelper().getCraftingRemainingItem(slotIn).method_7960() ? itemFluidContainer.getContainer() : BrewinAndChewin.getHelper().getCraftingRemainingItem(slotIn);
                        for (int overflow = (int)(amount / this.fluidTank.getFluidCapacity()); overflow > 0 && !slotIn.method_7960(); overflow -= newResult.method_7947()) {
                            newResult = recipeItem.method_46651(Math.min(Math.min(slotIn.method_7947(), maxTakeAmount), overflow));
                            outputs.add(newResult);
                            slotIn.method_7934(newResult.method_7947());
                        }
                    } else {
                        outputs.add(slotIn);
                    }
                    this.method_5431();
                    this.inventoryChanged();
                }
            } else if (!this.fluidTank.getAbstractedFluid().isEmpty() && itemFluidContainer.isFluidValid(this.fluidTank.getAbstractedFluid()) && (!inGui || this.inventory.getStackInSlot(5).method_7960() || this.inventory.getStackInSlot(5).method_31574(itemFluidContainer.getContainer().method_7909()))) {
                long amountToDrain = itemFluidContainer.getFluidCapacity();
                itemFluidContainer = BrewinAndChewin.getHelper().getFluidContainerFromItem(slotIn.method_46651((int)(amountToDrain / itemFluidContainer.getFluidCapacity())));
                long amount = itemFluidContainer.fill(this.fluidTank.drain(amountToDrain, FluidUnit.getLoaderUnit(), true), true).amount();
                if (amount > 0L) {
                    itemFluidContainer.fill(this.fluidTank.drain(amountToDrain, FluidUnit.getLoaderUnit(), false), false);
                    if (amount <= amountToDrain) {
                        outputs.add(slotIn);
                        this.method_5431();
                        this.inventoryChanged();
                    }
                }
            }
        }
        this.currentlyOperating = false;
        return outputs;
    }

    public Optional<KegPouringRecipe> getPouringRecipe(class_1799 slot) {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        return this.field_11863.method_8433().method_30027(BnCRecipeTypes.KEG_POURING).stream().map(class_8786::comp_1933).sorted(Comparator.comparingInt(value -> value.isStrict() ? 0 : 1)).filter(r -> {
            boolean containerCheck = false;
            boolean resultCheck = false;
            boolean fluidCheck = false;
            if (r.isStrict() && class_1799.method_31577((class_1799)r.getContainer(), (class_1799)slot) || !r.isStrict() && r.getContainer().method_7909() == slot.method_7909()) {
                containerCheck = true;
            }
            if (!containerCheck && r.canFill() && (r.isStrict() && class_1799.method_31577((class_1799)r.assemble(this.recipeWrapper, (class_7225.class_7874)this.field_11863.method_30349()), (class_1799)slot) || !r.isStrict() && r.assemble(this.recipeWrapper, (class_7225.class_7874)this.field_11863.method_30349()).method_7909() == slot.method_7909())) {
                resultCheck = true;
            }
            if (this.recipeWrapper.getFluid().isEmpty() || containerCheck && r.getRawFluid().fluid() == this.recipeWrapper.getFluid().fluid() || r.getFluid(slot).matches(this.recipeWrapper.getFluid())) {
                fluidCheck = true;
            }
            return (containerCheck || resultCheck) && fluidCheck;
        }).findFirst();
    }

    public void updateTemperature() {
        class_6880 biome;
        ArrayList<class_2680> states = new ArrayList<class_2680>();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    states.add(this.field_11863.method_8320(this.field_11867.method_10069(x, y, z)));
                }
            }
        }
        int heat = states.stream().filter(s -> s.method_26164(ModTags.HEAT_SOURCES) && s.method_28498((class_2769)class_2741.field_12548)).filter(s -> (Boolean)s.method_11654((class_2769)class_2741.field_12548)).mapToInt(s -> 1).sum();
        heat += states.stream().filter(s -> s.method_26164(ModTags.HEAT_SOURCES) && !s.method_28498((class_2769)class_2741.field_12548)).mapToInt(s -> 1).sum();
        int cold = states.stream().filter(s -> s.method_26164(BnCTags.Blocks.FREEZE_SOURCES) && s.method_28498((class_2769)class_2741.field_12548)).filter(s -> s.method_28498((class_2769)class_2741.field_12548)).filter(s -> (Boolean)s.method_11654((class_2769)class_2741.field_12548)).mapToInt(s -> 1).sum();
        cold += states.stream().filter(s -> s.method_26164(BnCTags.Blocks.FREEZE_SOURCES) && !s.method_28498((class_2769)class_2741.field_12548)).mapToInt(s -> 1).sum();
        if (((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().biomeTemp() && (biome = this.field_11863.method_23753(this.field_11867)).method_40227()) {
            float biomeTemperature = ((class_1959)biome.comp_349()).method_8712();
            if (biomeTemperature <= 0.0f) {
                ++cold;
            } else if (biomeTemperature == 2.0f) {
                ++heat;
            }
        }
        int temp = heat - cold;
        if (((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().dimTemp() && this.field_11863.method_8597().comp_644()) {
            temp += 2;
        }
        if (!this.initialisedTemperature || temp != this.kegTemperature) {
            this.kegTemperature = temp;
            this.initialisedTemperature = true;
            this.inventoryChanged();
        }
    }

    public int getTemperature() {
        if (this.kegTemperature <= -((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().cold()) {
            return 1;
        }
        if (this.kegTemperature <= -((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().chilly()) {
            return 2;
        }
        if (this.kegTemperature < ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().warm()) {
            return 3;
        }
        if (this.kegTemperature < ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().hot()) {
            return 4;
        }
        return 5;
    }

    protected void ejectIngredientRemainder(class_1799 remainderStack) {
        class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)KegBlock.FACING)).method_10160();
        double x = (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.25;
        double y = (double)this.field_11867.method_10264() + 0.7;
        double z = (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.25;
        ItemUtils.spawnItemEntity((class_1937)this.field_11863, (class_1799)remainderStack, (double)x, (double)y, (double)z, (double)((float)direction.method_10148() * 0.08f), (double)0.25, (double)((float)direction.method_10165() * 0.08f));
    }

    public void method_7662(@Nullable class_8786<?> recipe) {
        if (recipe != null) {
            class_2960 recipeID = recipe.comp_1932();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public class_8786<?> method_7663() {
        return null;
    }

    public void method_7664(class_1657 player, List<class_1799> items) {
        List<class_8786<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.method_37908(), player.method_19538());
        player.method_7254(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<class_8786<?>> getUsedRecipesAndPopExperience(class_1937 level, class_243 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.method_8433().method_8130((class_2960)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                KegBlockEntity.splitAndSpawnExperience((class_3218)level, pos, entry.getIntValue(), ((KegFermentingRecipe)recipe.comp_1933()).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(class_3218 level, class_243 pos, int craftedAmount, float experience) {
        int expTotal = class_3532.method_15375((float)((float)craftedAmount * experience));
        float expFraction = class_3532.method_22450((float)((float)craftedAmount * experience));
        if (expFraction > 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        class_1303.method_31493((class_3218)level, (class_243)pos, (int)expTotal);
    }

    public AbstractedItemHandler getInventory() {
        return this.inventory;
    }

    public AbstractedFluidTank getFluidTank() {
        return this.fluidTank;
    }

    public class_2371<class_1799> getDroppableInventory() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < 6; ++i) {
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : BnCTextUtils.getTranslation("container.keg", new Object[0]);
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public void setCustomName(class_2561 name) {
        this.customName = name;
    }

    public class_1703 createMenu(int id, class_1661 player, class_1657 entity) {
        return new KegMenu(id, player, this, this.kegData);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.writeUpdateTag(new class_2487(), provider);
    }

    private AbstractedItemHandler createHandler() {
        return BrewinAndChewin.getHelper().createKegInventory(6, (handler, slot) -> {
            if (!(this.method_10997().method_8608() || slot != 4 && slot != 5 || this.currentlyOperating)) {
                this.deferFluidExtraction = true;
            }
            if (slot >= 0 && slot < 5) {
                this.checkNewRecipe = true;
            }
            this.inventoryChanged();
        });
    }

    private AbstractedFluidTank createFluidTank() {
        return BrewinAndChewin.getHelper().createKegTank(((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().localizedCapacity(), () -> {
            List<class_1799> out;
            AbstractedItemHandler handler = this.inventory;
            if (!(this.method_10997().method_8608() || this.currentlyOperating || this.deferFluidExtraction || (out = this.extractInGui(handler.getStackInSlot(4), handler.getSlotLimit(5))).isEmpty())) {
                handler.insertItem(5, out.get(0), false);
            }
            this.inventoryChanged();
            this.checkNewRecipe = true;
        });
    }

    private class_3913 createIntArray() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> KegBlockEntity.this.fermentTime;
                    case 1 -> KegBlockEntity.this.fermentTimeTotal;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        KegBlockEntity.this.fermentTime = value;
                        break;
                    }
                    case 1: {
                        KegBlockEntity.this.fermentTimeTotal = value;
                    }
                }
            }

            public int method_17389() {
                return 3;
            }
        };
    }
}

