/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.summoning;

import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.world.summoning.BoundData;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class StoredBoundHorse {
    @Nullable
    protected final BoundData boundData;
    protected final class_2487 tag;
    protected final UUID entityUuid;
    protected final class_243 position;
    protected final class_5321<class_1937> dimension;
    protected final boolean isDead;

    public StoredBoundHorse(@Nullable BoundData boundData, class_2487 tag, UUID entityUuid, class_243 position, class_5321<class_1937> dimension, boolean isDead) {
        this.boundData = boundData;
        this.tag = tag;
        this.entityUuid = entityUuid;
        this.position = position;
        this.dimension = dimension;
        this.isDead = isDead;
    }

    public StoredBoundHorse(class_1496 horse) {
        this(horse.getHorsemanBoundData(), StoredBoundHorse.saveToTag(horse), horse.method_5667(), horse.method_19538(), (class_5321<class_1937>)horse.method_37908().method_27983(), horse.method_29504());
    }

    public static class_2487 saveToTag(class_1496 horse) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", class_1299.method_5890((class_1299)horse.method_5864()).toString());
        horse.method_5647(tag);
        return tag;
    }

    @Nullable
    public BoundData getBoundData() {
        return this.boundData;
    }

    public class_2487 getTag() {
        return this.tag;
    }

    public UUID getEntityUuid() {
        return this.entityUuid;
    }

    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public boolean isInSameDimension(class_1657 player) {
        return this.isInSameDimension((class_5321<class_1937>)player.method_37908().method_27983());
    }

    public boolean isInSameDimension(class_5321<class_1937> dimension) {
        return this.getDimension().equals(dimension);
    }

    public class_2487 save(class_2487 tag) {
        if (this.boundData != null) {
            tag.method_10566("BoundData", (class_2520)this.boundData.save(new class_2487()));
        }
        tag.method_10566("Tag", (class_2520)this.tag);
        tag.method_25927("EntityUUID", this.entityUuid);
        tag.method_10549("PosX", this.position.field_1352);
        tag.method_10549("PosY", this.position.field_1351);
        tag.method_10549("PosZ", this.position.field_1350);
        tag.method_10582("Dimension", this.dimension.method_29177().toString());
        tag.method_10556("IsDead", this.isDead);
        return tag;
    }

    @Nullable
    public static StoredBoundHorse load(class_2487 tag) {
        try {
            @Nullable BoundData boundData = BoundData.load(tag.method_10562("BoundData"));
            class_2487 storedTag = tag.method_10562("Tag");
            UUID entityUUID = tag.method_25926("EntityUUID");
            class_243 position = new class_243(tag.method_10574("PosX"), tag.method_10574("PosY"), tag.method_10574("PosZ"));
            class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)tag.method_10558("Dimension")));
            boolean isDead = tag.method_10577("IsDead");
            return new StoredBoundHorse(boundData, storedTag, entityUUID, position, (class_5321<class_1937>)dimension, isDead);
        }
        catch (Exception e) {
            Horseman.LOGGER.error("Failed to load StoredBoundHorse: ", (Throwable)e);
            return null;
        }
    }
}

