/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.listeners.bossbar;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1259;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.event.task.GenerationTaskUpdateEvent;
import org.popcraft.chunky.platform.FabricWorld;
import org.popcraft.chunky.platform.World;

public class BossBarTaskUpdateListener
implements Consumer<GenerationTaskUpdateEvent> {
    private final Map<class_2960, class_3213> bossBars;

    public BossBarTaskUpdateListener(Map<class_2960, class_3213> bossBars) {
        this.bossBars = bossBars;
    }

    @Override
    public void accept(GenerationTaskUpdateEvent event) {
        GenerationTask task = event.generationTask();
        Chunky chunky = task.getChunky();
        World world = task.getSelection().world();
        class_2960 worldIdentifier = class_2960.method_12829((String)world.getKey());
        if (worldIdentifier == null || !(world instanceof FabricWorld)) {
            return;
        }
        FabricWorld fabricWorld = (FabricWorld)world;
        class_3213 bossBar = this.bossBars.computeIfAbsent(worldIdentifier, x -> this.createNewBossBar(worldIdentifier));
        boolean silent = chunky.getConfig().isSilent();
        if (silent == bossBar.method_14093()) {
            bossBar.method_14091(!silent);
        }
        MinecraftServer server = fabricWorld.getWorld().method_8503();
        for (class_3222 player : server.method_3760().method_14571()) {
            if (player.method_5687(2)) {
                bossBar.method_14088(player);
                continue;
            }
            bossBar.method_14089(player);
        }
        GenerationTask.Progress progress = task.getProgress();
        bossBar.method_5413(class_2561.method_30163((String)String.format("%s | %s%% | %s:%s:%s", worldIdentifier, String.format("%.2f", Float.valueOf(progress.getPercentComplete())), String.format("%01d", progress.getHours()), String.format("%02d", progress.getMinutes()), String.format("%02d", progress.getSeconds()))));
        bossBar.method_5408(progress.getPercentComplete() / 100.0f);
        if (progress.isComplete()) {
            bossBar.method_14094();
            this.bossBars.remove(worldIdentifier);
        }
    }

    private class_3213 createNewBossBar(class_2960 worldIdentifier) {
        class_3213 bossBar = new class_3213(class_2561.method_30163((String)worldIdentifier.toString()), BossBarTaskUpdateListener.bossBarColor(worldIdentifier), class_1259.class_1261.field_5795);
        bossBar.method_5406(false);
        bossBar.method_5410(false);
        bossBar.method_5411(false);
        return bossBar;
    }

    private static class_1259.class_1260 bossBarColor(class_2960 worldIdentifier) {
        class_1259.class_1260 bossBarColor = class_1937.field_25179.method_29177().equals((Object)worldIdentifier) ? class_1259.class_1260.field_5785 : (class_1937.field_25180.method_29177().equals((Object)worldIdentifier) ? class_1259.class_1260.field_5784 : (class_1937.field_25181.method_29177().equals((Object)worldIdentifier) ? class_1259.class_1260.field_5783 : class_1259.class_1260.field_5780));
        return bossBarColor;
    }
}

