/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client;

import immersive_melodies.Common;
import immersive_melodies.item.InstrumentItem;
import immersive_melodies.resources.ClientMelodyManager;
import immersive_melodies.resources.Melody;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class MelodyProgress {
    long lastTime;
    int time;
    class_2960 currentlyPlaying = Common.locate("");
    class_2960 overwritten = null;
    long worldTime;
    final Map<Integer, Integer> lastIndex = new HashMap<Integer, Integer>();
    long lastNoteLongTime;
    int lastNoteTime;
    float lastVolume;
    float lastPitch;
    long lastLength;
    float current;
    float currentVolume;
    float currentPitch;
    float lastAnimationTime;
    float attackTime = 10.0f;
    float decayTime = 15.0f;

    public void tick(class_1799 stack) {
        long l = System.currentTimeMillis();
        long delta = l - this.lastTime;
        if (delta < 150L) {
            this.time += (int)delta;
        }
        this.lastTime = l;
        class_2960 identifier = InstrumentItem.getMelody(stack);
        long startTime = (Long)stack.method_57825(InstrumentItem.START_TIME, (Object)0L);
        if (!this.currentlyPlaying.equals((Object)identifier)) {
            this.currentlyPlaying = identifier;
            this.overwritten = null;
            this.worldTime = startTime;
            this.time = 0;
            this.lastIndex.clear();
        }
        if (this.worldTime != startTime) {
            this.worldTime = startTime;
            this.overwritten = null;
            this.time = 0;
            this.lastIndex.clear();
        }
    }

    public long getTime() {
        return this.time;
    }

    public int getLastIndex(int track) {
        return this.lastIndex.getOrDefault(track, 0);
    }

    public void setLastIndex(int track, int index) {
        this.lastIndex.put(track, index);
    }

    public float getCurrent() {
        return this.current;
    }

    public float getCurrentVolume() {
        return this.currentVolume;
    }

    public float getCurrentPitch() {
        return this.currentPitch;
    }

    public class_2960 getCurrentlyPlaying() {
        return this.overwritten == null ? this.currentlyPlaying : this.overwritten;
    }

    public void overwrite(class_2960 by) {
        this.overwritten = by;
    }

    public void visualTick(float time) {
        boolean decayPhase = time - (float)this.lastNoteTime > this.attackTime;
        float delta = Math.max(0.0f, Math.min(1.0f, (time - this.lastAnimationTime) / (decayPhase ? this.decayTime : this.attackTime)));
        this.lastAnimationTime = time;
        if (delta > 0.0f) {
            this.current = this.current * (1.0f - delta) + (decayPhase ? 0.0f : 1.0f) * delta;
            this.currentPitch = this.currentPitch * (1.0f - delta) + this.lastPitch * delta;
            this.currentVolume = this.currentVolume * (1.0f - delta) + this.lastVolume * delta;
        }
    }

    public boolean isPlaying() {
        return this.delta() < 1000L;
    }

    public long delta() {
        return System.currentTimeMillis() - this.lastNoteLongTime;
    }

    public Melody getMelody() {
        return ClientMelodyManager.getMelody(this.getCurrentlyPlaying());
    }
}

