/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.carry;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_7225;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.config.ListHandler;
import tschipp.carryon.common.scripting.CarryOnScript;

public class PlacementHandler {
    public static boolean tryPlaceBlock(class_3222 player, class_2338 pos, class_2350 facing, @Nullable BiFunction<class_2338, class_2680, Boolean> placementCallback) {
        CarryOnScript.ScriptEffects effects;
        String cmd;
        boolean doPlace;
        boolean canPlace;
        CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)player);
        if (!carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            return false;
        }
        if (player.field_6012 == carry.getTick()) {
            return false;
        }
        class_1937 level = player.method_37908();
        class_2680 state = carry.getBlock();
        class_1750 context = new class_1750((class_1657)player, class_1268.field_5808, class_1799.field_8037, class_3965.method_17778((class_243)player.method_19538(), (class_2350)facing, (class_2338)pos));
        if (!level.method_8320(pos).method_26166(context)) {
            pos = pos.method_10093(facing);
        }
        context = new class_1750((class_1657)player, class_1268.field_5808, class_1799.field_8037, class_3965.method_17778((class_243)player.method_19538(), (class_2350)facing, (class_2338)pos));
        class_2586 blockEntity = carry.getBlockEntity(pos, (class_7225.class_7874)level.method_30349());
        boolean bl = canPlace = (state = PlacementHandler.getPlacementState(state, player, context, pos)).method_26184((class_4538)level, pos) && level.method_8505((class_1657)player, pos) && level.method_8320(pos).method_26166(context) && level.method_8628(state, pos, class_3726.method_16195((class_1297)player));
        if (!canPlace) {
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14576, class_3419.field_15248, 0.5f, 0.5f);
            return false;
        }
        boolean bl2 = doPlace = placementCallback == null || placementCallback.apply(pos, state) != false;
        if (!doPlace) {
            return false;
        }
        if (carry.getActiveScript().isPresent() && !(cmd = (effects = carry.getActiveScript().get().scriptEffects()).commandPlace()).isEmpty()) {
            player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), "/execute as " + player.method_7334().getName() + " run " + cmd);
        }
        level.method_8501(pos, state);
        if (blockEntity != null) {
            blockEntity.method_31664(state);
            level.method_8438(blockEntity);
        }
        level.method_8452(pos.method_10093(class_2350.field_11033), level.method_8320(pos.method_10093(class_2350.field_11033)).method_26204());
        carry.clear();
        CarryOnDataManager.setCarryData((class_1657)player, carry);
        player.method_5783(state.method_26231().method_10598(), 1.0f, 0.5f);
        level.method_8396(null, pos, state.method_26231().method_10598(), class_3419.field_15245, 1.0f, 0.5f);
        player.method_23667(class_1268.field_5808, true);
        return true;
    }

    private static class_2680 getPlacementState(class_2680 state, class_3222 player, class_1750 context, class_2338 pos) {
        class_2680 placementState = state.method_26204().method_9605(context);
        if (placementState == null || placementState.method_26204() != state.method_26204()) {
            placementState = state;
        }
        for (class_2769 prop : placementState.method_28501()) {
            if (prop instanceof class_2753) {
                state = PlacementHandler.updateProperty(state, placementState, prop);
            }
            if (prop.method_11902() == class_2350.class_2351.class) {
                state = PlacementHandler.updateProperty(state, placementState, prop);
            }
            if (!ListHandler.isPropertyException(prop)) continue;
            state = PlacementHandler.updateProperty(state, placementState, prop);
        }
        class_2680 updatedState = class_2248.method_9510((class_2680)state, (class_1936)player.method_37908(), (class_2338)pos);
        if (updatedState.method_26204() == state.method_26204()) {
            state = updatedState;
        }
        if (placementState.method_28498((class_2769)class_2741.field_12508) && state.method_28498((class_2769)class_2741.field_12508)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)placementState.method_11654((class_2769)class_2741.field_12508)));
        }
        return state;
    }

    private static <T extends Comparable<T>> class_2680 updateProperty(class_2680 state, class_2680 otherState, class_2769<T> prop) {
        Comparable val = otherState.method_11654(prop);
        return (class_2680)state.method_11657(prop, val);
    }

    public static boolean tryPlaceEntity(class_3222 player, class_2338 pos, class_2350 facing, @Nullable BiFunction<class_243, class_1297, Boolean> placementCallback) {
        CarryOnScript.ScriptEffects effects;
        String cmd;
        boolean doPlace;
        CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)player);
        if (!carry.isCarrying(CarryOnData.CarryType.ENTITY) && !carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            return false;
        }
        if (player.field_6012 == carry.getTick()) {
            return false;
        }
        class_1937 level = player.method_37908();
        class_1750 context = new class_1750((class_1657)player, class_1268.field_5808, class_1799.field_8037, class_3965.method_17778((class_243)player.method_19538(), (class_2350)facing, (class_2338)pos));
        if (!level.method_8320(pos).method_26166(context)) {
            pos = pos.method_10093(facing);
            context = new class_1750((class_1657)player, class_1268.field_5808, class_1799.field_8037, class_3965.method_17778((class_243)player.method_19538(), (class_2350)facing, (class_2338)pos));
        }
        if (!level.method_8320(pos).method_26166(context)) {
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14576, class_3419.field_15248, 0.5f, 0.5f);
            return false;
        }
        class_243 placementPos = class_243.method_24955((class_2382)pos);
        if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            class_1297 otherPlayer = player.method_31483();
            player.method_5772();
            carry.clear();
            CarryOnDataManager.setCarryData((class_1657)player, carry);
            if (otherPlayer == null) {
                return true;
            }
            otherPlayer.method_5859(placementPos.field_1352, placementPos.field_1351, placementPos.field_1350);
            player.method_23667(class_1268.field_5808, true);
            return true;
        }
        class_1297 entity = carry.getEntity(level);
        entity.method_33574(placementPos);
        boolean bl = doPlace = placementCallback == null || placementCallback.apply(placementPos, entity) != false;
        if (!doPlace) {
            return false;
        }
        if (carry.getActiveScript().isPresent() && !(cmd = (effects = carry.getActiveScript().get().scriptEffects()).commandPlace()).isEmpty()) {
            player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), "/execute as " + player.method_7334().getName() + " run " + cmd);
        }
        level.method_8649(entity);
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_5966();
        }
        player.method_23667(class_1268.field_5808, true);
        carry.clear();
        CarryOnDataManager.setCarryData((class_1657)player, carry);
        return true;
    }

    public static void tryStackEntity(class_3222 player, class_1297 entityClicked) {
        if (!Constants.COMMON_CONFIG.settings.stackableEntities) {
            return;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)player);
        if (!carry.isCarrying(CarryOnData.CarryType.ENTITY) && !carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            return;
        }
        class_1937 level = player.method_37908();
        class_1297 entityHeld = carry.isCarrying(CarryOnData.CarryType.ENTITY) ? carry.getEntity(level) : player.method_31483();
        double sizeHeldEntity = entityHeld.method_17682() * entityHeld.method_17681();
        double distance = entityClicked.method_24515().method_10262((class_2382)player.method_24515());
        class_1297 lowestEntity = entityClicked.method_5668();
        int numPassengers = PlacementHandler.getPassengerCount(lowestEntity);
        if (numPassengers < Constants.COMMON_CONFIG.settings.maxEntityStackLimit - 1) {
            class_1297 topEntity = PlacementHandler.getTopPassenger(lowestEntity);
            if (topEntity == entityHeld) {
                return;
            }
            if (ListHandler.isStackingPermitted(topEntity)) {
                double sizeEntity = topEntity.method_17682() * topEntity.method_17681();
                if (!Constants.COMMON_CONFIG.settings.entitySizeMattersStacking || sizeHeldEntity <= sizeEntity) {
                    CarryOnScript.ScriptEffects effects;
                    String cmd;
                    if (topEntity instanceof class_1498) {
                        class_1498 horse = (class_1498)topEntity;
                        horse.method_6766(true);
                    }
                    if (distance < 6.0) {
                        double tempX = entityClicked.method_23317();
                        double tempY = entityClicked.method_23318();
                        double tempZ = entityClicked.method_23321();
                        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                            entityHeld.method_5814(tempX, tempY + 2.6, tempZ);
                            level.method_8649(entityHeld);
                            entityHeld.method_5859(tempX, tempY, tempZ);
                        }
                        entityHeld.method_5873(topEntity, false);
                    } else {
                        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                            entityHeld.method_5814(entityClicked.method_23317(), entityClicked.method_23318(), entityClicked.method_23321());
                            level.method_8649(entityHeld);
                        }
                        entityHeld.method_5873(topEntity, false);
                    }
                    if (carry.getActiveScript().isPresent() && !(cmd = (effects = carry.getActiveScript().get().scriptEffects()).commandPlace()).isEmpty()) {
                        player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), "/execute as " + player.method_7334().getName() + " run " + cmd);
                    }
                    player.method_23667(class_1268.field_5808, true);
                    carry.clear();
                    CarryOnDataManager.setCarryData((class_1657)player, carry);
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14704, class_3419.field_15248, 0.5f, 1.5f);
                } else {
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14576, class_3419.field_15248, 0.5f, 0.5f);
                }
            }
        } else {
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14576, class_3419.field_15248, 0.5f, 0.5f);
        }
    }

    public static void placeCarriedOnDeath(class_3222 oldPlayer, class_3222 newPlayer, boolean died) {
        CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)oldPlayer);
        if (!(!oldPlayer.method_37908().method_8450().method_8355(class_1928.field_19389) && died || carry.isCarrying(CarryOnData.CarryType.PLAYER))) {
            CarryOnDataManager.setCarryData((class_1657)newPlayer, carry);
            newPlayer.method_31548().field_7545 = oldPlayer.method_31548().field_7545;
            return;
        }
        PlacementHandler.placeCarried(oldPlayer);
    }

    public static void placeCarried(class_3222 player) {
        CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)player);
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            class_1297 entity = carry.getEntity(player.method_37908());
            entity.method_33574(player.method_19538());
            player.method_37908().method_8649(entity);
        } else if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            class_1750 context = new class_1750((class_1657)player, class_1268.field_5808, class_1799.field_8037, class_3965.method_17778((class_243)class_243.method_24953((class_2382)player.method_24515()), (class_2350)class_2350.field_11033, (class_2338)player.method_24515()));
            class_2680 state = PlacementHandler.getPlacementState(carry.getBlock(), player, context, player.method_24515());
            class_2338 pos = PlacementHandler.getDeathPlacementPos(state, player);
            class_2586 blockEntity = carry.getBlockEntity(pos, (class_7225.class_7874)player.method_37908().method_30349());
            player.method_37908().method_8652(pos, state, 3);
            if (blockEntity != null) {
                player.method_37908().method_8438(blockEntity);
            }
        } else if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            player.method_5772();
        }
        carry.clear();
        CarryOnDataManager.setCarryData((class_1657)player, carry);
    }

    private static class_2338 getDeathPlacementPos(class_2680 state, class_3222 player) {
        class_2338 p = player.method_24515();
        int DISTANCE = 15;
        ArrayList<class_2338> potentialPositions = new ArrayList<class_2338>();
        for (int j = 0; j < DISTANCE * 2; ++j) {
            for (int i = 0; i < DISTANCE * 2; ++i) {
                for (int k = 0; k < DISTANCE * 2; ++k) {
                    int x = i % 2 == 0 ? i / 2 : -(i / 2);
                    int y = j % 2 == 0 ? j / 2 : -(j / 2);
                    int z = k % 2 == 0 ? k / 2 : -(k / 2);
                    potentialPositions.add(new class_2338(p.method_10263() + x, p.method_10264() + y, p.method_10260() + z));
                }
            }
        }
        potentialPositions.sort(Comparator.comparingDouble(posA -> player.method_5707(posA.method_46558())));
        for (class_2338 potential : potentialPositions) {
            class_1750 context = new class_1750((class_1657)player, class_1268.field_5808, class_1799.field_8037, class_3965.method_17778((class_243)class_243.method_24953((class_2382)potential), (class_2350)class_2350.field_11033, (class_2338)potential));
            boolean canPlace = state.method_26184((class_4538)player.method_37908(), potential) && player.method_37908().method_8320(potential).method_26166(context) && player.method_37908().method_8628(state, potential, class_3726.method_16195((class_1297)player));
            if (!canPlace) continue;
            return potential;
        }
        return p;
    }

    private static int getPassengerCount(class_1297 entity) {
        int passengers = 0;
        while (entity.method_5782()) {
            List pass = entity.method_5685();
            if (pass.isEmpty()) continue;
            entity = (class_1297)pass.get(0);
            ++passengers;
        }
        return passengers;
    }

    private static class_1297 getTopPassenger(class_1297 entity) {
        class_1297 top = entity;
        while (entity.method_5782()) {
            List pass = entity.method_5685();
            if (pass.isEmpty()) continue;
            top = entity = (class_1297)pass.get(0);
        }
        return top;
    }
}

