/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness;

import com.corosus.modconfig.CoroConfigRegistry;
import com.corosus.modconfig.IConfigCategory;
import com.corosus.zombieawareness.EntityScent;
import com.corosus.zombieawareness.ZAUtil;
import com.corosus.zombieawareness.config.ZAConfigClient;
import com.corosus.zombieawareness.config.ZAConfigFeatures;
import com.corosus.zombieawareness.config.ZAConfigGeneral;
import com.corosus.zombieawareness.config.ZAConfigPlayerLists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public abstract class ZombieAwareness {
    public static final String MODID = "zombieawareness";
    private static ZombieAwareness instance;
    public HashMap<String, class_3414> lookupStringToEvent = new HashMap();
    public static class_2960 SENSE_NAME;
    public static class_1299<EntityScent> SENSE;
    public static HashMap<UUID, class_2487> entityData;
    public static HashMap<String, Boolean> unitTest;
    public static List<String> enhanceableMobsList;

    public static ZombieAwareness instance() {
        return instance;
    }

    public static void unitTest(String num) {
    }

    public class_2487 getPersistentData(class_1297 ent) {
        if (!entityData.containsKey(ent.method_5667())) {
            entityData.put(ent.method_5667(), new class_2487());
        }
        return entityData.get(ent.method_5667());
    }

    public class_2487 setPersistentData(class_1297 ent, class_2487 compoundTag) {
        return entityData.put(ent.method_5667(), compoundTag);
    }

    public ZombieAwareness() {
        instance = this;
        new File("./config/zombieawareness").mkdirs();
        CoroConfigRegistry.instance().addConfigFile(MODID, (IConfigCategory)new ZAConfigGeneral());
        CoroConfigRegistry.instance().addConfigFile(MODID, (IConfigCategory)new ZAConfigClient());
        CoroConfigRegistry.instance().addConfigFile(MODID, (IConfigCategory)new ZAConfigFeatures());
        CoroConfigRegistry.instance().addConfigFile(MODID, (IConfigCategory)new ZAConfigPlayerLists());
        ZombieAwareness.generateEntityTickList();
    }

    public abstract class_3324 getPlayerList();

    public abstract boolean isModInstalled(String var1);

    public static void serverStarting() {
        ZombieAwareness.clearConfigCache();
    }

    public static void clearConfigCache() {
        ZAUtil.lookupTickableEntitiesCache.clear();
    }

    public static void dbg(Object obj) {
        if (ZAConfigGeneral.debugConsole) {
            System.out.println(obj);
        }
    }

    public static boolean canProcessEntity(class_1297 ent) {
        if (!ZombieAwareness.canEntityBeProcessedOverride(ent)) {
            return false;
        }
        return ZombieAwareness.canProcessEntity(ent.method_5864(), false);
    }

    public static boolean canProcessEntity(class_1299 ent, boolean pregen) {
        String entName = ZombieAwareness.getEntityRegisteredName(ent);
        if (ZAUtil.lookupTickableEntitiesCache.containsKey(ent)) {
            return ZAUtil.lookupTickableEntitiesCache.get(ent);
        }
        boolean result = false;
        if (ZombieAwareness.canConfigEntity(ent)) {
            boolean canProcess = ZombieAwareness.getDefaultForEntity(ent);
            try {
                if (entName != null && !entName.equals("")) {
                    result = canProcess;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ZAUtil.lookupTickableEntitiesCache.put(ent, result);
        }
        return result;
    }

    public static boolean canEntityBeProcessedOverride(class_1297 entity) {
        return true;
    }

    public static boolean canConfigEntity(class_1299 ent) {
        return ent.method_5891() == class_1311.field_6302;
    }

    public static boolean getDefaultForEntity(class_1299 ent) {
        if (ZombieAwareness.canConfigEntity(ent)) {
            return ZombieAwareness.instance().getEnhancedMobs().contains(class_7923.field_41177.method_10221((Object)ent).toString());
        }
        return false;
    }

    public static List<String> getListFromCSV(String csv) {
        return Stream.of(csv.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public static String getEntityRegisteredName(class_1299 ent) {
        try {
            return class_7923.field_41177.method_10221((Object)ent).toString();
        }
        catch (Exception ex) {
            if (ZAConfigGeneral.debugConsole) {
                ex.printStackTrace();
            }
            return ent.getClass().getSimpleName();
        }
    }

    public static void generateEntityTickList() {
        for (Map.Entry entry : class_7923.field_41177.method_29722()) {
            boolean tickEnt = ZombieAwareness.canConfigEntity((class_1299)entry.getValue());
            if (!tickEnt) continue;
            enhanceableMobsList.add(((class_5321)entry.getKey()).method_29177().toString());
        }
    }

    public void init() {
        this.register("alert");
        this.register("target");
        this.register("investigate");
    }

    public class_3414 register(String name) {
        class_3414 event = class_3414.method_47908((class_2960)class_2960.method_60655((String)MODID, (String)name));
        this.lookupStringToEvent.put(name, event);
        return event;
    }

    public class_3414 getSound(String soundPath) {
        return this.lookupStringToEvent.get(soundPath);
    }

    public abstract List<? extends String> getEnhancedMobs();

    static {
        SENSE_NAME = class_2960.method_60655((String)MODID, (String)"scent");
        entityData = new HashMap();
        unitTest = new HashMap();
        enhanceableMobsList = new ArrayList<String>();
    }
}

