/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.INBTSerializable;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

public abstract class NBTClassType<T> {
    public static Map<Class<?>, NBTClassType<?>> NBTYPES = new IdentityHashMap();

    public static <T> NBTClassType<T> getClassType(Class<T> clazz) {
        return NBTYPES.get(clazz);
    }

    public static <T, I extends T> void writeNbt(Class<T> clazz, String name, I instance, class_2487 tag, class_7225.class_7874 provider) {
        NBTClassType<I> serializationClass = NBTClassType.getClassType(clazz);
        if (serializationClass == null) {
            throw new RuntimeException("No valid NBT serialization was found for " + String.valueOf(instance) + " of type " + String.valueOf(clazz));
        }
        serializationClass.writePersistedField(name, instance, tag, provider);
    }

    public static <T> T readNbt(Class<T> clazz, String name, class_2487 tag, class_7225.class_7874 provider) {
        NBTClassType<T> serializationClass = NBTClassType.getClassType(clazz);
        if (serializationClass == null) {
            throw new RuntimeException("No valid NBT serialization was found type " + String.valueOf(clazz));
        }
        return serializationClass.readPersistedField(name, tag, provider);
    }

    private static boolean isImplementsInterface(Class<?> clazz, Class<?> interfaceClazz) {
        return interfaceClazz.isAssignableFrom(clazz);
    }

    private static NBTClassType getTypeSilent(Class<?> type) {
        NBTClassType<?> action = NBTYPES.get(type);
        if (action == null) {
            for (Class<?> iface : type.getInterfaces()) {
                action = NBTYPES.get(iface);
                if (action == null) continue;
                return action;
            }
            Class<?> superClass = type.getSuperclass();
            if (superClass != null) {
                return NBTClassType.getTypeSilent(superClass);
            }
            return null;
        }
        return action;
    }

    public static NBTClassType getType(Class<?> type, Object target) {
        if (NBTClassType.isImplementsInterface(type, INBTSerializable.class)) {
            return new INBTSerializable.SelfNBTClassType(type);
        }
        NBTClassType action = NBTClassType.getTypeSilent(type);
        if (action == null) {
            throw new RuntimeException("No NBT persist action found for type " + type.getName() + " or any of its parents and interfaces in class " + String.valueOf(target.getClass()) + " for target object " + String.valueOf(target) + ".");
        }
        return action;
    }

    public static void performActionForField(INBTProvider provider, Field field, class_2487 tag, boolean write, class_7225.class_7874 holderLookupProvider) {
        Class<?> type = field.getType();
        String fieldName = field.getName();
        boolean wasAccessible = field.isAccessible();
        if (!wasAccessible) {
            field.setAccessible(true);
        }
        NBTClassType action = NBTClassType.getType(type, provider);
        try {
            action.persistedFieldAction(provider, field, tag, write, holderLookupProvider);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not access field " + fieldName + " in " + String.valueOf(provider.getClass()) + " " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void persistedFieldAction(INBTProvider provider, Field field, class_2487 tag, boolean write, class_7225.class_7874 holderLookupProvider) throws IllegalAccessException {
        String name = field.getName();
        NBTPersist annotation = field.getAnnotation(NBTPersist.class);
        boolean useDefaultValue = annotation.useDefaultValue();
        Object castTile = field.getDeclaringClass().cast(provider);
        if (write) {
            try {
                field.setAccessible(true);
                Object object = field.get(castTile);
                if (object == null) return;
                try {
                    this.writePersistedField(name, object, tag, holderLookupProvider);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Something went from with the field " + field.getName() + " in " + String.valueOf(castTile) + ": " + e.getMessage());
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Can not write the field " + field.getName() + " in " + String.valueOf(castTile) + " since it does not exist. " + e.getMessage());
            }
        }
        Object object = null;
        try {
            if (tag.method_10545(name)) {
                object = this.readPersistedField(name, tag, holderLookupProvider);
                field.setAccessible(true);
                field.set(castTile, object);
                return;
            } else {
                if (!useDefaultValue) return;
                object = this.getDefaultValue();
                field.setAccessible(true);
                field.set(castTile, object);
            }
            return;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Can not read the field " + field.getName() + " as " + String.valueOf(object) + " in " + String.valueOf(castTile) + " since it does not exist OR there is a class mismatch. " + e.getMessage());
        }
    }

    public abstract void writePersistedField(String var1, T var2, class_2487 var3, class_7225.class_7874 var4);

    public abstract T readPersistedField(String var1, class_2487 var2, class_7225.class_7874 var3);

    public abstract T getDefaultValue();

    static {
        NBTYPES.put(Integer.class, new NBTClassType<Integer>(){

            @Override
            public void writePersistedField(String name, Integer object, class_2487 tag, class_7225.class_7874 provider) {
                tag.method_10569(name, object.intValue());
            }

            @Override
            public Integer readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                return tag.method_10550(name);
            }

            @Override
            public Integer getDefaultValue() {
                return 0;
            }
        });
        NBTYPES.put(Integer.TYPE, NBTYPES.get(Integer.class));
        NBTYPES.put(Float.class, new NBTClassType<Float>(){

            @Override
            public void writePersistedField(String name, Float object, class_2487 tag, class_7225.class_7874 provider) {
                tag.method_10548(name, object.floatValue());
            }

            @Override
            public Float readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                return Float.valueOf(tag.method_10583(name));
            }

            @Override
            public Float getDefaultValue() {
                return Float.valueOf(0.0f);
            }
        });
        NBTYPES.put(Float.TYPE, NBTYPES.get(Float.class));
        NBTYPES.put(Boolean.class, new NBTClassType<Boolean>(){

            @Override
            public void writePersistedField(String name, Boolean object, class_2487 tag, class_7225.class_7874 provider) {
                tag.method_10556(name, object.booleanValue());
            }

            @Override
            public Boolean readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                return tag.method_10577(name);
            }

            @Override
            public Boolean getDefaultValue() {
                return false;
            }
        });
        NBTYPES.put(Boolean.TYPE, NBTYPES.get(Boolean.class));
        NBTYPES.put(String.class, new NBTClassType<String>(){

            @Override
            public void writePersistedField(String name, String object, class_2487 tag, class_7225.class_7874 provider) {
                if (object != null && !object.isEmpty()) {
                    tag.method_10582(name, object);
                }
            }

            @Override
            public String readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                return tag.method_10558(name);
            }

            @Override
            public String getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(class_2350.class, new NBTClassType<class_2350>(){

            @Override
            public void writePersistedField(String name, class_2350 object, class_2487 tag, class_7225.class_7874 provider) {
                tag.method_10569(name, object.ordinal());
            }

            @Override
            public class_2350 readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                return class_2350.values()[tag.method_10550(name)];
            }

            @Override
            public class_2350 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(class_3611.class, new NBTClassType<class_3611>(){

            @Override
            public void writePersistedField(String name, class_3611 object, class_2487 tag, class_7225.class_7874 provider) {
                tag.method_10582(name, class_7923.field_41173.method_10221((Object)object).toString());
            }

            @Override
            public class_3611 readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                String fluidName = tag.method_10558(name);
                return (class_3611)class_7923.field_41173.method_10223(class_2960.method_60654((String)fluidName));
            }

            @Override
            public class_3611 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(class_2520.class, new NBTClassType<class_2520>(){

            @Override
            public void writePersistedField(String name, class_2520 object, class_2487 tag, class_7225.class_7874 provider) {
                tag.method_10566(name, object);
            }

            @Override
            public class_2520 readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                return tag.method_10580(name);
            }

            @Override
            public class_2520 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Set.class, new CollectionNBTClassType<Set>(){

            @Override
            protected Set createNewCollection() {
                return Sets.newHashSet();
            }
        });
        NBTYPES.put(List.class, new CollectionNBTClassType<List>(){

            @Override
            protected List createNewCollection() {
                return Lists.newLinkedList();
            }
        });
        NBTYPES.put(Map.class, new NBTClassType<Map>(){

            @Override
            public void writePersistedField(String name, Map object, class_2487 tag, class_7225.class_7874 provider) {
                class_2487 mapTag = new class_2487();
                class_2499 list = new class_2499();
                boolean setKeyType = false;
                boolean setValueType = false;
                for (Map.Entry entry : object.entrySet()) {
                    class_2487 entryTag = new class_2487();
                    10.getType(entry.getKey().getClass(), object).writePersistedField("key", entry.getKey(), entryTag, provider);
                    if (entry.getValue() != null) {
                        10.getType(entry.getValue().getClass(), object).writePersistedField("value", entry.getValue(), entryTag, provider);
                    }
                    list.add((Object)entryTag);
                    if (!setKeyType) {
                        setKeyType = true;
                        mapTag.method_10582("keyType", entry.getKey().getClass().getName());
                    }
                    if (setValueType || entry.getValue() == null) continue;
                    setValueType = true;
                    mapTag.method_10582("valueType", entry.getValue().getClass().getName());
                }
                mapTag.method_10566("map", (class_2520)list);
                tag.method_10566(name, (class_2520)mapTag);
            }

            @Override
            public Map readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                class_2487 mapTag = tag.method_10562(name);
                HashMap map = Maps.newHashMap();
                class_2499 list = mapTag.method_10554("map", 10);
                if (list.size() > 0) {
                    NBTClassType keyNBTClassType;
                    NBTClassType valueNBTClassType = null;
                    try {
                        Class<?> keyType = Class.forName(mapTag.method_10558("keyType"));
                        keyNBTClassType = 10.getType(keyType, map);
                    }
                    catch (ClassNotFoundException e) {
                        CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type map key '" + mapTag.method_10558("keyType") + "', this could be a mod error.");
                        return map;
                    }
                    if (mapTag.method_10545("valueType")) {
                        try {
                            Class<?> valueType = Class.forName(mapTag.method_10558("valueType"));
                            valueNBTClassType = 10.getType(valueType, map);
                        }
                        catch (ClassNotFoundException e) {
                            CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type map value '" + mapTag.method_10558("valueType") + "', this could be a mod error.");
                            return map;
                        }
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        class_2487 entryTag = list.method_10602(i);
                        Object key = keyNBTClassType.readPersistedField("key", entryTag, provider);
                        Object value = null;
                        if (valueNBTClassType != null && entryTag.method_10545("value")) {
                            value = valueNBTClassType.readPersistedField("value", entryTag, provider);
                        }
                        map.put(key, value);
                    }
                }
                return map;
            }

            @Override
            public Map getDefaultValue() {
                return Maps.newHashMap();
            }
        });
        NBTYPES.put(class_2382.class, new NBTClassType<class_2382>(){

            @Override
            public void writePersistedField(String name, class_2382 object, class_2487 tag, class_7225.class_7874 provider) {
                tag.method_10539(name, new int[]{object.method_10263(), object.method_10264(), object.method_10260()});
            }

            @Override
            public class_2382 readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                int[] array = tag.method_10561(name);
                return new class_2382(array[0], array[1], array[2]);
            }

            @Override
            public class_2382 getDefaultValue() {
                return IModHelpers.get().getLocationHelpers().copyLocation(class_2382.field_11176);
            }
        });
        NBTYPES.put(class_243.class, new NBTClassType<class_243>(){

            @Override
            public void writePersistedField(String name, class_243 object, class_2487 tag, class_7225.class_7874 provider) {
                class_2487 vec = new class_2487();
                vec.method_10549("x", object.field_1352);
                vec.method_10549("y", object.field_1351);
                vec.method_10549("z", object.field_1350);
                tag.method_10566(name, (class_2520)vec);
            }

            @Override
            public class_243 readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                class_2487 vec = tag.method_10562(name);
                return new class_243(vec.method_10574("x"), vec.method_10574("y"), vec.method_10574("z"));
            }

            @Override
            public class_243 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Pair.class, new NBTClassType<Pair>(){

            @Override
            public void writePersistedField(String name, Pair object, class_2487 tag, class_7225.class_7874 provider) {
                class_2487 pairTag = new class_2487();
                class_2487 leftTag = new class_2487();
                class_2487 rightTag = new class_2487();
                13.getType(object.getLeft().getClass(), object).writePersistedField("element", object.getLeft(), leftTag, provider);
                13.getType(object.getRight().getClass(), object).writePersistedField("element", object.getRight(), rightTag, provider);
                pairTag.method_10582("leftType", object.getLeft().getClass().getName());
                pairTag.method_10582("rightType", object.getRight().getClass().getName());
                pairTag.method_10566("left", (class_2520)leftTag);
                pairTag.method_10566("right", (class_2520)rightTag);
                tag.method_10566(name, (class_2520)pairTag);
            }

            @Override
            public Pair readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                NBTClassType rightElementNBTClassType;
                NBTClassType leftElementNBTClassType;
                class_2487 pairTag = tag.method_10562(name);
                class_2487 leftTag = pairTag.method_10562("left");
                class_2487 rightTag = pairTag.method_10562("right");
                try {
                    Class<?> elementType = Class.forName(pairTag.method_10558("leftType"));
                    leftElementNBTClassType = 13.getType(elementType, Pair.class);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type Pair left element '" + pairTag.method_10558("leftType") + "', this could be a mod error.");
                    return Pair.of(null, null);
                }
                try {
                    Class<?> elementType = Class.forName(pairTag.method_10558("rightType"));
                    rightElementNBTClassType = 13.getType(elementType, Pair.class);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type Pair right element '" + pairTag.method_10558("rightType") + "', this could be a mod error.");
                    return Pair.of(null, null);
                }
                Object left = leftElementNBTClassType.readPersistedField("element", leftTag, provider);
                Object right = rightElementNBTClassType.readPersistedField("element", rightTag, provider);
                return Pair.of(left, right);
            }

            @Override
            public Pair getDefaultValue() {
                return Pair.of(null, null);
            }
        });
        NBTYPES.put(class_1799.class, new NBTClassType<class_1799>(){

            @Override
            public void writePersistedField(String name, class_1799 object, class_2487 tag, class_7225.class_7874 provider) {
                if (object != null) {
                    tag.method_10566(name, object.method_7972().method_57375(provider));
                }
            }

            @Override
            public class_1799 readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                return class_1799.method_57359((class_7225.class_7874)provider, (class_2487)tag.method_10562(name));
            }

            @Override
            public class_1799 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(class_5250.class, new NBTClassType<class_5250>(){

            @Override
            public void writePersistedField(String name, class_5250 object, class_2487 tag, class_7225.class_7874 provider) {
                if (object != null) {
                    tag.method_10582(name, class_2561.class_2562.method_10867((class_2561)object, (class_7225.class_7874)provider));
                }
            }

            @Override
            public class_5250 readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                return class_2561.class_2562.method_10877((String)tag.method_10558(name), (class_7225.class_7874)provider);
            }

            @Override
            public class_5250 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(EnumFacingMap.class, new NBTClassType<EnumFacingMap>(){

            @Override
            public void writePersistedField(String name, EnumFacingMap object, class_2487 tag, class_7225.class_7874 provider) {
                class_2487 mapTag = new class_2487();
                class_2499 list = new class_2499();
                boolean setValueType = false;
                for (Map.Entry entry : object.entrySet()) {
                    class_2487 entryTag = new class_2487();
                    entryTag.method_10569("key", ((class_2350)entry.getKey()).ordinal());
                    if (entry.getValue() != null) {
                        16.getType(entry.getValue().getClass(), object).writePersistedField("value", entry.getValue(), entryTag, provider);
                    }
                    list.add((Object)entryTag);
                    if (setValueType || entry.getValue() == null) continue;
                    setValueType = true;
                    mapTag.method_10582("valueType", entry.getValue().getClass().getName());
                }
                mapTag.method_10566("map", (class_2520)list);
                tag.method_10566(name, (class_2520)mapTag);
            }

            @Override
            public EnumFacingMap readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
                class_2487 mapTag = tag.method_10562(name);
                EnumFacingMap<Object> map = EnumFacingMap.newMap();
                class_2499 list = mapTag.method_10554("map", 10);
                if (list.size() > 0) {
                    NBTClassType valueNBTClassType = null;
                    if (mapTag.method_10545("valueType")) {
                        try {
                            Class<?> valueType = Class.forName(mapTag.method_10558("valueType"));
                            valueNBTClassType = 16.getType(valueType, map);
                        }
                        catch (ClassNotFoundException e) {
                            CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type map value '" + mapTag.method_10558("valueType") + "', this could be a mod error.");
                            return map;
                        }
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        class_2487 entryTag = list.method_10602(i);
                        class_2350 key = class_2350.values()[entryTag.method_10550("key")];
                        Object value = null;
                        if (valueNBTClassType != null && entryTag.method_10545("value")) {
                            value = valueNBTClassType.readPersistedField("value", entryTag, provider);
                        }
                        map.put(key, value);
                    }
                }
                return map;
            }

            @Override
            public EnumFacingMap getDefaultValue() {
                return EnumFacingMap.newMap();
            }
        });
    }

    private static abstract class CollectionNBTClassType<C extends Collection>
    extends NBTClassType<C> {
        private CollectionNBTClassType() {
        }

        protected abstract C createNewCollection();

        @Override
        public C getDefaultValue() {
            return this.createNewCollection();
        }

        @Override
        public void writePersistedField(String name, C object, class_2487 tag, class_7225.class_7874 provider) {
            class_2487 collectionTag = new class_2487();
            class_2499 list = new class_2499();
            boolean setTypes = false;
            for (Object element : object) {
                class_2487 elementTag = new class_2487();
                CollectionNBTClassType.getType(element.getClass(), object).writePersistedField("element", element, elementTag, provider);
                list.add((Object)elementTag);
                if (setTypes) continue;
                setTypes = true;
                collectionTag.method_10582("elementType", element.getClass().getName());
            }
            collectionTag.method_10566("collection", (class_2520)list);
            tag.method_10566(name, (class_2520)collectionTag);
        }

        @Override
        public C readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
            class_2487 collectionTag = tag.method_10562(name);
            C collection = this.createNewCollection();
            class_2499 list = collectionTag.method_10554("collection", 10);
            if (list.size() > 0) {
                NBTClassType elementNBTClassType;
                try {
                    Class<?> elementType = Class.forName(collectionTag.method_10558("elementType"));
                    elementNBTClassType = CollectionNBTClassType.getType(elementType, collection);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type collection element '" + collectionTag.method_10558("elementType") + "', this could be a mod error.");
                    return collection;
                }
                for (int i = 0; i < list.size(); ++i) {
                    class_2487 entryTag = list.method_10602(i);
                    Object element = elementNBTClassType.readPersistedField("element", entryTag, provider);
                    collection.add(element);
                }
            }
            return collection;
        }
    }
}

