/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;

public interface INBTSerializable {
    public class_2487 toNBT(class_7225.class_7874 var1);

    public void fromNBT(class_7225.class_7874 var1, class_2487 var2);

    public static class SelfNBTClassType
    extends NBTClassType<INBTSerializable> {
        private final Class<?> fieldType;

        public SelfNBTClassType(Class<?> fieldType) {
            this.fieldType = fieldType;
        }

        public Class<?> getFieldType() {
            return this.fieldType;
        }

        @Override
        public void writePersistedField(String name, INBTSerializable object, class_2487 tag, class_7225.class_7874 provider) {
            try {
                Method method = this.fieldType.getMethod("toNBT", class_7225.class_7874.class);
                tag.method_10566(name, (class_2520)method.invoke((Object)object, provider));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No method toNBT for field " + name + " of class " + String.valueOf(this.fieldType) + " was found.");
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                throw new RuntimeException("Error in toNBT for field " + name + ". Error: " + e.getTargetException().getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could invoke toNBT for " + name + ".");
            }
        }

        @Override
        public INBTSerializable readPersistedField(String name, class_2487 tag, class_7225.class_7874 provider) {
            try {
                Constructor<?> constructor = this.fieldType.getConstructor(new Class[0]);
                if (constructor == null) {
                    throw new RuntimeException("The NBT serializable " + name + " of class " + String.valueOf(this.fieldType) + " must have a constructor without parameters.");
                }
                Method method = this.fieldType.getMethod("fromNBT", class_7225.class_7874.class, class_2487.class);
                INBTSerializable obj = (INBTSerializable)constructor.newInstance(new Object[0]);
                if (tag.method_10545(name)) {
                    method.invoke((Object)obj, provider, tag.method_10580(name));
                } else {
                    System.out.println(String.format("The tag %s did not contain the key %s, skipping reading.", tag, name));
                }
                return obj;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No method fromNBT for field " + name + " of class " + String.valueOf(this.fieldType) + " was found.");
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                throw new RuntimeException("Error in fromNBT for field " + name + ". Error: " + e.getTargetException().getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could invoke fromNBT for " + name + ".");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RuntimeException("Something went wrong while calling the empty constructor for " + name + "of class " + String.valueOf(this.fieldType) + ".");
            }
        }

        @Override
        public INBTSerializable getDefaultValue() {
            return null;
        }
    }
}

