/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IWorldHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpersCommonClient;
import org.cyclops.cyclopscore.helper.WorldHelpersCommonServer;

public class WorldHelpersCommon
implements IWorldHelpers {
    private static final double TICK_LAG_REDUCTION_MODULUS_MODIFIER = 1.0;
    private final IModHelpers modHelpers;

    public WorldHelpersCommon(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public int getChunkSize() {
        return 16;
    }

    @Override
    public boolean efficientTick(class_1937 world, int baseModulus, int ... params) {
        int mod = (int)((double)baseModulus * 1.0);
        if (mod == 0) {
            mod = 1;
        }
        int offset = 0;
        for (int param : params) {
            offset += param;
        }
        return world.field_9229.method_43048(mod) == Math.abs(offset) % mod;
    }

    @Override
    public boolean efficientTick(class_1937 world, int baseModulus, class_2338 blockPos) {
        return this.efficientTick(world, baseModulus, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    @Override
    public <T, W extends class_1936> T foldArea(W world, int[] areaMin, int[] areaMax, class_2338 blockPos, IWorldHelpers.WorldFoldingFunction<T, T, W> folder, T value) {
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        for (int xc = x - areaMin[0]; xc <= x + areaMax[0]; ++xc) {
            for (int yc = y - areaMin[1]; yc <= y + areaMax[1]; ++yc) {
                for (int zc = z - areaMin[2]; zc <= z + areaMax[2]; ++zc) {
                    value = folder.apply(value, world, new class_2338(xc, yc, zc));
                }
            }
        }
        return value;
    }

    @Override
    public <T, W extends class_1936> T foldArea(W world, int area, class_2338 blockPos, IWorldHelpers.WorldFoldingFunction<T, T, W> folder, T value) {
        return this.foldArea(world, new int[]{area, area, area}, new int[]{area, area, area}, blockPos, folder, value);
    }

    @Override
    public class_1937 getActiveLevel() {
        if (this.modHelpers.getMinecraftHelpers().isClientSide()) {
            return WorldHelpersCommonClient.getActiveLevel();
        }
        return WorldHelpersCommonServer.getActiveLevel(this.modHelpers);
    }
}

