/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.impl.screenhandler.Networking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_7923;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.cyclops.cyclopscore.CyclopsCoreFabric;
import org.cyclops.cyclopscore.config.StreamCodecConsumerHack;
import org.cyclops.cyclopscore.helper.MinecraftHelpersCommon;

public class MinecraftHelpersFabric
extends MinecraftHelpersCommon {
    private WeakReference<MinecraftServer> server;

    public MinecraftHelpersFabric() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = new WeakReference<MinecraftServer>(server);
        });
    }

    @Override
    public boolean isDevEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public boolean isMinecraftInitialized() {
        return CyclopsCoreFabric._instance.isLoaded();
    }

    @Override
    public boolean isModdedEnvironment() {
        return FabricLoaderImpl.INSTANCE != null;
    }

    @Override
    public boolean isClientSide() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public boolean isClientSideThread() {
        return this.isClientSide() && class_310.method_1551().field_1687 != null && Thread.currentThread() == class_310.method_1551().field_1687.field_17086;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return "minecraft".equals(modId) || FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public void openMenu(class_3222 player, final class_3908 containerSupplier, final Consumer<class_2540> extraDataWriter) {
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory<Boolean>(){

            @Nullable
            public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                class_1703 menu = containerSupplier.createMenu(i, inventory, player);
                class_2960 typeId = class_7923.field_41187.method_10221((Object)menu.method_17358());
                class_9139 codec = (class_9139)Networking.CODEC_BY_ID.get(typeId);
                if (codec instanceof StreamCodecConsumerHack) {
                    StreamCodecConsumerHack streamCodecConsumerHack = (StreamCodecConsumerHack)codec;
                    streamCodecConsumerHack.setExtraDataWriter(extraDataWriter);
                }
                return menu;
            }

            public class_2561 method_5476() {
                return containerSupplier.method_5476();
            }

            public Boolean getScreenOpeningData(class_3222 player) {
                return true;
            }

            public boolean shouldCloseCurrentScreen() {
                return containerSupplier.shouldCloseCurrentScreen();
            }
        });
    }

    @Override
    public MinecraftServer getCurrentServer() {
        return (MinecraftServer)this.server.get();
    }

    @Override
    public boolean isFakePlayer(class_1657 player) {
        return player instanceof FakePlayer;
    }
}

