/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.dungeons_dragon.entity;

import com.cleannrooster.dungeons_dragon.entity.DragonDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.azure.azurelib.common.api.common.animatable.GeoEntity;
import mod.azure.azurelib.common.internal.common.util.AzureLibUtil;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1560;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_8111;
import net.minecraft.class_8710;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.network.Packets;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.TargetHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class Dragon
extends class_1588
implements GeoEntity {
    public final DragonDispatcher dispatcher;
    public final List<SpellSchool> spellSchools;
    public DragonState state = DragonState.IDLE;
    private int stateTick;
    private int flybycooldown = 80;
    private boolean justTookOff;
    public float damageTaken = 0.0f;
    public long stunnedTime = 0L;
    public final MoveAnalysis moveAnalysis;
    public static final RawAnimation FLY = RawAnimation.begin().then("animation.dragon_fly_move", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.dragon_idle", Animation.LoopType.LOOP);
    public static final RawAnimation LIFTOFF = RawAnimation.begin().then("animation.dragon_liftoff", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation LAND = RawAnimation.begin().then("animation.dragon_land", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation HOVER = RawAnimation.begin().then("animation.dragon_hover", Animation.LoopType.LOOP);
    public static final RawAnimation DOWN = RawAnimation.begin().then("animation.dragon_down", Animation.LoopType.LOOP);
    public static final RawAnimation LIFTOFF_HIGH = RawAnimation.begin().then("animation.dragon_liftoff_high", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation FLY_STOP = RawAnimation.begin().then("animation.dragon_fly_stop", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation KNOCKDOWN = RawAnimation.begin().then("animation.dragon_knockdown", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation GET_UP = RawAnimation.begin().then("animation.dragon_get_up", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation GET_UP_MIRROR = RawAnimation.begin().then("animation.dragon_get_up_mirror", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation KNOCKDOWN_MIRROR = RawAnimation.begin().then("animation.dragon_knockdown_mirror", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation HOVER_FIRE = RawAnimation.begin().then("animation.dragon_hover_fire", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation GROUND_POUND = RawAnimation.begin().then("animation.dragon_ground_pound", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation FIRE = RawAnimation.begin().then("animation.dragon_fire", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation DOWN_MIRROR = RawAnimation.begin().then("dragon_down_mirror", Animation.LoopType.LOOP);
    private static final class_2940<Boolean> STUNNED = class_2945.method_12791(Dragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DIRECTION = class_2945.method_12791(Dragon.class, (class_2941)class_2943.field_13323);
    public AnimatableInstanceCache instanceCache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    public int liftoffCooldown = 80;
    public int takeoffCooldown = 20;
    public int landCooldown = 20;
    public int roarCooldown = 80;
    public int flyRoarCooldown = 80;
    public int groundPoundCooldown = 180;

    public boolean method_5947() {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean isOnGround;
        if (source.method_49708(class_8111.field_42345)) {
            return false;
        }
        boolean bl = isOnGround = !this.method_5740();
        if (!this.method_37908().method_8608()) {
            this.damageTaken = !((Boolean)this.method_5841().method_12789(STUNNED)).booleanValue() ? (this.damageTaken += amount) : (this.damageTaken += 0.2f * amount);
        }
        if (isOnGround && this.stunnedTime + 600L < this.method_37908().method_8510() && (double)this.damageTaken > (double)this.method_6063() * 0.3 && !this.method_37908().method_8608()) {
            this.method_5841().method_12778(STUNNED, (Object)true);
            this.stunnedTime = this.method_37908().method_8510();
            this.damageTaken = 0.0f;
            this.triggerAnim("knockdown", "knockdown");
            ((DragonMoveControl)this.field_6207).currentMove = 40;
            this.state = DragonState.IDLE;
            this.stateTick = 0;
        }
        return super.method_5643(source, amount);
    }

    public static class_5132.class_5133 createHostileAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23718, 10.0).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23716, 1200.0).method_26868(class_5134.field_23717, 32.0).method_26868(SpellSchools.ARCANE.attributeEntry, 8.0).method_26868(SpellSchools.FROST.attributeEntry, 8.0).method_26868(SpellSchools.FROST.attributeEntry, 8.0);
    }

    public Dragon(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6206 = new DragonLookControl(this, (class_1308)this);
        this.dispatcher = new DragonDispatcher(this);
        this.moveAnalysis = new MoveAnalysis((class_1297)this);
        this.field_6207 = new DragonMoveControl(this);
        this.spellSchools = List.of(SpellSchools.ARCANE, SpellSchools.FIRE, SpellSchools.FROST);
    }

    public Dragon(class_1299<? extends class_1588> entityType, class_1937 world, List<SpellSchool> spellSchools) {
        super(entityType, world);
        this.field_6206 = new DragonLookControl(this, (class_1308)this);
        this.dispatcher = new DragonDispatcher(this);
        this.moveAnalysis = new MoveAnalysis((class_1297)this);
        this.field_6207 = new DragonMoveControl(this);
        this.spellSchools = spellSchools;
    }

    public class_238 method_5830() {
        if (this.method_5740()) {
            return class_238.method_30048((class_243)super.method_5830().method_1005().method_1031(0.0, 2.0, 0.0), (double)super.method_5830().method_17939(), (double)(super.method_5830().method_17940() + 4.0), (double)super.method_5830().method_17941());
        }
        return super.method_5830();
    }

    protected class_238 method_33332() {
        if (this.method_5740()) {
            return class_238.method_30048((class_243)super.method_33332().method_1005().method_1031(0.0, 2.0, 0.0), (double)super.method_33332().method_17939(), (double)(super.method_33332().method_17940() + 4.0), (double)super.method_33332().method_17941());
        }
        return super.method_33332();
    }

    public double method_23320() {
        if (this.method_5740()) {
            return this.method_23318() + (double)(5.0f * this.method_55693() * this.method_17825());
        }
        return this.method_23318() + (double)this.method_17682() * 0.85;
    }

    public class_238 method_24833(class_4050 pose) {
        if (this.method_5740()) {
            return class_238.method_30048((class_243)super.method_24833(pose).method_1005().method_1031(0.0, 2.0, 0.0), (double)super.method_24833(pose).method_17939(), (double)(super.method_24833(pose).method_17940() + 4.0), (double)super.method_24833(pose).method_17941());
        }
        return super.method_24833(pose);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(STUNNED, (Object)false);
        builder.method_56912(DIRECTION, (Object)false);
    }

    public void method_5697(class_1297 entity) {
    }

    private PlayState predicate2(AnimationState<Dragon> state) {
        boolean isOnGround = !this.method_5740();
        boolean down = (Boolean)this.method_5841().method_12789(STUNNED);
        boolean direction = (Boolean)this.method_5841().method_12789(DIRECTION);
        if (isOnGround) {
            if (down) {
                return state.setAndContinue(DOWN);
            }
            return state.setAndContinue(IDLE);
        }
        return state.setAndContinue(HOVER);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "base", 0, this::predicate2)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "fly", event -> PlayState.CONTINUE).triggerableAnim("fly", FLY)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "liftoff", event -> PlayState.CONTINUE).triggerableAnim("liftoff", LIFTOFF)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "land", event -> PlayState.CONTINUE).triggerableAnim("land", LAND)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "liftoff_high", event -> PlayState.CONTINUE).triggerableAnim("liftoff_high", LIFTOFF_HIGH)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "fly_stop", event -> PlayState.CONTINUE).triggerableAnim("fly_stop", FLY_STOP)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "hover_fire", event -> PlayState.CONTINUE).triggerableAnim("hover_fire", HOVER_FIRE)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "ground_pound", event -> PlayState.CONTINUE).triggerableAnim("ground_pound", GROUND_POUND)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "fire", event -> PlayState.CONTINUE).triggerableAnim("fire", FIRE)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "knockdown", event -> PlayState.CONTINUE).triggerableAnim("knockdown", KNOCKDOWN)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "knockdown_mirror", event -> PlayState.CONTINUE).triggerableAnim("knockdown_mirror", KNOCKDOWN_MIRROR)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "get_up", event -> PlayState.CONTINUE).triggerableAnim("get_up", GET_UP)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "get_up_mirror", event -> PlayState.CONTINUE).triggerableAnim("get_up_mirror", GET_UP_MIRROR)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }

    public void method_5773() {
        if (((Boolean)this.method_5841().method_12789(STUNNED)).booleanValue()) {
            this.method_5875(false);
        }
        super.method_5773();
    }

    public boolean method_5810() {
        return false;
    }

    public void turnHead(class_2183.class_2184 anchorPoint, class_243 target) {
        this.turnHeadLook(anchorPoint, target);
        this.field_6259 = this.field_6241;
    }

    public void turnHeadLook(class_2183.class_2184 anchorPoint, class_243 target) {
        class_243 vec3d = this.method_33571().method_1019(this.method_5720().method_1023(0.0, this.method_5720().method_10214(), 0.0).method_1029().method_1021((double)(this.method_17681() / 4.0f)));
        double d = target.field_1352 - vec3d.field_1352;
        double e = target.field_1351 - vec3d.field_1351;
        double f = target.field_1350 - vec3d.field_1350;
        double g = Math.sqrt(d * d + f * f);
        this.method_36457(class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)e, (double)g) * 57.2957763671875)))));
        this.method_36456(class_3532.method_15393((float)((float)(class_3532.method_15349((double)f, (double)d) * 57.2957763671875) - 90.0f)));
        this.method_5847(this.method_36454());
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.field_6259 = this.field_6241;
    }

    public void method_5702(class_2183.class_2184 anchorPoint, class_243 target) {
        class_243 vec3d = this.method_33571().method_1019(this.method_5720().method_1023(0.0, this.method_5720().method_10214(), 0.0).method_1029().method_1021((double)(this.method_17681() / 4.0f)));
        double d = target.field_1352 - vec3d.field_1352;
        double e = target.field_1351 - vec3d.field_1351;
        double f = target.field_1350 - vec3d.field_1350;
        double g = Math.sqrt(d * d + f * f);
        this.method_36457(class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)e, (double)g) * 57.2957763671875)))));
        this.method_36456(class_3532.method_15393((float)((float)(class_3532.method_15349((double)f, (double)d) * 57.2957763671875) - 90.0f)));
        this.method_5847(this.method_36454());
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.field_6259 = this.field_6241;
        this.field_6220 = this.field_6283 = this.field_6241;
    }

    public void method_5958() {
        boolean isOnGround;
        boolean bl = isOnGround = !this.method_5740();
        if (this.method_5968() != null && (((DragonMoveControl)this.field_6207).currentMove <= 0 || ((DragonMoveControl)this.field_6207).delay > 30)) {
            this.method_5702(class_2183.class_2184.field_9851, this.method_5968().method_33571());
        }
        super.method_5958();
        class_2338.class_2339 mutable = new class_2338.class_2339(this.method_23317(), this.method_23318(), this.method_23321());
        while (mutable.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutable).method_51366()) {
            mutable.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.method_37908().method_8320((class_2338)mutable);
        if (!this.method_37908().method_8608() && ((Boolean)this.method_5841().method_12789(STUNNED)).booleanValue()) {
            if (this.method_37908().method_8510() > this.stunnedTime + 320L) {
                this.method_5841().method_12778(STUNNED, (Object)false);
                this.triggerAnim("get_up", "get_up");
                this.state = DragonState.IDLE;
                this.stateTick = 0;
                ((DragonMoveControl)this.field_6207).currentMove = 40;
            } else {
                return;
            }
        }
        this.moveAnalysis.update();
        if (((DragonMoveControl)this.field_6207).currentMove <= -20 && ((DragonMoveControl)this.field_6207).delay <= 0 && this.method_5968() != null && this.method_5968().method_19538().method_1020(this.method_19538()).method_1033() < 16.0 && !this.field_6207.method_6241() && isOnGround && this.method_5720().method_1026(this.method_5968().method_19538().method_1020(this.method_19538().method_1029())) > (double)0.8f && this.roarCooldown < 0) {
            this.triggerAnim("fire", "fire");
            this.state = DragonState.FIRE_BREATH;
            this.justTookOff = false;
            ((DragonMoveControl)this.field_6207).currentMove = 80;
            ((DragonMoveControl)this.field_6207).delay = 40;
            this.roarCooldown = 120;
            this.stateTick = 0;
        } else if (((DragonMoveControl)this.field_6207).currentMove <= -20 && ((DragonMoveControl)this.field_6207).delay <= 0 && this.method_5968() != null && this.method_5968().method_19538().method_1020(this.method_19538()).method_1033() < 16.0 && !this.field_6207.method_6241() && !isOnGround && this.method_5720().method_1026(this.method_5968().method_19538().method_1020(this.method_19538().method_1029())) < (double)0.8f && this.flyRoarCooldown < 0) {
            this.triggerAnim("hover_fire", "hover_fire");
            this.state = DragonState.FIRE_BREATH;
            ((DragonMoveControl)this.field_6207).currentMove = 80;
            ((DragonMoveControl)this.field_6207).delay = 50;
            this.flyRoarCooldown = 120;
            this.justTookOff = false;
            this.stateTick = 0;
        } else if (((DragonMoveControl)this.field_6207).currentMove <= -20 && ((DragonMoveControl)this.field_6207).delay <= 0 && this.method_5968() != null && this.method_5968().method_5739((class_1297)this) > 8.0f && this.method_23318() > 4.0 + this.method_5968().method_23318() && !this.field_6207.method_6241() && !isOnGround && this.flybycooldown < 0) {
            this.triggerAnim("fly", "fly");
            this.field_6207.method_6239(this.method_5968().method_23317(), this.method_23318(), this.method_5968().method_23321(), 1.5 * (double)this.method_5968().method_5739((class_1297)this) / 3.5);
            ((DragonMoveControl)this.field_6207).delay = 30;
            this.flybycooldown = 120;
            this.justTookOff = false;
            ((DragonMoveControl)this.field_6207).currentMove = 80;
            this.state = DragonState.FLY;
            this.stateTick = 0;
        } else if (((DragonMoveControl)this.field_6207).currentMove <= -20 && ((DragonMoveControl)this.field_6207).delay <= 0 && this.method_5968() != null && this.method_5968().method_5739((class_1297)this) > 16.0f && !this.field_6207.method_6241() && !isOnGround && this.takeoffCooldown < 0) {
            this.triggerAnim("fly", "fly");
            this.field_6207.method_6239(this.method_5968().method_23317(), Math.max(this.method_5968().method_23318() + 2.0, this.method_23318() - 8.0), this.method_5968().method_23321(), (double)(this.method_5968().method_5739((class_1297)this) / 3.5f));
            ((DragonMoveControl)this.field_6207).delay = 30;
            this.takeoffCooldown = 80;
            this.justTookOff = false;
            ((DragonMoveControl)this.field_6207).currentMove = 80;
            this.state = DragonState.FLY;
            this.stateTick = 0;
        } else if (((DragonMoveControl)this.field_6207).currentMove <= -20 && ((DragonMoveControl)this.field_6207).delay <= 0 && this.method_5968() != null && this.method_5968().method_5739((class_1297)this) > 8.0f && !this.field_6207.method_6241() && isOnGround && this.takeoffCooldown < 0) {
            this.triggerAnim("liftoff_high", "liftoff_high");
            this.field_6207.method_6239(this.method_5968().method_23317(), this.method_5968().method_23320() + 3.0, this.method_5968().method_23321(), (double)(this.method_5968().method_5739((class_1297)this) / 3.5f));
            ((DragonMoveControl)this.field_6207).delay = 6;
            this.takeoffCooldown = 160;
            this.justTookOff = true;
            ((DragonMoveControl)this.field_6207).changedGravity = true;
            ((DragonMoveControl)this.field_6207).landing = false;
            ((DragonMoveControl)this.field_6207).currentMove = 30;
            this.state = DragonState.FLY;
            this.stateTick = 0;
            this.landCooldown = 160;
        } else if (((DragonMoveControl)this.field_6207).currentMove <= -20 && ((DragonMoveControl)this.field_6207).delay <= 0 && this.method_5968() != null && this.method_5968().method_19538().method_1020(this.method_19538()).method_37267() < 16.0 && !this.field_6207.method_6241() && isOnGround && this.groundPoundCooldown < 0) {
            this.triggerAnim("ground_pound", "ground_pound");
            this.state = DragonState.SLAM;
            ((DragonMoveControl)this.field_6207).delay = 43;
            ((DragonMoveControl)this.field_6207).currentMove = 70;
            this.groundPoundCooldown = 180;
            if (this.spellSchools.contains(SpellSchools.ARCANE) && this.method_59922().method_43048(4) == 0) {
                this.state = DragonState.ARCANE_SLAM;
                this.groundPoundCooldown = 320;
            }
            this.stateTick = 0;
        } else if (!this.justTookOff && ((DragonMoveControl)this.field_6207).currentMove <= -20 && ((DragonMoveControl)this.field_6207).delay <= 0 && this.method_5968() != null && (this.method_5968().method_5739((class_1297)this) > 16.0f || this.method_5720().method_1026(this.method_5968().method_19538().method_1020(this.method_19538().method_1029())) < (double)0.7f) && isOnGround && this.liftoffCooldown < 0) {
            this.triggerAnim("liftoff", "liftoff");
            this.field_6207.method_6239(this.method_23317(), this.method_23318() + 2.0 + (double)this.method_59922().method_43048(4), this.method_23321(), 1.0);
            ((DragonMoveControl)this.field_6207).delay = 0;
            ((DragonMoveControl)this.field_6207).landing = false;
            ((DragonMoveControl)this.field_6207).changedGravity = true;
            this.state = DragonState.IDLE;
            ((DragonMoveControl)this.field_6207).currentMove = 50;
            this.landCooldown = 160;
            this.justTookOff = true;
            this.stateTick = 160;
            this.liftoffCooldown = 160;
        } else if (!this.justTookOff && ((DragonMoveControl)this.field_6207).currentMove <= -20 && ((DragonMoveControl)this.field_6207).delay <= 0 && blockState.method_51366() && this.landCooldown <= 0 && !isOnGround) {
            this.triggerAnim("land", "land");
            ((DragonMoveControl)this.field_6207).changedGravity = true;
            ((DragonMoveControl)this.field_6207).landing = true;
            ((DragonMoveControl)this.field_6207).delay = 30;
            ((DragonMoveControl)this.field_6207).currentMove = 40;
            this.state = DragonState.IDLE;
            this.landCooldown = 160;
            this.liftoffCooldown = 160;
            this.stateTick = 0;
        } else if (!blockState.method_51366() && isOnGround && ((DragonMoveControl)this.field_6207).currentMove <= -20) {
            this.triggerAnim("liftoff", "liftoff");
            this.field_6207.method_6239(this.method_23317(), this.method_23318() + 2.0, this.method_23321(), 1.0);
            ((DragonMoveControl)this.field_6207).delay = 0;
            ((DragonMoveControl)this.field_6207).landing = false;
            ((DragonMoveControl)this.field_6207).changedGravity = true;
            ((DragonMoveControl)this.field_6207).currentMove = 50;
            this.landCooldown = 160;
            this.state = DragonState.IDLE;
            this.liftoffCooldown = 160;
            this.stateTick = 0;
        }
        if (((DragonMoveControl)this.field_6207).currentMove == 0) {
            this.state = DragonState.IDLE;
            this.stateTick = 0;
        }
        if (!this.method_37908().method_8608()) {
            this.handlForState(this.state);
            ++this.stateTick;
            if (!isOnGround) {
                --this.takeoffCooldown;
                --this.landCooldown;
            } else {
                --this.liftoffCooldown;
            }
            --this.flybycooldown;
            --this.groundPoundCooldown;
            --this.flyRoarCooldown;
            --this.roarCooldown;
        }
    }

    public void handlForState(DragonState state) {
        Spell spell = null;
        class_6880 spellEntry = null;
        if (this.state == DragonState.ARCANE_BREATH) {
            spell = (Spell)SpellRegistry.from((class_1937)this.method_37908()).method_10223(class_2960.method_60655((String)"dungeons-dragon", (String)"arcane_breath"));
            spellEntry = (class_6880)SpellRegistry.from((class_1937)this.method_37908()).method_55841(class_2960.method_60655((String)"dungeons-dragon", (String)"arcane_breath")).get();
        }
        if (this.state == DragonState.FIRE_BREATH) {
            if (this.spellSchools.contains(SpellSchools.FIRE)) {
                if (this.method_5740()) {
                    spell = (Spell)SpellRegistry.from((class_1937)this.method_37908()).method_10223(class_2960.method_60655((String)"dungeons-dragon", (String)"fire_breath"));
                    spellEntry = (class_6880)SpellRegistry.from((class_1937)this.method_37908()).method_55841(class_2960.method_60655((String)"dungeons-dragon", (String)"fire_breath")).get();
                } else {
                    spell = (Spell)SpellRegistry.from((class_1937)this.method_37908()).method_10223(class_2960.method_60655((String)"dungeons-dragon", (String)"fire_breath_wide"));
                    spellEntry = (class_6880)SpellRegistry.from((class_1937)this.method_37908()).method_55841(class_2960.method_60655((String)"dungeons-dragon", (String)"fire_breath_wide")).get();
                }
            } else {
                spell = (Spell)SpellRegistry.from((class_1937)this.method_37908()).method_10223(class_2960.method_60655((String)"dungeons-dragon", (String)"frost_aura"));
                spellEntry = (class_6880)SpellRegistry.from((class_1937)this.method_37908()).method_55841(class_2960.method_60655((String)"dungeons-dragon", (String)"fire_breath")).get();
            }
        }
        if (this.state == DragonState.FROST_BREATH) {
            spell = (Spell)SpellRegistry.from((class_1937)this.method_37908()).method_10223(class_2960.method_60655((String)"dungeons-dragon", (String)"frost_breath"));
            spellEntry = (class_6880)SpellRegistry.from((class_1937)this.method_37908()).method_55841(class_2960.method_60655((String)"dungeons-dragon", (String)"frost_breath")).get();
        }
        if (this.state == DragonState.SLAM) {
            spell = (Spell)SpellRegistry.from((class_1937)this.method_37908()).method_10223(class_2960.method_60655((String)"dungeons-dragon", (String)"slam"));
            spellEntry = (class_6880)SpellRegistry.from((class_1937)this.method_37908()).method_55841(class_2960.method_60655((String)"dungeons-dragon", (String)"slam")).get();
        }
        if (this.state == DragonState.ARCANE_SLAM) {
            spell = (Spell)SpellRegistry.from((class_1937)this.method_37908()).method_10223(class_2960.method_60655((String)"dungeons-dragon", (String)"arcane_launch"));
            spellEntry = (class_6880)SpellRegistry.from((class_1937)this.method_37908()).method_55841(class_2960.method_60655((String)"dungeons-dragon", (String)"arcane_launch")).get();
        }
        if (this.state == DragonState.FLY) {
            if (this.spellSchools.contains(SpellSchools.FROST)) {
                spell = (Spell)SpellRegistry.from((class_1937)this.method_37908()).method_10223(class_2960.method_60655((String)"dungeons-dragon", (String)"frost_blizzard"));
                spellEntry = (class_6880)SpellRegistry.from((class_1937)this.method_37908()).method_55841(class_2960.method_60655((String)"dungeons-dragon", (String)"frost_blizzard")).get();
            } else {
                spell = (Spell)SpellRegistry.from((class_1937)this.method_37908()).method_10223(class_2960.method_60655((String)"dungeons-dragon", (String)"fire_breath"));
                spellEntry = (class_6880)SpellRegistry.from((class_1937)this.method_37908()).method_55841(class_2960.method_60655((String)"dungeons-dragon", (String)"fire_breath")).get();
            }
        }
        if (spell != null && (spell.school == ExternalSpellSchools.PHYSICAL_MELEE || this.spellSchools.contains(spell.school))) {
            if (this.stateTick == 0 && spell.release != null) {
                ParticleHelper.sendBatches((class_1297)this, (ParticleBatch[])spell.release.particles);
            }
            if (spell.active != null && spell.active.cast != null) {
                if (((DragonMoveControl)this.method_5962()).delay <= 0 || (float)this.stateTick == 20.0f * spell.active.cast.duration) {
                    Dragon.sendBatches((class_1297)this, spell.active.cast.particles);
                    if (spell.active.cast.sound != null) {
                        SoundHelper.playSound((class_1937)this.method_37908(), (class_1297)this, (Sound)new Sound(spell.active.cast.sound.id()));
                    }
                    if (spell.active.cast.channel_ticks != 0) {
                        if (this.stateTick % spell.active.cast.channel_ticks == 0) {
                            if (spell.target != null && spell.target.area != null) {
                                List entities = TargetHelper.targetsFromArea((class_1297)this, (float)spell.range, (Spell.Target.Area)spell.target.area, entity -> entity != this && !(entity instanceof class_1560));
                                for (class_1297 entity2 : entities) {
                                    class_243 sourceLocation = Dragon.origin((class_1297)this, ParticleBatch.Origin.LAUNCH_POINT);
                                    SpellHelper.performImpacts((class_1937)this.method_37908(), (class_1309)this, (class_1297)entity2, (class_1297)entity2, (class_6880)spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)new SpellHelper.ImpactContext(0.05f * (float)spell.active.cast.channel_ticks, (float)sourceLocation.method_1022(entity2.method_19538()), this.method_19538(), SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this), SpellTarget.FocusMode.DIRECT, 0));
                                }
                            }
                            if (spell.deliver != null) {
                                class_243 sourceLocation;
                                class_2338.class_2339 mutable;
                                if (spell.deliver.meteor != null && this.stateTick % spell.active.cast.channel_ticks == 0) {
                                    mutable = new class_2338.class_2339(this.method_23317(), this.method_23318(), this.method_23321());
                                    while (mutable.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutable).method_51366()) {
                                        mutable.method_10098(class_2350.field_11033);
                                    }
                                    sourceLocation = Dragon.origin((class_1297)this, ParticleBatch.Origin.FEET);
                                    SpellHelper.fallProjectile((class_1937)this.method_37908(), (class_1309)this, null, (class_243)mutable.method_46558(), (class_6880)spellEntry, (SpellHelper.ImpactContext)new SpellHelper.ImpactContext(1.0f, 1.0f, sourceLocation, SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this), SpellTarget.FocusMode.DIRECT, 0));
                                }
                                if (spell.deliver.clouds != null && this.stateTick % spell.active.cast.channel_ticks == 0) {
                                    mutable = new class_2338.class_2339(this.method_23317(), this.method_23318(), this.method_23321());
                                    while (mutable.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutable).method_51366()) {
                                        mutable.method_10098(class_2350.field_11033);
                                    }
                                    sourceLocation = Dragon.origin((class_1297)this, ParticleBatch.Origin.FEET);
                                    SpellHelper.placeCloud((class_1937)this.method_37908(), (class_1309)this, null, (class_243)sourceLocation, (class_6880)spellEntry, (SpellHelper.ImpactContext)new SpellHelper.ImpactContext(1.0f, 1.0f, sourceLocation, SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this), SpellTarget.FocusMode.DIRECT, 0));
                                }
                            }
                        }
                    } else if ((float)this.stateTick == 20.0f * spell.active.cast.duration) {
                        if (spell.target != null && spell.target.area != null) {
                            List entities = TargetHelper.targetsFromArea((class_1297)this, (float)spell.range, (Spell.Target.Area)spell.target.area, entity -> entity != this && !(entity instanceof class_1560));
                            for (class_1297 entity3 : entities) {
                                class_243 sourceLocation = Dragon.origin((class_1297)this, ParticleBatch.Origin.LAUNCH_POINT);
                                SpellHelper.performImpacts((class_1937)this.method_37908(), (class_1309)this, (class_1297)entity3, (class_1297)entity3, (class_6880)spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)new SpellHelper.ImpactContext(1.0f, (float)sourceLocation.method_1022(entity3.method_19538()), this.method_19538(), SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this), SpellTarget.FocusMode.DIRECT, 0));
                            }
                            if (spell.release != null) {
                                Dragon.sendBatches((class_1297)this, spell.release.particles);
                                SoundHelper.playSound((class_1937)this.method_37908(), (class_1297)this, (Sound)new Sound(spell.release.sound.id()));
                            }
                        }
                        if (spell.deliver != null) {
                            class_243 sourceLocation;
                            class_2338.class_2339 mutable;
                            if (spell.deliver.meteor != null) {
                                mutable = new class_2338.class_2339(this.method_23317(), this.method_23318(), this.method_23321());
                                while (mutable.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutable).method_51366()) {
                                    mutable.method_10098(class_2350.field_11033);
                                }
                                sourceLocation = Dragon.origin((class_1297)this, ParticleBatch.Origin.FEET);
                                SpellHelper.fallProjectile((class_1937)this.method_37908(), (class_1309)this, null, (class_243)mutable.method_46558(), (class_6880)spellEntry, (SpellHelper.ImpactContext)new SpellHelper.ImpactContext(1.0f, 1.0f, sourceLocation, SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this), SpellTarget.FocusMode.DIRECT, 0));
                            }
                            if (spell.deliver.clouds != null) {
                                mutable = new class_2338.class_2339(this.method_23317(), this.method_23318(), this.method_23321());
                                while (mutable.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutable).method_51366()) {
                                    mutable.method_10098(class_2350.field_11033);
                                }
                                sourceLocation = Dragon.origin((class_1297)this, ParticleBatch.Origin.FEET);
                                SpellHelper.placeCloud((class_1937)this.method_37908(), (class_1309)this, null, (class_243)sourceLocation, (class_6880)spellEntry, (SpellHelper.ImpactContext)new SpellHelper.ImpactContext(1.0f, 1.0f, sourceLocation, SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this), SpellTarget.FocusMode.DIRECT, 0));
                            }
                        }
                    }
                } else if (spell.active.cast.channel_ticks == 0) {
                    Dragon.sendBatches((class_1297)this, spell.active.cast.particles);
                    if (spell.active.cast.sound != null) {
                        SoundHelper.playSound((class_1937)this.method_37908(), (class_1297)this, (Sound)new Sound(spell.active.cast.sound.id()));
                    }
                }
            }
        }
    }

    public static void sendBatches(class_1297 trackedEntity, ParticleBatch[] batches) {
        Dragon.sendBatches(trackedEntity, batches, true);
    }

    public static void sendBatches(class_1297 trackedEntity, ParticleBatch[] batches, boolean includeSourceEntity) {
        Dragon.sendBatches(trackedEntity, batches, 1.0f, PlayerLookup.tracking((class_1297)trackedEntity), includeSourceEntity);
    }

    public static void sendBatches(class_1297 trackedEntity, ParticleBatch[] batches, float countMultiplier, Collection<class_3222> trackers) {
        Dragon.sendBatches(trackedEntity, batches, countMultiplier, trackers, true);
    }

    public static void sendBatches(class_1297 trackedEntity, ParticleBatch[] batches, float countMultiplier, Collection<class_3222> trackers, boolean includeSourceEntity) {
        if (batches != null && batches.length != 0) {
            class_3222 serverPlayer;
            int sourceEntityId = trackedEntity.method_5628();
            Packets.ParticleBatches.SourceType sourceType = Packets.ParticleBatches.SourceType.COORDINATE;
            ArrayList<Packets.ParticleBatches.Spawn> spawns = new ArrayList<Packets.ParticleBatches.Spawn>();
            ParticleBatch[] var8 = batches;
            int var9 = batches.length;
            for (int var10 = 0; var10 < var9; ++var10) {
                ParticleBatch batch = var8[var10];
                class_243 sourceLocation = class_243.field_1353;
                switch (sourceType) {
                    default: {
                        break;
                    }
                    case COORDINATE: {
                        sourceLocation = Dragon.origin(trackedEntity, batch.origin);
                    }
                }
                spawns.add(new Packets.ParticleBatches.Spawn(includeSourceEntity ? sourceEntityId : 0, trackedEntity.method_5791(), trackedEntity.method_36455(), sourceLocation, batch));
            }
            Packets.ParticleBatches packet = new Packets.ParticleBatches(sourceType, countMultiplier, spawns);
            if (trackedEntity instanceof class_3222 && ServerPlayNetworking.canSend((class_3222)(serverPlayer = (class_3222)trackedEntity), (class_2960)Packets.ParticleBatches.ID)) {
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)packet);
            }
            trackers.forEach(serverPlayerx -> {
                if (ServerPlayNetworking.canSend((class_3222)serverPlayerx, (class_2960)Packets.ParticleBatches.ID)) {
                    ServerPlayNetworking.send((class_3222)serverPlayerx, (class_8710)packet);
                }
            });
        }
    }

    private static class_243 origin(class_1297 entity, ParticleBatch.Origin origin) {
        switch (origin) {
            case FEET: {
                return entity.method_19538().method_1031(0.0, entity.method_5830().method_17940() * (double)0.1f, 0.0);
            }
            case CENTER: {
                return entity.method_19538().method_1031(0.0, entity.method_5830().method_17940() * 0.5, 0.0);
            }
            case LAUNCH_POINT: {
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    return Dragon.launchPoint(livingEntity);
                }
                return entity.method_19538().method_1031(0.0, entity.method_23320(), 0.0);
            }
            case GROUND: {
                class_243 position = TargetHelper.findSolidBelow((class_1297)entity, (class_243)entity.method_19538(), (class_1937)entity.method_37908(), (float)-2.0f);
                if (position != null) {
                    return new class_243(entity.method_23317(), position.method_10214() + (double)0.1f, entity.method_23321());
                }
                return entity.method_19538().method_1031(0.0, (double)0.1f, 0.0);
            }
        }
        return entity.method_19538();
    }

    public static class_243 launchPoint(class_1309 caster) {
        return Dragon.launchPoint(caster, caster.method_5740() ? 3.0f : 5.0f);
    }

    public static class_243 launchPoint(class_1309 caster, float forward) {
        class_243 look = caster.method_5720().method_1021((double)(forward * caster.method_17825()));
        return caster.method_33571().method_1019(look);
    }

    public static float launchHeight(class_1309 livingEntity) {
        double eyeHeight = livingEntity.method_23320();
        double shoulderDistance = livingEntity.method_5830().method_17939() * 0.15;
        return (float)((eyeHeight - shoulderDistance) * (double)livingEntity.method_17825());
    }

    private class DragonMoveControl
    extends class_1335 {
        public int delay;
        public int currentMove;
        public boolean landing;
        public boolean changedGravity;

        public DragonMoveControl(Dragon owner) {
            super((class_1308)owner);
            this.delay = 0;
            this.currentMove = 0;
            this.landing = false;
            this.changedGravity = false;
        }

        public void method_6240() {
            if (this.delay <= 0 && this.changedGravity) {
                this.field_6371.method_5875(!this.field_6371.method_5740());
                this.changedGravity = false;
            }
            if (this.field_6374 == class_1335.class_1336.field_6378 && this.delay < 0) {
                class_243 vec3d = new class_243(this.field_6370 - Dragon.this.method_23317(), this.field_6369 - Dragon.this.method_23318(), this.field_6367 - Dragon.this.method_23321());
                double d = vec3d.method_1033();
                if (d < Dragon.this.method_5829().method_995()) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    Dragon.this.method_18799(Dragon.this.method_18798().method_1021(0.5));
                } else {
                    Dragon.this.method_18799(Dragon.this.method_18798().method_1019(vec3d.method_1021(Math.min(this.field_6372, 8.0) * 0.05 / d)));
                    if (Dragon.this.method_5968() == null) {
                        class_243 vec3d2 = Dragon.this.method_18798();
                        Dragon.this.method_36456(-((float)class_3532.method_15349((double)vec3d2.field_1352, (double)vec3d2.field_1350)) * 57.295776f);
                        Dragon.this.field_6283 = Dragon.this.method_36454();
                    } else {
                        double e = Dragon.this.method_5968().method_23317() - Dragon.this.method_23317();
                        double f = Dragon.this.method_5968().method_23321() - Dragon.this.method_23321();
                        Dragon.this.method_36456(-((float)class_3532.method_15349((double)e, (double)f)) * 57.295776f);
                        Dragon.this.field_6283 = Dragon.this.method_36454();
                    }
                }
            }
            --this.delay;
            --this.currentMove;
        }
    }

    public static enum DragonState {
        FIRE_BREATH,
        FROST_BREATH,
        ARCANE_BREATH,
        SLAM,
        ARCANE_SLAM,
        HOVER,
        FLY,
        IDLE;

    }

    private class DragonLookControl
    extends class_1333 {
        public DragonLookControl(Dragon dragon, class_1308 entity) {
            super(entity);
        }

        protected boolean method_20433() {
            return false;
        }
    }
}

