/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.recipe.result;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_5819;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ChanceResult(class_1799 stack, float chance) {
    public static final Codec<ChanceResult> CHANCE_RESULT_ONLY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("item").forGetter(ChanceResult::stack), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).validate(chance -> {
        if (Float.isNaN(chance.floatValue())) {
            return DataResult.error(() -> "'chance' cannot be NaN.");
        }
        if ((double)chance.floatValue() <= 0.0) {
            return DataResult.error(() -> "'chance' '{" + chance + "}' is not valid. Should be larger than 0.");
        }
        return DataResult.success((Object)chance);
    }).forGetter(ChanceResult::chance)).apply((Applicative)instance, ChanceResult::new));
    public static final Codec<ChanceResult> CODEC = Codec.either((Codec)class_1799.field_24671, CHANCE_RESULT_ONLY_CODEC).xmap(itemStackOrChanceResult -> (ChanceResult)Either.unwrap((Either)itemStackOrChanceResult.mapLeft(ChanceResult::new)), chanceResult -> chanceResult.chance() >= 1.0f ? Either.left((Object)chanceResult.stack()) : Either.right((Object)chanceResult));
    public static final class_9139<class_9129, ChanceResult> STREAM_CODEC = class_9139.method_56435((class_9139)class_1799.field_48349, ChanceResult::stack, (class_9139)class_9135.field_48552, ChanceResult::chance, ChanceResult::new);

    public ChanceResult(class_1799 stack, float chance) {
        Preconditions.checkArgument((!stack.method_7960() ? 1 : 0) != 0, (Object)"Item Stack cannot be empty.");
        this.stack = stack;
        Preconditions.checkArgument((!Float.isNaN(chance) ? 1 : 0) != 0, (String)"Chance '{}' is not valid. Should not be NaN.", (Object)Float.valueOf(chance));
        Preconditions.checkArgument(((double)chance > 0.0 ? 1 : 0) != 0, (String)"Chance '{}' is not valid. Should be larger than 0.", (Object)Float.valueOf(chance));
        this.chance = chance;
    }

    public ChanceResult(class_1799 stack) {
        this(stack, 1.0f);
    }

    public class_1799 rollOutput(class_5819 rand) {
        int outputAmount = this.stack.method_7947();
        for (int roll = 0; roll < this.stack.method_7947(); ++roll) {
            if (!(rand.method_43057() > this.chance)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return class_1799.field_8037;
        }
        class_1799 out = this.stack.method_7972();
        out.method_7939(outputAmount);
        return out;
    }
}

