/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei.category;

import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.integration.jei.JeiRecipeTypes;
import io.github.mortuusars.sootychimneys.integration.jei.SootyChimneysJeiPlugin;
import io.github.mortuusars.sootychimneys.integration.jei.renderer.ScalableItemStackRenderer;
import io.github.mortuusars.sootychimneys.recipe.SootScrapingRecipe;
import io.github.mortuusars.sootychimneys.recipe.result.ChanceResult;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class SootScrapingRecipeCategory
implements IRecipeCategory<SootScrapingRecipe> {
    public static final int BG_WIDTH = 153;
    public static final int BG_HEIGHT = 65;
    private final class_2561 title = class_2561.method_43471((String)"jei.sootychimneys.category.soot_scraping");
    private final IDrawable background;
    private final IDrawableStatic icon;
    private final IDrawableStatic dust;
    private final IDrawableStatic slot;
    private final IDrawableStatic chanceSlot;

    public SootScrapingRecipeCategory(IGuiHelper helper) {
        class_2960 texture = SootyChimneys.resource("textures/gui/jei/soot_scraping.png");
        this.background = helper.createDrawable(texture, 0, 0, 153, 65);
        this.icon = helper.drawableBuilder(SootyChimneys.resource("textures/gui/jei/soot_scraping_icon.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.dust = helper.createDrawable(texture, 155, 0, 10, 12);
        this.slot = helper.createDrawable(texture, 0, 65, 18, 18);
        this.chanceSlot = helper.createDrawable(texture, 18, 65, 18, 18);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SootScrapingRecipe recipe, @NotNull IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 9, 18).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new ScalableItemStackRenderer(2.5f)).addIngredients(recipe.chimney())).setSlotName("DirtyChimney");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 44, 1).addItemStacks(SootyChimneysJeiPlugin.getScrapingTools())).setSlotName("Tool");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 104, 18).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new ScalableItemStackRenderer(2.5f)).addItemStack(recipe.getResultChimney())).setSlotName("CleanChimney");
        List<ChanceResult> results = recipe.results().stream().filter(result -> !result.stack().method_7960() && result.chance() > 0.0f).toList();
        int slotX = 51 + (27 - results.size() * 18 / 2);
        for (int i = 0; i < Math.min(results.size(), 6); ++i) {
            ChanceResult result2 = results.get(i);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, slotX + 18 * i - 1, 47).setSlotName("Result" + i + "1").addItemStack(result2.stack())).addTooltipCallback((recipeSlotView, tooltip) -> {
                if (result2.chance() < 1.0f) {
                    float chance = result2.chance() * 100.0f;
                    String chanceString = chance < 1.0f ? "<1" : Integer.toString((int)chance);
                    tooltip.add(class_2561.method_43469((String)"jei.sootychimneys.chance", (Object[])new Object[]{chanceString}).method_27692(class_124.field_1065));
                }
            });
        }
    }

    public void draw(SootScrapingRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        List<ChanceResult> results = recipe.results().stream().filter(result -> !result.stack().method_7960() && result.chance() > 0.0f).toList();
        if (results.isEmpty()) {
            return;
        }
        this.dust.draw(guiGraphics, 72, 34);
        int slotX = 49 + (27 - results.size() * 18 / 2);
        for (int i = 0; i < results.size(); ++i) {
            ChanceResult result2 = results.get(i);
            if (result2.chance() >= 1.0f) {
                this.slot.draw(guiGraphics, slotX + 18 * i, 46);
                continue;
            }
            this.chanceSlot.draw(guiGraphics, slotX + 18 * i, 46);
        }
    }

    @NotNull
    public class_2561 getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public RecipeType<SootScrapingRecipe> getRecipeType() {
        return JeiRecipeTypes.SOOT_SCRAPING;
    }
}

