/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei;

import io.github.mortuusars.sootychimneys.Config;
import io.github.mortuusars.sootychimneys.PlatformSpecific;
import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.integration.jei.JeiRecipeTypes;
import io.github.mortuusars.sootychimneys.integration.jei.category.SootCoveringRecipeCategory;
import io.github.mortuusars.sootychimneys.integration.jei.category.SootScrapingRecipeCategory;
import io.github.mortuusars.sootychimneys.integration.jei.recipe.SootCoveringJeiRecipe;
import io.github.mortuusars.sootychimneys.recipe.SootScrapingRecipe;
import io.github.mortuusars.sootychimneys.recipe.result.ChanceResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class SootyChimneysJeiPlugin
implements IModPlugin {
    private static final class_2960 UID = SootyChimneys.resource("jei_plugin");

    @NotNull
    public class_2960 getPluginUid() {
        return UID;
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        if (((Boolean)Config.Client.ADD_SOOT_COVERING_TO_JEI.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new SootCoveringRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        }
        if (((Boolean)Config.Client.ADD_SOOT_SCRAPING_TO_JEI.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new SootScrapingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        if (((Boolean)Config.Client.ADD_SOOT_COVERING_TO_JEI.get()).booleanValue()) {
            registration.addRecipes(JeiRecipeTypes.SOOT_COVERING, List.of(new SootCoveringJeiRecipe((class_1792)SootyChimneys.Items.BRICK_CHIMNEY.get(), (class_1792)SootyChimneys.Items.DIRTY_BRICK_CHIMNEY.get()), new SootCoveringJeiRecipe((class_1792)SootyChimneys.Items.COBBLESTONE_CHIMNEY.get(), (class_1792)SootyChimneys.Items.DIRTY_COBBLESTONE_CHIMNEY.get()), new SootCoveringJeiRecipe((class_1792)SootyChimneys.Items.STONE_BRICK_CHIMNEY.get(), (class_1792)SootyChimneys.Items.DIRTY_STONE_BRICK_CHIMNEY.get()), new SootCoveringJeiRecipe((class_1792)SootyChimneys.Items.MUD_BRICK_CHIMNEY.get(), (class_1792)SootyChimneys.Items.DIRTY_MUD_BRICK_CHIMNEY.get()), new SootCoveringJeiRecipe((class_1792)SootyChimneys.Items.IRON_CHIMNEY.get(), (class_1792)SootyChimneys.Items.DIRTY_IRON_CHIMNEY.get()), new SootCoveringJeiRecipe((class_1792)SootyChimneys.Items.COPPER_CHIMNEY.get(), (class_1792)SootyChimneys.Items.DIRTY_COPPER_CHIMNEY.get()), new SootCoveringJeiRecipe((class_1792)SootyChimneys.Items.TERRACOTTA_CHIMNEY.get(), (class_1792)SootyChimneys.Items.DIRTY_TERRACOTTA_CHIMNEY.get())));
        }
        ArrayList<SootScrapingRecipe> recipes = new ArrayList<SootScrapingRecipe>(new ArrayList(Objects.requireNonNull(class_310.method_1551().field_1687).method_8433().method_30027(SootyChimneys.RecipeTypes.SOOT_SCRAPING.get())).stream().map(class_8786::comp_1933).toList());
        recipes.sort((r, r1) -> {
            List<ChanceResult> results = r.results();
            List<ChanceResult> results1 = r1.results();
            if (results.isEmpty()) {
                return results1.isEmpty() ? -1 : 0;
            }
            if (results1.isEmpty()) {
                return 1;
            }
            return Float.compare(results1.getFirst().chance(), results.getFirst().chance());
        });
        registration.addRecipes(JeiRecipeTypes.SOOT_SCRAPING, recipes);
    }

    public static List<class_1799> getScrapingTools() {
        return class_7923.field_41178.method_10220().map(class_1799::new).filter(PlatformSpecific::canBeUsedToScrapeSoot).toList();
    }
}

