/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.block;

import io.github.mortuusars.sootychimneys.Config;
import io.github.mortuusars.sootychimneys.PlatformSpecific;
import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.block.ChimneyBlockEntity;
import io.github.mortuusars.sootychimneys.data.Chimney;
import io.github.mortuusars.sootychimneys.data.ChimneyType;
import io.github.mortuusars.sootychimneys.data.smoke.ParticleOrigin;
import io.github.mortuusars.sootychimneys.data.smoke.ParticleSpread;
import io.github.mortuusars.sootychimneys.data.smoke.SmokeProperties;
import io.github.mortuusars.sootychimneys.data.wind.Wind;
import io.github.mortuusars.sootychimneys.data.wind.WindData;
import io.github.mortuusars.sootychimneys.recipe.SootScrapingRecipe;
import io.github.mortuusars.sootychimneys.recipe.result.ChanceResult;
import io.github.mortuusars.sootychimneys.utils.RandomOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_9062;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ChimneyBlock
extends class_2248
implements class_2343 {
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2746 BLOCKED = class_2746.method_11825((String)"blocked");
    public static final class_2746 STACKED = class_2746.method_11825((String)"stacked");
    protected final ChimneyType type;
    protected final Chimney.State state;

    public ChimneyBlock(class_4970.class_2251 properties, Chimney.State state, ChimneyType type) {
        super(properties);
        this.state = state;
        this.type = type;
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)BLOCKED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)STACKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIT}).method_11667(new class_2769[]{BLOCKED}).method_11667(new class_2769[]{STACKED});
    }

    @NotNull
    public class_265 method_9530(class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return (Boolean)state.method_11654((class_2769)STACKED) != false ? this.getStackedShape() : this.getRegularShape();
    }

    public Chimney.State getChimneyState() {
        return this.state;
    }

    public ChimneyType getType() {
        return this.type;
    }

    @NotNull
    public class_265 getRegularShape() {
        return this.getType().shape().regular();
    }

    @NotNull
    public class_265 getStackedShape() {
        return this.getType().shape().stacked();
    }

    public boolean isClean() {
        return this.state == Chimney.State.CLEAN;
    }

    public boolean isDirty() {
        return this.state == Chimney.State.DIRTY;
    }

    public boolean shouldEmitSmoke(class_2680 blockState, class_1937 level, class_2338 pos) {
        return (Boolean)blockState.method_11654((class_2769)LIT) != false && (Boolean)blockState.method_11654((class_2769)BLOCKED) == false && (Boolean)blockState.method_11654((class_2769)STACKED) == false && !level.method_8320(pos.method_10084()).method_26164(SootyChimneys.Tags.Blocks.SMOKE_BLOCKING);
    }

    @NotNull
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        boolean newBlockedValue;
        if (!player.method_6047().method_7960()) {
            return super.method_55766(state, level, pos, player, hitResult);
        }
        boolean bl = newBlockedValue = (Boolean)state.method_11654((class_2769)BLOCKED) == false;
        if (!level.field_9236 && level.method_8652(pos, (class_2680)state.method_11657((class_2769)BLOCKED, (Comparable)Boolean.valueOf(newBlockedValue)), 3)) {
            class_5819 random = level.method_8409();
            level.method_8396(null, pos, newBlockedValue ? class_3417.field_17746 : class_3417.field_17742, class_3419.field_15245, 0.8f, 0.85f + random.method_43057() * 0.05f);
            ParticleOrigin particleOrigin = this.getType().smokeProperties().getParticleOrigin();
            for (int i = 0; i < random.method_43048(5); ++i) {
                ((class_3218)level).method_14199((class_2394)class_2398.field_11251, (double)((float)pos.method_10263() + particleOrigin.x()), (double)((float)pos.method_10264() + particleOrigin.y()) - 0.1, (double)((float)pos.method_10260() + particleOrigin.z()), 1, random.method_43059() * 0.1, random.method_43059() * 0.1, random.method_43059() * 0.1, 0.0);
            }
            String messageTranslationKey = "message.sootychimneys." + (newBlockedValue ? "blocked" : "open");
            player.method_7353((class_2561)class_2561.method_43471((String)messageTranslationKey), true);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    @NotNull
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        ChimneyBlock chimney;
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ChimneyBlock && (chimney = (ChimneyBlock)class_22482).isDirty() && PlatformSpecific.canBeUsedToScrapeSoot(stack))) {
            return super.method_55765(stack, state, level, pos, player, hand, hitResult);
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_174.field_24478.method_23889(serverPlayer, pos, stack);
        }
        class_2680 cleanBlockState = Chimney.getCleanBlock(this).method_34725(state);
        level.method_8652(pos, cleanBlockState, 3);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            player.method_7281(SootyChimneys.Stats.SOOT_SCRAPED);
            Optional<Supplier<List<class_1799>>> scrapingResult = this.getScrapedItems(state, serverLevel);
            scrapingResult.ifPresent(items -> {
                List itemStacks = (List)items.get();
                class_2382 faceNormal = hitResult.method_17780().method_10163();
                Vector3f itemSpawnPosition = new Vector3f((float)pos.method_10263() + 0.5f + (float)faceNormal.method_10263() * 0.65f, (float)pos.method_10264() + 0.6f + (float)faceNormal.method_10264() * 0.65f, (float)pos.method_10260() + 0.5f + (float)faceNormal.method_10260() * 0.65f);
                this.spawnSootScrapingItems(itemSpawnPosition, serverLevel, itemStacks);
            });
            stack.method_7970(1, (class_1309)player, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
            level.method_45447(player, pos, class_3417.field_29541, class_3419.field_15245);
        } else {
            level.method_45447(player, pos, class_3417.field_29541, class_3419.field_15245);
            chimney.spawnSootParticles(level, pos, false);
        }
        return class_9062.field_47728;
    }

    public void method_9615(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 oldState, boolean isMoving) {
        this.updateState(state, level, pos);
    }

    public void method_9612(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2248 block, @NotNull class_2338 fromPos, boolean isMoving) {
        this.updateState(state, level, pos);
    }

    protected void updateState(class_2680 state, class_1937 level, class_2338 pos) {
        ChimneyBlock chimney;
        class_2248 class_22482;
        boolean stacked = level.method_8320(pos.method_10084()).method_26204() instanceof ChimneyBlock;
        if (stacked && (class_22482 = state.method_26204()) instanceof ChimneyBlock && (chimney = (ChimneyBlock)class_22482).isDirty()) {
            state = Chimney.getCleanBlock(chimney).method_9564();
            chimney.spawnSootParticles(level, pos, true);
        }
        level.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(!level.method_49803(pos)))).method_11657((class_2769)STACKED, (Comparable)Boolean.valueOf(stacked)), 3);
    }

    public class_2394 getParticle(class_2680 state, class_1937 level, class_2338 pos) {
        class_2680 stateBelow = level.method_8320(pos.method_10074());
        return stateBelow.method_26204() instanceof ChimneyBlock && (Boolean)stateBelow.method_11654((class_2769)STACKED) != false || stateBelow.method_26164(SootyChimneys.Tags.Blocks.SMOKE_BOOSTING) ? class_2398.field_17431 : class_2398.field_17430;
    }

    public void emitParticle(class_1937 level, double x, double y, double z, class_2394 particleType) {
        if (!level.field_9236) {
            return;
        }
        SmokeProperties smokeProperties = this.getType().smokeProperties();
        class_5819 random = level.method_8409();
        if (random.method_43057() > smokeProperties.getIntensity()) {
            return;
        }
        ParticleOrigin particleOffset = smokeProperties.getParticleOrigin();
        x += (double)particleOffset.x() - 0.5;
        y += (double)particleOffset.y() - 0.5;
        z += (double)particleOffset.z() - 0.5;
        WindData wind = Wind.getWind();
        float strength = wind.getAdjustedStrength();
        double xSpeed = wind.getXCoordinate() * (double)strength;
        double ySpeed = 0.05 * (double)smokeProperties.getSpeed();
        double zSpeed = wind.getYCoordinate() * (double)strength;
        xSpeed += (double)((random.method_43057() * strength - strength / 2.0f) * 0.2f);
        zSpeed += (double)((random.method_43057() * strength - strength / 2.0f) * 0.2f);
        ParticleSpread particleSpread = smokeProperties.getParticleSpread();
        int maxParticles = (int)(4.0f * Math.max(smokeProperties.getIntensity(), 0.5f));
        for (int i = 0; i < random.method_43048(maxParticles); ++i) {
            level.method_17452(particleType, true, RandomOffset.offset(x, particleSpread.x()), RandomOffset.offset(y, particleSpread.y()), RandomOffset.offset(z, particleSpread.z()), xSpeed, ySpeed, zSpeed);
        }
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 pPos, @NotNull class_2680 pState) {
        return new ChimneyBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> type) {
        return level.method_8608() && type == SootyChimneys.BlockEntityTypes.CHIMNEY.get() ? ChimneyBlockEntity::particleTick : null;
    }

    public boolean method_9542(class_2680 blockState) {
        ChimneyBlock chimney;
        class_2248 class_22482 = blockState.method_26204();
        return class_22482 instanceof ChimneyBlock && (chimney = (ChimneyBlock)class_22482).isClean();
    }

    public void method_9514(class_2680 blockState, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        ChimneyBlock chimney;
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof ChimneyBlock && (chimney = (ChimneyBlock)class_22482).isClean() && this.shouldEmitSmoke(blockState, (class_1937)level, pos) && random.method_43058() < (Double)Config.Common.DIRTY_CHANCE.get()) {
            level.method_8652(pos, Chimney.getDirtyBlock(chimney).method_9564(), 3);
        }
    }

    protected Optional<Supplier<List<class_1799>>> getScrapedItems(class_2680 state, class_3218 level) {
        class_9696 input = new class_9696(new class_1799((class_1935)state.method_26204().method_8389()));
        Optional recipeOptional = level.method_8433().method_8132(SootyChimneys.RecipeTypes.SOOT_SCRAPING.get(), (class_9695)input, (class_1937)level);
        return recipeOptional.map(recipeHolder -> () -> {
            SootScrapingRecipe recipe = (SootScrapingRecipe)recipeHolder.comp_1933();
            ArrayList<class_1799> items = new ArrayList<class_1799>();
            for (ChanceResult result : recipe.results()) {
                class_1799 itemStack = result.rollOutput(level.method_8409());
                if (itemStack.method_7960()) continue;
                items.add(itemStack);
            }
            return items;
        });
    }

    public void spawnSootScrapingItems(Vector3f pos, class_3218 level, List<class_1799> items) {
        for (class_1799 itemStack : items) {
            class_1264.method_5449((class_1937)level, (double)pos.x(), (double)pos.y(), (double)pos.z(), (class_1799)itemStack);
        }
    }

    public void method_9585(class_1936 level, class_2338 pos, class_2680 state) {
        if (level instanceof class_1937) {
            ChimneyBlock chimney;
            class_1937 lvl = (class_1937)level;
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof ChimneyBlock && (chimney = (ChimneyBlock)class_22482).isDirty()) {
                chimney.spawnSootParticles(lvl, pos, false);
            }
        }
    }

    public void spawnSootParticles(class_1937 level, class_2338 pos, boolean serverSide) {
        class_5819 random = level.method_8409();
        double x = (double)pos.method_10263() + 0.5;
        double y = (double)pos.method_10264() + 0.5;
        double z = (double)pos.method_10260() + 0.5;
        for (int i = 0; i < random.method_43051(12, 20); ++i) {
            if (serverSide && level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)class_2398.field_11237, RandomOffset.offset(x, 0.8f), RandomOffset.offset(y, 0.8f), RandomOffset.offset(z, 0.8f), 1, 0.0, 0.0, 0.0, 0.0);
                continue;
            }
            level.method_8406((class_2394)class_2398.field_11237, RandomOffset.offset(x, 0.8f), RandomOffset.offset(y, 0.8f), RandomOffset.offset(z, 0.8f), 0.0, 0.0, 0.0);
        }
    }
}

