/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftbessentials.util.DimensionFilter;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class TeleportPos {
    private final class_5321<class_1937> dimension;
    private final class_2338 pos;
    public final Float yRot;
    public final Float xRot;
    private final long time;

    public TeleportPos(class_5321<class_1937> d, class_2338 p) {
        this(d, p, null, null);
    }

    public TeleportPos(class_5321<class_1937> d, class_2338 p, Float yRot, Float xRot) {
        this.dimension = d;
        this.pos = p;
        this.yRot = yRot;
        this.xRot = xRot;
        this.time = System.currentTimeMillis();
    }

    public TeleportPos(class_1937 world, class_2338 p, Float yRot, Float xRot) {
        this((class_5321<class_1937>)world.method_27983(), p, yRot, xRot);
    }

    public TeleportPos(class_1297 entity) {
        this(entity.method_37908(), entity.method_24515(), Float.valueOf(entity.method_36454()), Float.valueOf(entity.method_36455()));
    }

    public TeleportPos(class_2487 tag) {
        this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)tag.method_10558("dim")));
        this.pos = new class_2338(tag.method_10550("x"), tag.method_10550("y"), tag.method_10550("z"));
        this.yRot = tag.method_10540("yRot") == 5 ? Float.valueOf(tag.method_10583("yRot")) : null;
        this.xRot = tag.method_10540("xRot") == 5 ? Float.valueOf(tag.method_10583("xRot")) : null;
        this.time = tag.method_10537("time");
    }

    public TeleportPos safeForPlayer(class_3222 player) {
        class_3218 level = player.method_5682().method_3847(this.dimension);
        if (level == null) {
            return this;
        }
        return this.tryFindSafePos(level, class_2350.field_11043, class_2350.field_11039).or(() -> this.tryFindSafePos(level, class_2350.field_11035, class_2350.field_11034)).orElse(this);
    }

    private Optional<TeleportPos> tryFindSafePos(class_3218 level, class_2350 dir1, class_2350 dir2) {
        for (class_2338 p0 : class_2338.method_30512((class_2338)this.pos, (int)16, (class_2350)dir1, (class_2350)dir2)) {
            for (int yOff = -3; yOff <= 3; ++yOff) {
                class_2338 p1 = p0.method_30513(class_2350.class_2351.field_11052, yOff);
                class_2338 p2 = p1.method_10084();
                if (level.method_8320(p1).method_26228((class_1922)level, p1) || level.method_8320(p2).method_26228((class_1922)level, p2)) continue;
                return Optional.of(new TeleportPos(this.dimension, p1.method_10062(), this.yRot, this.xRot));
            }
        }
        return Optional.empty();
    }

    public TeleportResult checkDimensionBlacklist(class_1657 player) {
        if (!DimensionFilter.isDimensionOKTo(this.dimension)) {
            return TeleportResult.DIMENSION_NOT_ALLOWED_TO;
        }
        if (!DimensionFilter.isDimensionOKFrom((class_5321<class_1937>)player.method_37908().method_27983())) {
            return TeleportResult.DIMENSION_NOT_ALLOWED_FROM;
        }
        return TeleportResult.SUCCESS;
    }

    public TeleportResult teleport(class_3222 player) {
        class_3218 level = player.field_13995.method_3847(this.dimension);
        if (level == null) {
            return TeleportResult.DIMENSION_NOT_FOUND;
        }
        int xpLevel = player.field_7520;
        float xrot = this.xRot == null ? player.method_36455() : this.xRot.floatValue();
        float yrot = this.yRot == null ? player.method_36454() : this.yRot.floatValue();
        player.method_14251(level, (double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.1, (double)this.pos.method_10260() + 0.5, yrot, xrot);
        player.method_14252(xpLevel);
        return TeleportResult.SUCCESS;
    }

    public class_2487 write() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.singleLine();
        tag.method_10582("dim", this.dimension.method_29177().toString());
        tag.method_10569("x", this.pos.method_10263());
        tag.method_10569("y", this.pos.method_10264());
        tag.method_10569("z", this.pos.method_10260());
        tag.method_10544("time", this.time);
        if (this.xRot != null) {
            tag.method_10548("xRot", this.xRot.floatValue());
        }
        if (this.yRot != null) {
            tag.method_10548("yRot", this.yRot.floatValue());
        }
        return tag;
    }

    public String distanceString(TeleportPos origin) {
        if (origin.dimension == this.dimension) {
            double dx = this.pos.method_10263() - origin.pos.method_10263();
            double dz = this.pos.method_10260() - origin.pos.method_10260();
            return (int)Math.sqrt(dx * dx + dz * dz) + "m";
        }
        class_2960 s = this.dimension.method_29177();
        if (s.method_12836().equals("minecraft")) {
            return switch (s.method_12832()) {
                case "overworld" -> "Overworld";
                case "the_nether" -> "The Nether";
                case "the_end" -> "The End";
                default -> s.method_12832();
            };
        }
        return s.method_12832() + " [" + s.method_12836() + "]";
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public String posAsString() {
        return this.pos.method_23854().replaceAll(",", "");
    }

    @FunctionalInterface
    public static interface TeleportResult {
        public static final TeleportResult SUCCESS = new TeleportResult(){

            @Override
            public int runCommand(class_3222 player) {
                return 1;
            }

            @Override
            public boolean isSuccess() {
                return true;
            }
        };
        public static final TeleportResult DIMENSION_NOT_FOUND = TeleportResult.failed((class_2561)class_2561.method_43471((String)"ftbessentials.dimension_not_found"));
        public static final TeleportResult UNKNOWN_DESTINATION = TeleportResult.failed((class_2561)class_2561.method_43471((String)"ftbessentials.unknown_dest"));
        public static final TeleportResult DIMENSION_NOT_ALLOWED_FROM = TeleportResult.failed((class_2561)class_2561.method_43471((String)"ftbessentials.teleport.not_from_here"));
        public static final TeleportResult DIMENSION_NOT_ALLOWED_TO = TeleportResult.failed((class_2561)class_2561.method_43471((String)"ftbessentials.teleport.not_to_here"));

        public static TeleportResult failed(class_2561 msg) {
            return player -> {
                player.method_7353(msg, false);
                return 0;
            };
        }

        public int runCommand(class_3222 var1);

        default public boolean isSuccess() {
            return false;
        }
    }

    @FunctionalInterface
    public static interface CooldownTeleportResult
    extends TeleportResult {
        public long getCooldown();

        @Override
        default public int runCommand(class_3222 player) {
            String secStr = TimeUtils.prettyTimeString((long)(this.getCooldown() / 1000L));
            player.method_7353((class_2561)class_2561.method_43469((String)"ftbessentials.teleport.on_cooldown", (Object[])new Object[]{secStr}), false);
            return 0;
        }
    }
}

