/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class DimensionFilter {
    private static WildcardedRLMatcher rtpDimensionMatcherB = null;
    private static WildcardedRLMatcher rtpDimensionMatcherW = null;
    private static WildcardedRLMatcher allDimensionMatcherBTo = null;
    private static WildcardedRLMatcher allDimensionMatcherBFrom = null;

    public static boolean isRtpDimensionOK(class_5321<class_1937> levelKey) {
        class_2960 name = levelKey.method_29177();
        return !DimensionFilter.getRtpDimensionBlacklist().test(name) && (DimensionFilter.getRtpDimensionWhitelist().isEmpty() || DimensionFilter.getRtpDimensionWhitelist().test(name));
    }

    public static boolean isDimensionOKFrom(class_5321<class_1937> levelKey) {
        class_2960 name = levelKey.method_29177();
        return !DimensionFilter.getAllCommandDimensionBlacklistFrom().test(name);
    }

    public static boolean isDimensionOKTo(class_5321<class_1937> levelKey) {
        class_2960 name = levelKey.method_29177();
        return !DimensionFilter.getAllCommandDimensionBlacklistTo().test(name);
    }

    private static WildcardedRLMatcher getRtpDimensionWhitelist() {
        if (rtpDimensionMatcherW == null) {
            rtpDimensionMatcherW = new WildcardedRLMatcher((Collection)FTBEConfig.RTP_DIMENSION_WHITELIST.get());
        }
        return rtpDimensionMatcherW;
    }

    private static WildcardedRLMatcher getRtpDimensionBlacklist() {
        if (rtpDimensionMatcherB == null) {
            rtpDimensionMatcherB = new WildcardedRLMatcher((Collection)FTBEConfig.RTP_DIMENSION_BLACKLIST.get());
        }
        return rtpDimensionMatcherB;
    }

    private static WildcardedRLMatcher getAllCommandDimensionBlacklistFrom() {
        if (allDimensionMatcherBFrom == null) {
            allDimensionMatcherBFrom = new WildcardedRLMatcher((Collection)FTBEConfig.TELEPORTATION_BLACKLIST_FROM.get());
        }
        return allDimensionMatcherBFrom;
    }

    private static WildcardedRLMatcher getAllCommandDimensionBlacklistTo() {
        if (allDimensionMatcherBTo == null) {
            allDimensionMatcherBTo = new WildcardedRLMatcher((Collection)FTBEConfig.TELEPORTATION_BLACKLIST_TO.get());
        }
        return allDimensionMatcherBTo;
    }

    public static void clearMatcherCaches() {
        rtpDimensionMatcherB = null;
        rtpDimensionMatcherW = null;
        allDimensionMatcherBFrom = null;
        allDimensionMatcherBTo = null;
    }

    private static class WildcardedRLMatcher
    implements Predicate<class_2960> {
        private final Set<String> namespaces = new ObjectOpenHashSet();
        private final Set<class_2960> reslocs = new ObjectOpenHashSet();

        public WildcardedRLMatcher(Collection<String> toMatch) {
            for (String s : toMatch) {
                if (s.endsWith(":*")) {
                    this.namespaces.add(s.split(":")[0]);
                    continue;
                }
                class_2960 location = class_2960.method_12829((String)s);
                if (location == null) continue;
                this.reslocs.add(location);
            }
        }

        public boolean isEmpty() {
            return this.reslocs.isEmpty() && this.namespaces.isEmpty();
        }

        @Override
        public boolean test(class_2960 resourceLocation) {
            return this.reslocs.contains(resourceLocation) || this.namespaces.contains(resourceLocation.method_12836());
        }
    }
}

