/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.teleporting;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.api.records.TPARequest;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class TPACommand
implements FTBCommand {
    private static final HashMap<UUID, TPARequest> REQUESTS = new HashMap();
    private static final class_2561 INVALID_REQUEST = class_2561.method_43471((String)"ftbessentials.tpa.invalid_request").method_27692(class_124.field_1061);

    @Override
    public boolean enabled() {
        return FTBEConfig.TPA.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<class_2168>> register() {
        return List.of((LiteralArgumentBuilder)class_2170.method_9247((String)"tpa").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(context -> this.tpa(((class_2168)context.getSource()).method_9207(), class_2186.method_9315((CommandContext)context, (String)"target"), false))), (LiteralArgumentBuilder)class_2170.method_9247((String)"tpahere").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(context -> this.tpa(((class_2168)context.getSource()).method_9207(), class_2186.method_9315((CommandContext)context, (String)"target"), true))), (LiteralArgumentBuilder)class_2170.method_9247((String)"tpaccept").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> this.tpaccept(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"id")))), (LiteralArgumentBuilder)class_2170.method_9247((String)"tpdeny").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> this.tpdeny(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"id")))));
    }

    public int tpa(class_3222 player, class_3222 target, boolean here) {
        TeleportPos.TeleportResult result;
        FTBEPlayerData dataSource = FTBEPlayerData.getOrCreate((class_1657)player).orElse(null);
        FTBEPlayerData dataTarget = FTBEPlayerData.getOrCreate((class_1657)target).orElse(null);
        if (dataSource == null || dataTarget == null) {
            return 0;
        }
        if (REQUESTS.values().stream().anyMatch(r -> r.source() == dataSource && r.target() == dataTarget)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.tpa.already_sent"), false);
            return 0;
        }
        TeleportPos.TeleportResult teleportResult = result = here ? dataTarget.tpaTeleporter.checkCooldown(target) : dataSource.tpaTeleporter.checkCooldown(player);
        if (!result.isSuccess()) {
            return result.runCommand(player);
        }
        TPARequest request = TPACommand.create(dataSource, dataTarget, here);
        class_5250 line1 = class_2561.method_43469((String)"ftbessentials.tpa.notify", (Object[])new Object[]{(here ? target : player).method_5476().method_27661().method_27692(class_124.field_1054), (here ? player : target).method_5476().method_27661().method_27692(class_124.field_1054)});
        class_5250 line2 = class_2561.method_43471((String)"ftbessentials.tpa.click_one");
        line2.method_10852((class_2561)class_2561.method_43471((String)"ftbessentials.tpa.accept").method_10862(class_2583.field_24360.method_27706(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/tpaccept " + String.valueOf(request.id()))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"ftbessentials.tpa.accept.tooltip")))));
        line2.method_27693(" | ");
        line2.method_10852((class_2561)class_2561.method_43471((String)"ftbessentials.tpa.deny").method_10862(class_2583.field_24360.method_27706(class_124.field_1061).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/tpdeny " + String.valueOf(request.id()))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"ftbessentials.tpa.deny.tooltip")))));
        line2.method_27693(" |");
        target.method_7353((class_2561)line1, false);
        target.method_7353((class_2561)line2, false);
        player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.tpa.request_sent"), false);
        return 1;
    }

    public int tpaccept(class_3222 player, String id) {
        TeleportPos.TeleportResult result;
        UUID uuid = this.attemptUuid(id);
        if (uuid == null) {
            player.method_7353(INVALID_REQUEST, false);
            return 0;
        }
        TPARequest request = REQUESTS.get(uuid);
        if (request == null) {
            player.method_7353(INVALID_REQUEST, false);
            return 0;
        }
        class_3222 sourcePlayer = player.field_13995.method_3760().method_14602(request.source().getUuid());
        if (sourcePlayer == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.tpa.gone_offline").method_27692(class_124.field_1065), false);
            return 0;
        }
        TeleportPos.TeleportResult teleportResult = result = request.here() ? request.target().tpaTeleporter.teleport(player, p -> new TeleportPos((class_1297)sourcePlayer)) : request.source().tpaTeleporter.teleport(sourcePlayer, p -> new TeleportPos((class_1297)player));
        if (result.isSuccess()) {
            REQUESTS.remove(request.id());
        }
        return result.runCommand(player);
    }

    public int tpdeny(class_3222 player, String id) {
        UUID uuid = this.attemptUuid(id);
        if (uuid == null) {
            player.method_7353(INVALID_REQUEST, false);
            return 0;
        }
        TPARequest request = REQUESTS.get(uuid);
        if (request == null) {
            player.method_7353(INVALID_REQUEST, false);
            return 0;
        }
        REQUESTS.remove(request.id());
        player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.tpa.denied"), false);
        class_3222 player2 = player.field_13995.method_3760().method_14602(request.target().getUuid());
        if (player2 != null) {
            player2.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.tpa.denied"), false);
        }
        return 1;
    }

    public static TPARequest create(FTBEPlayerData source, FTBEPlayerData target, boolean here) {
        UUID uuid = UUID.randomUUID();
        TPARequest r = new TPARequest(uuid, source, target, here, System.currentTimeMillis());
        REQUESTS.put(uuid, r);
        return r;
    }

    public static void clearRequests() {
        REQUESTS.clear();
    }

    @Nullable
    private UUID attemptUuid(String id) {
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static HashMap<UUID, TPARequest> requests() {
        return REQUESTS;
    }
}

