/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.mehvahdjukaar.smarterfarmers.EatFoodGoal;
import net.mehvahdjukaar.smarterfarmers.mixins.VillagerAccessor;
import net.minecraft.class_1291;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3988;
import net.minecraft.class_4168;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmarterFarmers {
    public static final String MOD_ID = "smarterfarmers";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean QUARK = PlatHelper.isModLoaded((String)"quark");
    public static final class_6862<class_2248> SPECIAL_HARVESTABLE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)SmarterFarmers.res("harvestable_plant"));
    public static final class_6862<class_2248> HARVESTABLE_ON_DIRT_NO_REPLANT = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)SmarterFarmers.res("harvestable_on_dirt_no_replant"));
    public static final class_6862<class_2248> HARVESTABLE_ON_DIRT = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)SmarterFarmers.res("harvestable_on_dirt"));
    public static final class_6862<class_2248> VALID_FARMLAND = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)SmarterFarmers.res("farmer_plantable_on"));
    public static final class_6862<class_1792> EAT_BLACKLIST = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)SmarterFarmers.res("villagers_cant_eat"));
    public static final class_6862<class_1792> STEM_SEEDS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)SmarterFarmers.res("stem_seeds"));
    public static final class_6862<class_2248> FARMER_TILLABLE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)SmarterFarmers.res("farmer_tillable"));
    public static final Supplier<Boolean> PICKUP_FOOD;
    public static final Supplier<Boolean> EAT_FOOD;
    public static final Supplier<Boolean> DEBUG_RENDERERS;
    public static final Supplier<Boolean> PLANT_ON_DIRT;
    public static final Supplier<Integer> TIME_TO_HARVEST;
    public static final ModConfigHolder CONFIG;
    private static final Map<class_1792, Integer> OLD_FOOD_POINTS;

    public static class_2960 res(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        MoonlightEventsHelper.addListener(SmarterFarmers::onVillagerBrainInitialize, IVillagerBrainEvent.class);
    }

    public static void setupWithTags(class_5455 registryAccess, boolean client) {
        if (OLD_FOOD_POINTS.isEmpty()) {
            OLD_FOOD_POINTS.putAll(class_1646.field_18526);
        }
        try {
            HashMap<class_1792, Integer> newMap = new HashMap<class_1792, Integer>(OLD_FOOD_POINTS);
            for (class_1792 i : class_7923.field_41178) {
                class_4174 foodProperties = (class_4174)i.method_57347().method_57829(class_9334.field_50075);
                if (foodProperties == null || i.method_57347().method_57830(class_9334.field_50073, (Object)class_1814.field_8906) != class_1814.field_8906 || i.method_40131().method_40220(EAT_BLACKLIST) || !foodProperties.comp_2495().stream().allMatch(e -> ((class_1291)e.comp_2496().method_5579().comp_349()).method_5573()) || i.method_7857() || i.method_7882() <= 1) continue;
                newMap.put(i, (int)Math.max(1.0f, (float)(foodProperties.comp_2491() * 2) / 3.0f));
            }
            VillagerAccessor.setFoodPoints(newMap);
        }
        catch (Exception e2) {
            LOGGER.warn("Failed to add custom foods to villagers");
        }
    }

    public static void onVillagerBrainInitialize(IVillagerBrainEvent event) {
        if (EAT_FOOD.get().booleanValue()) {
            event.addTaskToActivity(class_4168.field_18598, Pair.of((Object)7, (Object)((Object)new EatFoodGoal(100, 140))));
        }
    }

    public static void spawnEatingParticles(class_3988 villager) {
        class_243 pos = new class_243(0.0, 0.0, 0.4);
        pos = pos.method_1024(-villager.field_6283 * ((float)Math.PI / 180));
        pos = pos.method_1031(villager.method_23317(), villager.method_23320(), villager.method_23321());
        class_1799 stack = villager.method_6047();
        class_1937 level = villager.method_37908();
        level.method_8406((class_2394)new class_2392(class_2398.field_11218, stack), pos.field_1352 + (double)class_3532.method_32750((class_5819)level.field_9229, (float)-0.05f, (float)0.05f), pos.field_1351 - 0.4 + (double)class_3532.method_32750((class_5819)level.field_9229, (float)-0.05f, (float)0.05f), pos.field_1350 + (double)class_3532.method_32750((class_5819)level.field_9229, (float)-0.05f, (float)0.05f), 0.03, 0.05, 0.03);
    }

    static {
        ConfigBuilder builder = ConfigBuilder.create((String)MOD_ID, (ConfigType)ConfigType.COMMON);
        builder.push("general");
        PICKUP_FOOD = builder.comment("If true, villagers will pick up food items from the regardless of mob griefing gamerule. Needed since with mob griefing on they wont be able to breed.").define("pickup_food_override", true);
        EAT_FOOD = builder.comment("If true, villagers will eat food items they pick up. Eating food will heal them").define("eat_food", true);
        TIME_TO_HARVEST = builder.comment("Time for a farmer to harvest a crop once it reached its destination").define("time_to_harvest", 40, 1, 1000);
        DEBUG_RENDERERS = PlatHelper.isDev() ? () -> true : builder.comment("If true, will render debug info for farmers. Only works in single player").define("debug_renderer", false);
        PLANT_ON_DIRT = builder.comment("If true, farmers will plant crops on dirt blocks by tilling them. Valid blocks are controlled by farmer_tillable tag").define("plant_on_dirt", false);
        builder.pop();
        CONFIG = builder.build();
        OLD_FOOD_POINTS = new HashMap<class_1792, Integer>();
    }
}

