/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.basic_skill_sets;

import com.cleannrooster.basic_skill_sets.Spells;
import com.cleannrooster.basic_skill_sets.api.HitstopAccessor;
import com.cleannrooster.basic_skill_sets.api.SkillSources;
import com.cleannrooster.basic_skill_sets.config.ConfigSync;
import com.cleannrooster.basic_skill_sets.config.ServerConfig;
import com.cleannrooster.basic_skill_sets.config.ServerConfigWrapper;
import com.cleannrooster.basic_skill_sets.networking.Packet;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.LinkedHashMap;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.spell_engine.api.event.CombatEvents;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.event.SpellEvents;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.utils.VectorHelper;
import net.spell_engine.utils.WorldScheduler;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSkillSets
implements ModInitializer {
    public static final String MOD_ID = "basic-skill-sets";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"basic-skill-sets");
    public static ServerConfig config;
    public static ServerConfig clientConfig;
    public static SkillSources sources;
    public static LinkedHashMap<String, List<class_2960>> skills;
    public static final Multimap<class_6880<class_1320>, class_1322> map;

    public static SkillSources getSkillSources() {
        return sources;
    }

    public void onInitialize() {
        AutoConfig.register(ServerConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        config = ((ServerConfigWrapper)AutoConfig.getConfigHolder(ServerConfigWrapper.class).getConfig()).server;
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSync(config)));
        PayloadTypeRegistry.playS2C().register(ConfigSync.PACKET_ID, ConfigSync.CODEC);
        PayloadTypeRegistry.playC2S().register(Packet.Packets.PACKET_ID, Packet.Packets.CODEC);
        PayloadTypeRegistry.playC2S().register(Packet.Impulse.PACKET_ID, Packet.Impulse.CODEC);
        PayloadTypeRegistry.playC2S().register(Packet.SlowFirst.PACKET_ID, Packet.SlowFirst.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(Packet.SlowFirst.PACKET_ID, (payload, context) -> {
            class_3222 patt0$temp = context.player();
            if (patt0$temp instanceof HitstopAccessor) {
                HitstopAccessor hitstopAccessor = (HitstopAccessor)patt0$temp;
                hitstopAccessor.setLastAttackedTemporary(context.player().method_37908().method_8510());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(Packet.Impulse.PACKET_ID, (payload, context) -> {
            class_1297 entity = context.player().method_37908().method_8469(payload.id());
            if (entity instanceof HitstopAccessor) {
                HitstopAccessor hitstopAccessor = (HitstopAccessor)entity;
                hitstopAccessor.setImpulseVector(hitstopAccessor.getImpulseVector().method_1021((double)payload.mag2()).method_1019(new class_243((double)payload.x(), (double)payload.y(), (double)payload.z())).method_1021((double)payload.mag()));
                entity.method_18799(entity.method_18798());
                entity.field_6037 = true;
                entity.field_6007 = true;
            }
        });
        SpellEvents.PROJECTILE_SHOOT.register(spell -> {
            class_1309 patt0$temp;
            if (BasicSkillSets.config.projectileSelfKnockback && ((Spell)spell.spellEntry().comp_349()).impacts.stream().anyMatch(impact -> impact.action.type.equals((Object)Spell.Impact.Action.Type.DAMAGE)) && (patt0$temp = spell.caster()) instanceof HitstopAccessor) {
                HitstopAccessor hitstopAccessor = (HitstopAccessor)patt0$temp;
                if (((Spell)spell.spellEntry().comp_349()).deliver.type.equals((Object)Spell.Delivery.Type.PROJECTILE)) {
                    double speed = 0.0;
                    for (Spell.Impact impact2 : ((Spell)spell.spellEntry().comp_349()).impacts) {
                        if (!impact2.action.type.equals((Object)Spell.Impact.Action.Type.DAMAGE)) continue;
                        speed += (double)(0.5f * impact2.action.damage.spell_power_coefficient) * Math.pow(SpellPower.getSpellPower((SpellSchool)(impact2.school != null ? impact2.school : ((Spell)spell.spellEntry().comp_349()).school), (class_1309)spell.caster()).baseValue(), 0.73118f) / 10.0;
                    }
                    System.out.println(spell.caster().method_5720().method_1029().method_18805(speed, speed, speed).method_1021(-1.0).method_1033());
                    hitstopAccessor.setImpulseVector(hitstopAccessor.getImpulseVector().method_1019(spell.caster().method_5720().method_1029().method_18805(speed, speed, speed).method_1021(-1.0)));
                    spell.caster().field_6007 = true;
                    spell.caster().field_6037 = true;
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(Packet.Packets.PACKET_ID, (payload, context) -> BasicSkillSets.spawnParticlesSlash((class_1309)context.player(), context.player().method_51469(), payload.yaw(), payload.pitch(), payload.range()));
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            sources = new SkillSources(skills);
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            clientConfig = config;
        });
        CombatEvents.ENTITY_SHIELD_BLOCK.register(c -> {
            class_1309 patt0$temp = c.entity();
            if (patt0$temp instanceof class_1657) {
                class_1297 patt1$temp;
                class_1657 player = (class_1657)patt0$temp;
                if (c.source().method_5529() != null && (double)c.source().method_5529().method_5739((class_1297)c.entity()) < player.method_55755() && (patt1$temp = c.source().method_5529()) instanceof class_1309) {
                    class_1309 living = (class_1309)patt1$temp;
                    ((WorldScheduler)c.entity().method_37908()).schedule(10, () -> {
                        if (!c.entity().method_6039() && c.source().method_5529() != null) {
                            SpellHelper.performSpell((class_1937)c.entity().method_37908(), (class_1657)player, (class_6880)((class_6880)SpellRegistry.from((class_1937)player.method_37908()).method_55841(class_2960.method_60655((String)MOD_ID, (String)"shield_bash")).get()), (SpellTarget.SearchResult)new SpellTarget.SearchResult(List.of(c.source().method_5529()), c.source().method_5529().method_19538()), (SpellCast.Action)SpellCast.Action.TRIGGER, (float)1.0f);
                        }
                    });
                }
            }
        });
        Spells.registerDeliveries();
        LOGGER.info("Hello Fabric world!");
    }

    public static void spawnParticlesSlash(class_1309 entity, class_3218 world, float yaw, float pitch, float range) {
        int iii = -200;
        for (int i = 0; i < 5; ++i) {
            int ii = 0;
            while (ii < 80) {
                int finalIii = ++iii;
                int finalIi = ii++;
                ((WorldScheduler)world).schedule(i + 1, () -> {
                    if (world instanceof class_3218) {
                        class_3222 player;
                        class_3218 serverWorld = world;
                        double x = 0.0;
                        double x2 = 0.0;
                        double z = 0.0;
                        x = ((double)(range * entity.method_17681()) + (double)(range * entity.method_17681()) * Math.sin(20.0 * ((double)finalIii / 126.96))) * Math.cos((double)finalIii / 126.96);
                        x2 = -((1.2 * (double)range * (double)entity.method_17681() + (double)(range * entity.method_17681()) * Math.sin(20.0 * ((double)finalIii / 126.96))) * Math.cos((double)finalIii / 126.96));
                        z = (double)pitch * (1.2 * (double)range * (double)entity.method_17681() + (double)(0.0f * entity.method_17681()) * Math.sin(20.0 * ((double)finalIii / 126.96))) * Math.sin((double)finalIii / 126.96);
                        float f7 = entity.method_36454() + -90.0f;
                        float f = yaw - 90.0f;
                        class_243 vec3d2 = BasicSkillSets.rotate(x2, 0.0, z, Math.toRadians(-f7), Math.toRadians(f), 0.0);
                        vec3d2 = VectorHelper.rotateTowards((class_243)vec3d2, (class_243)new class_243(0.0, -1.0, 0.0), (double)entity.method_36455());
                        class_243 vec3d4 = vec3d2.method_1031(entity.method_33571().method_10216(), entity.method_23320(), entity.method_33571().method_10215());
                        double y = entity.method_23318() + (double)(entity.method_17682() / 2.0f);
                        for (class_3222 player2 : PlayerLookup.tracking((class_1297)entity)) {
                            if (2.0f * range - (float)player2.method_59922().method_43048(2 * Math.max(0, (int)((double)range - -x2)) + 1) != 2.0f * range) continue;
                            if (finalIi % 4 == 1) {
                                serverWorld.method_14166(player2, (class_2394)SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).particleType(), true, vec3d4.method_10216(), vec3d4.method_10214(), vec3d4.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                                serverWorld.method_14166(player2, (class_2394)class_2398.field_29644, true, vec3d4.method_10216(), vec3d4.method_10214(), vec3d4.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            serverWorld.method_14166(player2, (class_2394)SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).particleType(), true, vec3d4.method_10216(), vec3d4.method_10214(), vec3d4.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        if (entity instanceof class_3222 && 2.0f * range - (float)(player = (class_3222)entity).method_59922().method_43048(2 * Math.max(0, (int)((double)range - -x2)) + 1) == 2.0f * range) {
                            if (finalIi % 4 == 1) {
                                serverWorld.method_14166(player, (class_2394)SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).particleType(), true, vec3d4.method_10216(), vec3d4.method_10214(), vec3d4.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                                serverWorld.method_14166(player, (class_2394)class_2398.field_29644, true, vec3d4.method_10216(), vec3d4.method_10214(), vec3d4.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            serverWorld.method_14166(player, (class_2394)SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).particleType(), true, vec3d4.method_10216(), vec3d4.method_10214(), vec3d4.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                });
            }
        }
    }

    public static class_243 rotate(double x, double y, double z, double pitch, double roll, double yaw) {
        double cosa = Math.cos(yaw);
        double sina = Math.sin(yaw);
        double cosb = Math.cos(pitch);
        double sinb = Math.sin(pitch);
        double cosc = Math.cos(roll);
        double sinc = Math.sin(roll);
        double Axx = cosa * cosb;
        double Axy = cosa * sinb * sinc - sina * cosc;
        double Axz = cosa * sinb * cosc + sina * sinc;
        double Ayx = sina * cosb;
        double Ayy = sina * sinb * sinc + cosa * cosc;
        double Ayz = sina * sinb * cosc - cosa * sinc;
        double Azx = -sinb;
        double Azy = cosb * sinc;
        double Azz = cosb * cosc;
        class_243 vec3 = new class_243(Axx * x + Axy * y + Axz * z, Ayx * x + Ayy * y + Ayz * z, Azx * x + Azy * y + Azz * z);
        return vec3;
    }

    static {
        skills = new LinkedHashMap();
        skills.put("bettercombat:claymore", List.of(class_2960.method_60655((String)MOD_ID, (String)"vaulting_slam")));
        skills.put("bettercombat:hammer", List.of(class_2960.method_60655((String)MOD_ID, (String)"slam")));
        skills.put("bettercombat:halberd", List.of(class_2960.method_60655((String)MOD_ID, (String)"prepare"), class_2960.method_60655((String)MOD_ID, (String)"charge")));
        skills.put("bettercombat:scythe", List.of(class_2960.method_60655((String)MOD_ID, (String)"devastating_cut")));
        skills.put("bettercombat:glaive", List.of(class_2960.method_60655((String)MOD_ID, (String)"prepare")));
        skills.put("bettercombat:double_axe", List.of(class_2960.method_60655((String)MOD_ID, (String)"skullcrusher")));
        skills.put("bettercombat:spear", List.of(class_2960.method_60655((String)MOD_ID, (String)"spear_throw")));
        skills.put("bettercombat:lance", List.of(class_2960.method_60655((String)MOD_ID, (String)"charge")));
        skills.put("bettercombat:anchor", List.of(class_2960.method_60655((String)MOD_ID, (String)"skullcrusher")));
        skills.put("bettercombat:battlestaff", List.of(class_2960.method_60655((String)MOD_ID, (String)"vaulting_slam")));
        skills.put("bettercombat:claw", List.of(class_2960.method_60655((String)MOD_ID, (String)"whirling_assault")));
        skills.put("bettercombat:fist", List.of(class_2960.method_60655((String)MOD_ID, (String)"whirling_assault")));
        skills.put("bettercombat:trident", List.of(class_2960.method_60655((String)MOD_ID, (String)"prepare"), class_2960.method_60655((String)MOD_ID, (String)"charge")));
        skills.put("bettercombat:katana", List.of(class_2960.method_60655((String)MOD_ID, (String)"devastating_cut")));
        skills.put("bettercombat:rapier", List.of(class_2960.method_60655((String)MOD_ID, (String)"flourish")));
        skills.put("bettercombat:sickle", List.of(class_2960.method_60655((String)MOD_ID, (String)"devastating_cut")));
        skills.put("bettercombat:soul_knife", List.of(class_2960.method_60655((String)MOD_ID, (String)"knife_throw")));
        skills.put("bettercombat:dagger", List.of(class_2960.method_60655((String)MOD_ID, (String)"knife_throw")));
        skills.put("bettercombat:mace", List.of(class_2960.method_60655((String)MOD_ID, (String)"slam")));
        skills.put("bettercombat:axe", List.of(class_2960.method_60655((String)MOD_ID, (String)"skullcrusher")));
        skills.put("bettercombat:coral_blade", List.of(class_2960.method_60655((String)MOD_ID, (String)"knife_throw")));
        skills.put("bettercombat:twin_blade", List.of(class_2960.method_60655((String)MOD_ID, (String)"flourish")));
        skills.put("bettercombat:cutlass", List.of(class_2960.method_60655((String)MOD_ID, (String)"flourish")));
        skills.put("bettercombat:sword", List.of(class_2960.method_60655((String)MOD_ID, (String)"flourish")));
        map = HashMultimap.create();
        map.put((Object)class_5134.field_23723, (Object)new class_1322(class_2960.method_60655((String)MOD_ID, (String)"attack_speed_penalty_airborne"), (double)0.4f, class_1322.class_1323.field_6331));
    }
}

