/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamMessage;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection;
import dev.ftb.mods.ftbteams.data.AbstractTeamBase;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import dev.ftb.mods.ftbteams.data.TeamMessageImpl;
import dev.ftb.mods.ftbteams.data.TeamPropertyCollectionImpl;
import dev.ftb.mods.ftbteams.net.SendMessageResponseMessage;
import dev.ftb.mods.ftbteams.net.UpdatePropertiesResponseMessage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTeam
extends AbstractTeamBase {
    protected final TeamManagerImpl manager;
    private boolean shouldSave;

    public AbstractTeam(TeamManagerImpl manager, UUID id) {
        super(id);
        this.manager = manager;
        this.properties.collectProperties();
    }

    @Override
    public void markDirty() {
        this.shouldSave = true;
        this.manager.nameMap = null;
    }

    public List<class_3222> getOnlineRanked(TeamRank rank) {
        ArrayList<class_3222> list = new ArrayList<class_3222>();
        for (UUID id : this.getPlayersByRank(rank).keySet()) {
            class_3222 player = FTBTUtils.getPlayerByUUID(this.manager.getServer(), id);
            if (player == null) continue;
            list.add(player);
        }
        return list;
    }

    public List<class_3222> getOnlineMembers() {
        return this.getOnlineRanked(TeamRank.MEMBER);
    }

    void onCreated(@Nullable class_3222 player, @NotNull UUID playerId) {
        if (player != null) {
            ((Consumer)TeamEvent.CREATED.invoker()).accept(new TeamCreatedEvent(this, player, playerId));
        }
        this.markDirty();
        this.manager.markDirty();
        this.manager.saveNow();
    }

    void updateCommands(class_3222 player) {
        player.method_5682().method_3760().method_14576(player);
    }

    void onPlayerChangeTeam(@Nullable Team prev, UUID player, @Nullable class_3222 p, boolean deleted) {
        ((Consumer)TeamEvent.PLAYER_CHANGED.invoker()).accept(new PlayerChangedTeamEvent(this, prev, player, p));
        if (prev instanceof PartyTeam && this instanceof PlayerTeam) {
            ((Consumer)TeamEvent.PLAYER_LEFT_PARTY.invoker()).accept(new PlayerLeftPartyTeamEvent(prev, this, player, p, deleted));
        } else if (prev instanceof PlayerTeam && p != null) {
            ((Consumer)TeamEvent.PLAYER_JOINED_PARTY.invoker()).accept(new PlayerJoinedPartyTeamEvent(this, prev, p));
        }
        if (deleted && prev != null) {
            ((Consumer)TeamEvent.DELETED.invoker()).accept(new TeamEvent(prev));
        }
        if (p != null) {
            this.updateCommands(p);
        }
    }

    public SNBTCompoundTag serializeNBT(class_7225.class_7874 provider) {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.method_10582("id", this.getId().toString());
        tag.method_10582("type", this.getType().method_15434());
        this.serializeExtraNBT((class_2487)tag);
        SNBTCompoundTag ranksNBT = new SNBTCompoundTag();
        for (Map.Entry entry : this.ranks.entrySet()) {
            ranksNBT.method_10582(((UUID)entry.getKey()).toString(), ((TeamRank)((Object)entry.getValue())).method_15434());
        }
        tag.method_10566("ranks", (class_2520)ranksNBT);
        tag.method_10566("properties", (class_2520)this.properties.write((class_2487)new SNBTCompoundTag()));
        class_2499 messageHistoryTag = new class_2499();
        for (TeamMessage msg : this.getMessageHistory()) {
            messageHistoryTag.add((Object)TeamMessageImpl.toNBT(msg, provider));
        }
        tag.method_10566("message_history", (class_2520)messageHistoryTag);
        ((Consumer)TeamEvent.SAVED.invoker()).accept(new TeamEvent(this));
        tag.method_10566("extra", (class_2520)this.extraData);
        return tag;
    }

    protected void serializeExtraNBT(class_2487 tag) {
    }

    public void deserializeNBT(class_2487 tag, class_7225.class_7874 provider) {
        this.ranks.clear();
        class_2487 ranksNBT = tag.method_10562("ranks");
        for (String s : ranksNBT.method_10541()) {
            this.ranks.put(UUID.fromString(s), (TeamRank)((Object)TeamRank.NAME_MAP.get(ranksNBT.method_10558(s))));
        }
        this.properties.read(tag.method_10562("properties"));
        this.extraData = tag.method_10562("extra");
        this.messageHistory.clear();
        class_2499 messageHistoryTag = tag.method_10554("message_history", 10);
        for (int i = 0; i < messageHistoryTag.size(); ++i) {
            this.addMessage(TeamMessageImpl.fromNBT(messageHistoryTag.method_10602(i), provider));
        }
        ((Consumer)TeamEvent.LOADED.invoker()).accept(new TeamEvent(this));
    }

    public <T> int settings(class_2168 source, TeamProperty<T> key, String value) {
        class_5250 keyc = class_2561.method_43471((String)key.getTranslationKey("ftbteamsconfig")).method_27692(class_124.field_1054);
        if (value.isEmpty()) {
            class_5250 valuec = class_2561.method_43470((String)key.toString(this.getProperty(key))).method_27692(class_124.field_1075);
            source.method_9226(() -> AbstractTeam.lambda$settings$0(keyc, (class_2561)valuec), true);
        } else {
            Optional<T> optional = key.fromString(value);
            if (optional.isPresent()) {
                TeamPropertyCollectionImpl old = this.properties.copy();
                this.setProperty(key, optional.get());
                class_5250 valuec = class_2561.method_43470((String)value).method_27692(class_124.field_1075);
                source.method_9226(() -> AbstractTeam.lambda$settings$1(keyc, (class_2561)valuec), true);
                ((Consumer)TeamEvent.PROPERTIES_CHANGED.invoker()).accept(new TeamPropertiesChangedEvent(this, old));
                if (ClientTeam.isSyncableProperty(key)) {
                    NetworkHelper.sendToAll((MinecraftServer)source.method_9211(), (class_8710)UpdatePropertiesResponseMessage.oneProperty(this.getId(), key, optional.get()));
                }
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)"Failed to parse value!"));
                return 0;
            }
        }
        return 1;
    }

    public int declineInvitation(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (this.getRankForPlayer(player.method_5667()) == TeamRank.INVITED) {
            this.ranks.put(player.method_5667(), TeamRank.ALLY);
            source.method_9226(() -> class_2561.method_43471((String)"ftbteams.message.declined"), true);
            this.markDirty();
            this.manager.syncToAll(this);
            return 1;
        }
        FTBTeams.LOGGER.warn("ignore invitation decline for player {} to team {} (not invited)", (Object)player.method_5667(), (Object)this.getId());
        return 0;
    }

    @Override
    public List<class_2561> getTeamInfo() {
        ArrayList<class_2561> res = new ArrayList<class_2561>();
        res.add((class_2561)class_2561.method_43470((String)"== ").method_10852(this.getName()).method_10852((class_2561)class_2561.method_43470((String)(" [" + this.getType().method_15434() + "]")).method_27692(this.getType().getColor())).method_27693(" =="));
        res.add((class_2561)class_2561.method_43469((String)"ftbteams.info.id", (Object[])new Object[]{FTBTUtils.makeCopyableComponent(this.getId().toString()).method_27692(class_124.field_1054)}));
        res.add((class_2561)class_2561.method_43469((String)"ftbteams.info.short_id", (Object[])new Object[]{FTBTUtils.makeCopyableComponent(this.getShortName()).method_27692(class_124.field_1054)}));
        if (this.isPartyTeam()) {
            res.add((class_2561)(this.getOwner().equals(class_156.field_25140) ? class_2561.method_43469((String)"ftbteams.info.owner", (Object[])new Object[]{class_2561.method_43471((String)"ftbteams.info.owner.none").method_27692(class_124.field_1080)}) : class_2561.method_43469((String)"ftbteams.info.owner", (Object[])new Object[]{this.playerWithId(this.getOwner())})));
            res.add((class_2561)class_2561.method_43471((String)"ftbteams.info.members"));
            if (this.getMembers().isEmpty()) {
                res.add((class_2561)class_2561.method_43470((String)"- ").method_10852((class_2561)class_2561.method_43471((String)"ftbteams.info.members.none")).method_27692(class_124.field_1080));
            } else {
                for (UUID member : this.getMembers()) {
                    res.add((class_2561)class_2561.method_43470((String)"- ").method_10852(this.playerWithId(member)));
                }
            }
        }
        return res;
    }

    private class_2561 playerWithId(UUID member) {
        return this.manager.getPlayerName(member).method_27661().method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)member.toString()))));
    }

    @Override
    public UUID getOwner() {
        return class_156.field_25140;
    }

    @Override
    public void sendMessage(UUID senderId, String message) {
        this.sendMessage(senderId, TextComponentUtils.withLinks((String)message));
    }

    @Override
    public void sendMessage(UUID from, class_2561 text) {
        this.addMessage(FTBTeamsAPI.api().createMessage(from, text));
        class_5250 component = class_2561.method_43470((String)"<");
        component.method_10852(this.manager.getPlayerName(from));
        component.method_27693(" @");
        component.method_10852(this.getName());
        component.method_27693("> ");
        component.method_10852(text);
        for (class_3222 p : this.getOnlineMembers()) {
            p.method_7353((class_2561)component, false);
            NetworkManager.sendToPlayer((class_3222)p, (class_8710)new SendMessageResponseMessage(from, text));
        }
        this.markDirty();
    }

    public void updatePropertiesFrom(TeamPropertyCollection newProperties) {
        TeamPropertyCollectionImpl oldProperties = this.properties.copy();
        this.properties.updateFrom(newProperties);
        ((Consumer)TeamEvent.PROPERTIES_CHANGED.invoker()).accept(new TeamPropertiesChangedEvent(this, oldProperties));
        this.markDirty();
    }

    void saveIfNeeded(Path directory, class_7225.class_7874 provider) {
        if (this.shouldSave) {
            SNBT.write((Path)directory.resolve(this.getType().method_15434() + "/" + String.valueOf(this.getId()) + ".snbt"), (class_2487)this.serializeNBT(provider));
            this.shouldSave = false;
        }
    }

    private static /* synthetic */ class_2561 lambda$settings$1(class_5250 keyc, class_2561 valuec) {
        return class_2561.method_43470((String)"Set ").method_10852((class_2561)keyc).method_27693(" to ").method_10852(valuec);
    }

    private static /* synthetic */ class_2561 lambda$settings$0(class_5250 keyc, class_2561 valuec) {
        return keyc.method_27693(" is set to ").method_10852(valuec);
    }
}

