/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_enchanting.widget;

import com.google.common.collect.Lists;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_5684;

public class PageWidget
extends Widget
implements WidgetHolder {
    private final List<Widget> widgets = Lists.newArrayList();
    private final int width;
    private final int height;
    private final Bounds bounds;
    private boolean isActive = false;

    public PageWidget(int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        this.bounds = new Bounds(x, y, width, height);
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public void method_25394(class_332 draw, int mouseX, int mouseY, float delta) {
        if (!this.isActive) {
            return;
        }
        for (Widget widget : this.widgets) {
            widget.method_25394(draw, mouseX, mouseY, delta);
        }
    }

    public List<class_5684> getTooltip(int mouseX, int mouseY) {
        if (!this.isActive) {
            return List.of();
        }
        for (Widget widget : this.widgets) {
            if (!widget.getBounds().contains(mouseX, mouseY)) continue;
            return widget.getTooltip(mouseX, mouseY);
        }
        return List.of();
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.isActive) {
            return false;
        }
        for (Widget widget : this.widgets) {
            if (!widget.getBounds().contains(mouseX, mouseY) || !widget.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public <T extends Widget> T add(T widget) {
        this.widgets.add(widget);
        return widget;
    }
}

