/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;

public final class TickScheduler {
    private static final byte SERVER = 0;
    private static final byte CLIENT = 1;
    private static final byte BOTH = 2;
    private static final Map<class_1937, PriorityQueue<ScheduledTask>> SERVER_TASKS = new ConcurrentHashMap<class_1937, PriorityQueue<ScheduledTask>>(4);
    private static final Map<class_1937, PriorityQueue<ScheduledTask>> CLIENT_TASKS = new ConcurrentHashMap<class_1937, PriorityQueue<ScheduledTask>>(2);
    private static final Map<class_1937, PriorityQueue<ScheduledTask>> COMMON_TASKS = new ConcurrentHashMap<class_1937, PriorityQueue<ScheduledTask>>(4);
    private static final Map<class_1937, Long> LEVEL_TICK_COUNTER = new ConcurrentHashMap<class_1937, Long>();
    private static final List<class_1937> LEVELS_TO_CLEAN = new ArrayList<class_1937>();

    public static void schedule(class_1937 level, Runnable runnable, int delay, byte type) {
        if (level == null || runnable == null || delay < 0) {
            return;
        }
        ScheduledTask task = new ScheduledTask(TickScheduler.getOrCreateTickCounter(level) + (long)delay, runnable);
        switch (type) {
            case 0: {
                if (level.method_8608()) break;
                TickScheduler.getOrCreateQueue(SERVER_TASKS, level).add(task);
                break;
            }
            case 1: {
                if (!level.method_8608()) break;
                TickScheduler.getOrCreateQueue(CLIENT_TASKS, level).add(task);
                break;
            }
            case 2: {
                TickScheduler.getOrCreateQueue(COMMON_TASKS, level).add(task);
                break;
            }
        }
    }

    public static void scheduleServer(class_1937 level, Runnable runnable, int delay) {
        TickScheduler.schedule(level, runnable, delay, (byte)0);
    }

    public static void scheduleClient(class_1937 level, Runnable runnable, int delay) {
        TickScheduler.schedule(level, runnable, delay, (byte)1);
    }

    public static void scheduleBoth(class_1937 level, Runnable runnable, int delay) {
        TickScheduler.schedule(level, runnable, delay, (byte)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markForClean(class_1937 level) {
        if (level != null) {
            List<class_1937> list = LEVELS_TO_CLEAN;
            synchronized (list) {
                LEVELS_TO_CLEAN.add(level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clean() {
        List<class_1937> list = LEVELS_TO_CLEAN;
        synchronized (list) {
            if (!LEVELS_TO_CLEAN.isEmpty()) {
                for (class_1937 level : LEVELS_TO_CLEAN) {
                    SERVER_TASKS.remove(level);
                    CLIENT_TASKS.remove(level);
                    COMMON_TASKS.remove(level);
                    LEVEL_TICK_COUNTER.remove(level);
                }
                LEVELS_TO_CLEAN.clear();
            }
        }
    }

    public static boolean hasTasks() {
        return !SERVER_TASKS.isEmpty() || !CLIENT_TASKS.isEmpty() || !COMMON_TASKS.isEmpty();
    }

    private static PriorityQueue<ScheduledTask> getOrCreateQueue(Map<class_1937, PriorityQueue<ScheduledTask>> map, class_1937 level) {
        return map.computeIfAbsent(level, lvl -> new PriorityQueue());
    }

    private static long getOrCreateTickCounter(class_1937 level) {
        return LEVEL_TICK_COUNTER.computeIfAbsent(level, lvl -> 0L);
    }

    public static void incrementTick(class_1937 level) {
        LEVEL_TICK_COUNTER.put(level, TickScheduler.getOrCreateTickCounter(level) + 1L);
    }

    public static void processServerTasks(class_1937 level) {
        PriorityQueue<ScheduledTask> queue = SERVER_TASKS.get(level);
        if (queue == null || queue.isEmpty()) {
            return;
        }
        while (!queue.isEmpty()) {
            ScheduledTask top = queue.peek();
            if (top.execAt > TickScheduler.getOrCreateTickCounter(level)) break;
            queue.poll();
            top.execute();
        }
    }

    public static void processClientTasks(class_1937 level) {
        PriorityQueue<ScheduledTask> queue = CLIENT_TASKS.get(level);
        if (queue == null || queue.isEmpty()) {
            return;
        }
        while (!queue.isEmpty()) {
            ScheduledTask top = queue.peek();
            if (top.execAt > TickScheduler.getOrCreateTickCounter(level)) break;
            queue.poll();
            top.execute();
        }
    }

    public static void processCommonTasks(class_1937 level) {
        PriorityQueue<ScheduledTask> queue = COMMON_TASKS.get(level);
        if (queue == null || queue.isEmpty()) {
            return;
        }
        while (!queue.isEmpty()) {
            ScheduledTask top = queue.peek();
            if (top.execAt > TickScheduler.getOrCreateTickCounter(level)) break;
            queue.poll();
            top.execute();
        }
    }

    public static final class ScheduledTask
    implements Comparable<ScheduledTask> {
        private final long execAt;
        private final Runnable runnable;

        private ScheduledTask(long executeAtTick, Runnable runnable) {
            this.execAt = executeAtTick;
            this.runnable = runnable;
        }

        @Override
        public int compareTo(ScheduledTask other) {
            return Long.compare(this.execAt, other.execAt);
        }

        public void execute() {
            this.runnable.run();
        }
    }
}

