/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.Difficulty;
import net.dungeon_difficulty.logic.DifficultyTypes;
import net.dungeon_difficulty.logic.ScalingGoal;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class PatternMatching {
    public static final String ANY = "*";
    public static final String TAG_PREFIX = "#";
    public static final String REGEX_PREFIX = "~";
    public static final String NEGATE_PREFIX = "!";

    private static boolean isInsideStructure(class_3218 world, class_2338 pos, class_3449 structureStart) {
        if (structureStart.method_16657()) {
            return structureStart.method_14969().method_14662((class_2382)pos);
        }
        return false;
    }

    public static ItemScaleResult getModifiersForItem(LocationData locationData, ItemData itemData, class_3218 world, @Nullable Config.Rewards scaling) {
        DifficultySearchResult result = PatternMatching.getDifficultyResult(locationData, itemData.lootTableId(), ScalingGoal.LOOT, world);
        int level = 0;
        if (result != null && result.difficulty() != null && result.difficulty().allowsLootScaling()) {
            level = result.difficulty.rewardLevel();
        }
        return PatternMatching.getItemScaleResult(itemData, scaling, level);
    }

    public static ItemScaleResult getItemScaleResult(ItemData itemData, @Nullable Config.Rewards scaling, int level) {
        ArrayList<Config.AttributeModifier> attributeModifiers = new ArrayList<Config.AttributeModifier>();
        if (scaling != null && level > 0) {
            List<Config.ItemModifier> itemModifiers = null;
            switch (itemData.kind.ordinal()) {
                case 0: {
                    itemModifiers = scaling.armor;
                    break;
                }
                case 1: {
                    itemModifiers = scaling.weapons;
                }
            }
            if (itemModifiers != null) {
                for (Config.ItemModifier entry : itemModifiers) {
                    if (!itemData.matches(entry.item_matches)) continue;
                    attributeModifiers.addAll(entry.attributes);
                }
            }
        }
        return new ItemScaleResult(attributeModifiers, level);
    }

    public static EntityScaleResult getAttributeModifiersForEntity(LocationData locationData, EntityData entityData, class_3218 world) {
        ArrayList<Config.AttributeModifier> attributeModifiers = new ArrayList<Config.AttributeModifier>();
        DifficultySearchResult result = PatternMatching.getDifficultyResult(locationData, entityData.entityId(), ScalingGoal.ENTITY, world);
        int level = 0;
        float experienceMultiplier = 0.0f;
        String name = EntityScaleResult.EMPTY.name();
        if (result != null && result.difficulty != null) {
            Difficulty difficulty = result.difficulty;
            level = difficulty.entityLevel();
            if (level != 0) {
                for (Config.EntityModifier modifier : PatternMatching.getModifiersForEntity(difficulty.type().entities, entityData)) {
                    attributeModifiers.addAll(modifier.attributes);
                    experienceMultiplier += modifier.experience_multiplier;
                }
            }
            name = difficulty.type().name;
        }
        return new EntityScaleResult("location", attributeModifiers, level, experienceMultiplier);
    }

    public static SpawnerScaleResult getModifiersForSpawner(LocationData locationData, EntityData entityData, class_3218 world) {
        ArrayList<Config.SpawnerModifier> spawnerModifiers = new ArrayList<Config.SpawnerModifier>();
        Difficulty difficulty = PatternMatching.getDifficulty(locationData, world);
        int level = 0;
        if (difficulty != null && (level = difficulty.entityLevel()) != 0) {
            for (Config.EntityModifier modifier : PatternMatching.getModifiersForEntity(difficulty.type().entities, entityData)) {
                if (modifier.spawners == null) continue;
                spawnerModifiers.add(modifier.spawners);
            }
        }
        return new SpawnerScaleResult(spawnerModifiers, level);
    }

    public static List<Config.EntityModifier> getModifiersForEntity(List<Config.EntityModifier> definitions, EntityData entityData) {
        ArrayList<Config.EntityModifier> entityModifiers = new ArrayList<Config.EntityModifier>();
        for (Config.EntityModifier entityModifier : definitions) {
            if (!entityData.matches(entityModifier.entity_matches)) continue;
            entityModifiers.add(entityModifier);
        }
        return entityModifiers;
    }

    @Nullable
    public static Difficulty getDifficulty(LocationData locationData, class_3218 world) {
        return PatternMatching.getDifficulty(locationData, null, world);
    }

    @Nullable
    public static Difficulty getDifficulty(LocationData locationData, @Nullable class_2960 sourceId, class_3218 world) {
        DifficultySearchResult result = PatternMatching.getDifficultyResult(locationData, sourceId, ScalingGoal.ENTITY, world);
        if (result != null) {
            return result.difficulty();
        }
        return null;
    }

    @Nullable
    public static DifficultySearchResult getDifficultyResult(LocationData locationData, @Nullable class_2960 sourceId, ScalingGoal scalingGoal, class_3218 world) {
        for (Config.Dimension dimension : ((Config)DungeonDifficulty.config.value).dimensions) {
            DifficultySearchResult entityDifficulty;
            DifficultySearchResult result;
            if (!locationData.matches(dimension.world_matches)) continue;
            DifficultySearchResult zoneResult = null;
            if (dimension.zones != null) {
                LocationData.Match match;
                for (Config.Zone zone : dimension.zones) {
                    Difficulty zoneDifficulty;
                    match = locationData.matches(zone.zone_matches, world);
                    if (!match.matches() || (zoneDifficulty = PatternMatching.findDifficulty(zone.difficulty)) == null || !zoneDifficulty.isValid()) continue;
                    zoneResult = new DifficultySearchResult(zoneDifficulty, locationData, match);
                    break;
                }
                if (zoneResult != null) {
                    for (Config.Zone.TypeOverride typeOverride : dimension.zone_specifiers) {
                        match = locationData.matches(typeOverride.zone_matches, world);
                        if (!match.matches()) continue;
                        zoneResult = zoneResult.withType(typeOverride.difficulty_name);
                        break;
                    }
                }
            }
            if ((result = PatternMatching.chooseHigherDifficulty(zoneResult, entityDifficulty = PatternMatching.matchEntityDifficulty(locationData, sourceId, scalingGoal, dimension.entities))) != null) {
                return result;
            }
            Difficulty dimensionDifficulty = PatternMatching.findDifficulty(dimension.difficulty);
            if (dimensionDifficulty == null || !dimensionDifficulty.isValid()) continue;
            return new DifficultySearchResult(dimensionDifficulty, locationData, null);
        }
        return null;
    }

    private static DifficultySearchResult chooseHigherDifficulty(@Nullable DifficultySearchResult a, @Nullable DifficultySearchResult b) {
        int bLevel;
        if (a == null && b == null) {
            return null;
        }
        int aLevel = a != null ? a.difficulty().level() : -100;
        int n = bLevel = b != null ? b.difficulty().level() : -100;
        if (aLevel >= bLevel) {
            return a;
        }
        return b;
    }

    @Nullable
    private static DifficultySearchResult matchEntityDifficulty(LocationData locationData, @Nullable class_2960 sourceId, ScalingGoal scalingGoal, List<Config.EntityMatcher> matchers) {
        if (sourceId != null) {
            for (Config.EntityMatcher entityMatcher : matchers) {
                switch (scalingGoal) {
                    case ENTITY: {
                        Optional entityTypeEntry;
                        if (entityMatcher.entity_type == null || (entityTypeEntry = class_7923.field_41177.method_55841(sourceId)).isEmpty() || !PatternMatching.universalMatch((class_6880)entityTypeEntry.get(), class_7924.field_41266, entityMatcher.entity_type)) break;
                        Difficulty difficulty = PatternMatching.findDifficulty(entityMatcher.difficulty);
                        return new DifficultySearchResult(difficulty, locationData, null);
                    }
                    case LOOT: {
                        if (entityMatcher.loot_table == null || !PatternMatching.regexMatches(sourceId.toString(), entityMatcher.loot_table)) break;
                        Difficulty difficulty = PatternMatching.findDifficulty(entityMatcher.difficulty);
                        return new DifficultySearchResult(difficulty, locationData, null);
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private static Difficulty findDifficulty(Config.DifficultyReference reference) {
        if (reference == null) {
            return null;
        }
        String name = reference.name;
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (Config.DifficultyType entry : DifficultyTypes.resolved) {
            if (!name.equals(entry.name)) continue;
            int rewardLevel = reference.reward_level != null ? reference.reward_level : reference.level;
            int entityLevel = reference.entity_level != null ? reference.entity_level : reference.level;
            return new Difficulty(entry, reference.level, entityLevel, rewardLevel);
        }
        return null;
    }

    public static <T> boolean universalMatch(@Nullable class_6880<T> entry, class_5321<class_2378<T>> registryKey, @Nullable String pattern) {
        if (pattern == null || pattern.isEmpty() || pattern.equals(ANY)) {
            return true;
        }
        if (entry == null) {
            return false;
        }
        if (pattern.startsWith(NEGATE_PREFIX)) {
            return !PatternMatching.entryMatches(entry, registryKey, pattern.substring(1));
        }
        return PatternMatching.entryMatches(entry, registryKey, pattern);
    }

    public static <T> boolean universalMatch(class_2960 id, @Nullable String pattern) {
        if (pattern == null || pattern.isEmpty() || pattern.equals(ANY)) {
            return true;
        }
        if (pattern.startsWith(NEGATE_PREFIX)) {
            return !PatternMatching.idMatches(id, pattern.substring(1));
        }
        return PatternMatching.idMatches(id, pattern);
    }

    public static <T> boolean entryMatches(class_6880<T> entry, class_5321<class_2378<T>> registryKey, String pattern) {
        if (pattern.startsWith(TAG_PREFIX)) {
            class_6862 tag = class_6862.method_40092(registryKey, (class_2960)class_2960.method_60654((String)pattern.substring(1)));
            return entry.method_40220(tag);
        }
        return PatternMatching.idMatches(((class_5321)entry.method_40230().get()).method_29177(), pattern);
    }

    public static boolean idMatches(class_2960 id, String pattern) {
        String idString = id.toString();
        if (pattern.startsWith(REGEX_PREFIX)) {
            return PatternMatching.regexMatches(idString, pattern.substring(1));
        }
        return idString.equals(pattern);
    }

    public static boolean regexMatches(String subject, String regex) {
        if (subject == null) {
            return false;
        }
        if (regex == null || regex.isEmpty()) {
            return true;
        }
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(subject);
        return matcher.find();
    }

    public record ItemData(ItemKind kind, class_2960 lootTableId, class_6880<class_1792> itemEntry, String rarity) {
        public boolean matches(Config.ItemModifier.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean result = PatternMatching.universalMatch(this.itemEntry, class_7924.field_41197, filters.id) && PatternMatching.regexMatches(this.lootTableId.toString(), filters.loot_table_regex) && PatternMatching.regexMatches(this.rarity, filters.rarity_regex);
            return result;
        }
    }

    public record LocationData(class_2960 dimensionId, class_2338 position, BiomeData biome) {
        public static LocationData create(class_3218 world, class_2338 position) {
            class_2960 dimensionId = world.method_27983().method_29177();
            BiomeData biome = null;
            if (position != null) {
                biome = new BiomeData((class_6880<class_1959>)world.method_23753(position));
            }
            return new LocationData(dimensionId, position, biome);
        }

        public boolean matches(Config.Dimension.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean result = PatternMatching.universalMatch(this.dimensionId, filters.dimension);
            return result;
        }

        public Match matches(Config.Zone.Filters filters, @Nullable class_3218 world) {
            if (filters == null || this.biome == null) {
                return Match.trueMatch();
            }
            boolean result = false;
            if (world == null) {
                return Match.falseMatch();
            }
            class_5455.class_6890 registries = world.method_8503().method_30611();
            Scope matchScope = Scope.DIMENSION;
            class_6880<class_1959> matchingBiome = null;
            if (filters.biome == null || filters.biome.isEmpty()) {
                result = true;
            } else if (PatternMatching.universalMatch(this.biome.biomeEntry, class_7924.field_41236, filters.biome)) {
                result = true;
                matchingBiome = this.biome.biomeEntry;
                matchScope = Scope.BIOME;
            }
            class_6880.class_6883 matchingStructure = null;
            if (result && filters.structure != null && !filters.structure.isEmpty()) {
                result = false;
                class_2378 registry = registries.method_30530(class_7924.field_41246);
                List structureStartsUnfiltered = world.method_27056().method_41035(new class_1923(this.position), s -> true);
                for (class_3449 structureStart : structureStartsUnfiltered) {
                    class_6880.class_6883 entry = registry.method_40265(registry.method_10206((Object)structureStart.method_16656())).orElse(null);
                    if (entry == null || !PatternMatching.universalMatch(entry, class_7924.field_41246, filters.structure) || !PatternMatching.isInsideStructure(world, this.position, structureStart)) continue;
                    matchingStructure = entry;
                    matchScope = Scope.STRUCTURE;
                    result = true;
                    break;
                }
            }
            return new Match(result, matchScope, matchingBiome, (class_6880<class_3195>)matchingStructure);
        }

        public record Match(boolean matches, Scope scope, @Nullable class_6880<class_1959> matchingBiome, @Nullable class_6880<class_3195> matchingStructure) {
            public static Match trueMatch() {
                return new Match(true, Scope.DIMENSION, null, null);
            }

            public static Match falseMatch() {
                return new Match(false, Scope.DIMENSION, null, null);
            }

            @Nullable
            public class_2960 id() {
                if (this.matchingBiome != null) {
                    return ((class_5321)this.matchingBiome.method_40230().get()).method_29177();
                }
                if (this.matchingStructure != null) {
                    return ((class_5321)this.matchingStructure.method_40230().get()).method_29177();
                }
                return null;
            }
        }

        public static enum Scope {
            DIMENSION,
            BIOME,
            STRUCTURE;

        }
    }

    public record DifficultySearchResult(Difficulty difficulty, LocationData locationData, LocationData.Match match) {
        @Nullable
        public class_2960 matchId() {
            return this.match != null ? this.match.id() : null;
        }

        public DifficultySearchResult withType(String difficultyType) {
            Config.DifficultyType newType = DifficultyTypes.resolved.stream().filter(t -> t.name.equals(difficultyType)).findFirst().orElse(null);
            if (newType != null) {
                return new DifficultySearchResult(this.difficulty.withType(newType), this.locationData, this.match);
            }
            return this;
        }
    }

    public record ItemScaleResult(List<Config.AttributeModifier> modifiers, int level) {
    }

    public static enum ItemKind {
        ARMOR,
        WEAPONS;

    }

    public record EntityData(@Nullable class_6880<class_1299<?>> type, boolean isHostile) {
        private static final class_2960 UNKNOWN = class_2960.method_60654((String)"unknown");

        public static EntityData create(class_1309 entity) {
            class_6880 type = class_7923.field_41177.method_47983((Object)entity.method_5864());
            boolean isHostile = entity instanceof class_1569;
            return new EntityData(type, isHostile);
        }

        public class_2960 entityId() {
            return this.type != null ? ((class_5321)this.type.method_40230().get()).method_29177() : UNKNOWN;
        }

        public boolean matches(Config.EntityModifier.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean matchesAttitude = true;
            if (filters.attitude != null) {
                switch (filters.attitude) {
                    case FRIENDLY: {
                        matchesAttitude = !this.isHostile;
                        break;
                    }
                    case HOSTILE: {
                        matchesAttitude = this.isHostile;
                        break;
                    }
                    case ANY: {
                        matchesAttitude = true;
                    }
                }
            }
            boolean result = matchesAttitude && PatternMatching.universalMatch(this.type, class_7924.field_41266, filters.type);
            return result;
        }
    }

    public record EntityScaleResult(String name, List<Config.AttributeModifier> modifiers, int level, float experienceMultiplier) {
        public static final EntityScaleResult EMPTY = new EntityScaleResult("none", List.of(), 0, 0.0f);
    }

    public record SpawnerScaleResult(List<Config.SpawnerModifier> modifiers, int level) {
    }

    public record BiomeData(class_6880<class_1959> biomeEntry) {
    }
}

