/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.world.inventory;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.RenameAndRepairCost;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.util.ComponentDecomposer;
import fuzs.easyanvils.util.FormattedStringDecomposer;
import fuzs.easyanvils.world.inventory.state.AnvilMenuState;
import fuzs.easyanvils.world.inventory.state.BuiltInAnvilMenu;
import fuzs.easyanvils.world.inventory.state.VanillaAnvilMenu;
import fuzs.easyanvils.world.level.block.entity.AnvilBlockEntity;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class ModAnvilMenu
extends class_1706 {
    private final class_1263 container;
    private final AnvilMenuState builtInAnvilState;
    private final AnvilMenuState vanillaAnvilState;

    public ModAnvilMenu(int id, class_1661 inventory) {
        super(id, inventory);
        this.container = new class_1277(new class_1799[0]);
        this.builtInAnvilState = new BuiltInAnvilMenu(inventory, class_3914.field_17304);
        this.vanillaAnvilState = new VanillaAnvilMenu(inventory, class_3914.field_17304);
        this.method_24928();
    }

    public ModAnvilMenu(int id, class_1661 inventory, AnvilBlockEntity blockEntity, class_3914 containerLevelAccess) {
        super(id, inventory, containerLevelAccess);
        this.container = blockEntity;
        this.builtInAnvilState = new BuiltInAnvilMenu(inventory, containerLevelAccess);
        this.vanillaAnvilState = new VanillaAnvilMenu(inventory, containerLevelAccess);
        this.initializeSlots(blockEntity);
        this.method_24928();
    }

    private void initializeSlots(AnvilBlockEntity blockEntity) {
        ((class_1277)this.field_22480).field_5828 = blockEntity.method_11282();
        ((class_1277)this.field_22480).method_5489($ -> blockEntity.method_5431());
        this.field_22479.field_7866 = blockEntity.getResult();
    }

    public class_3917<?> method_17358() {
        return (class_3917)ModRegistry.ANVIL_MENU_TYPE.comp_349();
    }

    public boolean method_7597(class_1657 player) {
        return this.container.method_5443(player);
    }

    protected boolean method_24927(class_1657 player, boolean hasStack) {
        return (player.method_31549().field_7477 || player.field_7520 >= this.method_17369()) && this.method_17369() >= 0;
    }

    public void method_24928() {
        if (this.builtInAnvilState == null || this.vanillaAnvilState == null) {
            return;
        }
        class_1799 left = this.field_22480.method_5438(0);
        class_1799 right = this.field_22480.method_5438(1);
        this.builtInAnvilState.init(left, right, this.field_7774);
        this.vanillaAnvilState.init(left, right, this.field_7774);
        this.builtInAnvilState.fillResultSlots();
        this.vanillaAnvilState.fillResultSlots();
        if (!AnvilMenuState.equals(this.builtInAnvilState, this.vanillaAnvilState)) {
            super.method_24928();
        } else {
            this.createResult(left, right, this.field_7774);
        }
    }

    private void createResult(class_1799 leftInput, class_1799 rightInput, String itemName) {
        this.setCost(1);
        if (leftInput.method_7960() || !class_1890.method_57529((class_1799)leftInput)) {
            this.field_22479.method_5447(0, class_1799.field_8037);
            this.setCost(0);
        } else {
            int maxAnvilRepairCost;
            boolean hasNoLimit;
            int allOperationsCost;
            class_1799 output = leftInput.method_7972();
            class_9304.class_9305 leftEnchantments = new class_9304.class_9305(class_1890.method_57532((class_1799)output));
            int baseRepairCost = (Integer)leftInput.method_57825(class_9334.field_49639, (Object)0) + (rightInput.method_7960() ? 0 : (Integer)rightInput.method_57825(class_9334.field_49639, (Object)0));
            baseRepairCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.priorWorkPenalty.operator.applyAsInt(baseRepairCost);
            this.field_7776 = 0;
            boolean isBook = false;
            int repairOperationCost = 0;
            int enchantOperationCost = 0;
            int renameOperationCost = 0;
            if (!rightInput.method_7960()) {
                isBook = rightInput.method_57826(class_9334.field_49643);
                if (output.method_7963() && output.method_7909().method_7878(leftInput, rightInput)) {
                    int repairMaterials;
                    int l2 = (int)Math.min((double)output.method_7919(), Math.floor((double)output.method_7936() * ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithMaterialRestoredDurability));
                    if (l2 <= 0) {
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.setCost(0);
                        return;
                    }
                    for (repairMaterials = 0; l2 > 0 && repairMaterials < rightInput.method_7947(); ++repairMaterials) {
                        int j3 = output.method_7919() - l2;
                        output.method_7974(j3);
                        repairOperationCost += ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithMaterialUnitCost;
                        l2 = (int)Math.min((double)output.method_7919(), Math.floor((double)output.method_7936() * ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithMaterialRestoredDurability));
                    }
                    this.field_7776 = repairMaterials;
                } else {
                    if (!(isBook || output.method_31574(rightInput.method_7909()) && output.method_7963())) {
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.setCost(0);
                        return;
                    }
                    if (output.method_7963() && !isBook) {
                        int l = leftInput.method_7936() - leftInput.method_7919();
                        int i1 = rightInput.method_7936() - rightInput.method_7919();
                        int j1 = i1 + (int)Math.floor((double)output.method_7936() * ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithOtherItemBonusDurability);
                        int k1 = l + j1;
                        int l1 = output.method_7936() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < output.method_7919()) {
                            output.method_7974(l1);
                            repairOperationCost += ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithOtherItemCost;
                        }
                    }
                    class_9304 rightEnchantments = class_1890.method_57532((class_1799)rightInput);
                    boolean itemWithCompatibleEnchantment = false;
                    boolean itemWithIncompatibleEnchantment = false;
                    for (class_6880 rightHolder : rightEnchantments.method_57534()) {
                        int enchantmentLevel;
                        class_1887 rightEnchantment = (class_1887)rightHolder.comp_349();
                        int leftEnchantmentLevel = leftEnchantments.method_57546(rightHolder);
                        enchantmentLevel = leftEnchantmentLevel == (enchantmentLevel = rightEnchantments.method_57536(rightHolder)) ? enchantmentLevel + 1 : Math.max(enchantmentLevel, leftEnchantmentLevel);
                        boolean compatibleWithItem = rightEnchantment.method_8192(leftInput);
                        if (this.field_22482.method_31549().field_7477 || leftInput.method_31574(class_1802.field_8598)) {
                            compatibleWithItem = true;
                        }
                        for (class_6880 leftHolder : leftEnchantments.method_57545()) {
                            if (leftHolder.equals((Object)rightHolder) || class_1887.method_60033((class_6880)rightHolder, (class_6880)leftHolder)) continue;
                            compatibleWithItem = false;
                            ++enchantOperationCost;
                        }
                        if (!compatibleWithItem) {
                            if (repairOperationCost > 0) continue;
                            itemWithIncompatibleEnchantment = true;
                            continue;
                        }
                        itemWithCompatibleEnchantment = true;
                        if (enchantmentLevel > rightEnchantment.method_8183()) {
                            enchantmentLevel = rightEnchantment.method_8183();
                        }
                        int maxLevel = Math.max(leftEnchantments.method_57546(rightHolder), rightEnchantments.method_57536(rightHolder));
                        if ((maxLevel = Math.max(maxLevel, enchantmentLevel)) != enchantmentLevel) {
                            enchantmentLevel = maxLevel;
                        }
                        int rarityCostMultiplier = rightEnchantment.method_58446();
                        if (isBook && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.halvedBookCosts) {
                            rarityCostMultiplier = Math.max(1, rarityCostMultiplier / 2);
                        }
                        int oldEnchantmentLevel = leftEnchantments.method_57546(rightHolder);
                        leftEnchantments.method_57547(rightHolder, enchantmentLevel);
                        if (oldEnchantmentLevel != 0 || oldEnchantmentLevel != enchantmentLevel) {
                            enchantOperationCost += rarityCostMultiplier * enchantmentLevel;
                        }
                        if (leftInput.method_7947() <= 1 || this.field_22482.method_31549().field_7477) continue;
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.setCost(-1);
                        return;
                    }
                    if (itemWithIncompatibleEnchantment && !itemWithCompatibleEnchantment) {
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.setCost(0);
                        return;
                    }
                }
            }
            boolean hasRenamedItem = false;
            if (ComponentDecomposer.getStringLength(itemName) == 0) {
                if (leftInput.method_57826(class_9334.field_49631)) {
                    renameOperationCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.freeRenames.filter.test(leftInput) ? 0 : 1;
                    hasRenamedItem = true;
                    output.method_57381(class_9334.field_49631);
                }
            } else if (!itemName.equals(ComponentDecomposer.toFormattedString(leftInput.method_7964()))) {
                renameOperationCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.freeRenames.filter.test(leftInput) ? 0 : 1;
                hasRenamedItem = true;
                output.method_57379(class_9334.field_49631, (Object)ComponentDecomposer.toFormattedComponent(itemName));
            }
            if (isBook && !CommonAbstractions.INSTANCE.isBookEnchantable(output, rightInput)) {
                output = class_1799.field_8037;
            }
            if ((allOperationsCost = enchantOperationCost + repairOperationCost + renameOperationCost) == 0) {
                this.setCost(0);
                if (!hasRenamedItem) {
                    output = class_1799.field_8037;
                }
            } else if (enchantOperationCost == 0 && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.renameAndRepairCosts == RenameAndRepairCost.FIXED) {
                this.setCost(allOperationsCost);
            } else {
                this.setCost(baseRepairCost + allOperationsCost);
            }
            boolean bl = hasNoLimit = (maxAnvilRepairCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.tooExpensiveLimit) == -1;
            if (hasNoLimit) {
                maxAnvilRepairCost = 40;
            }
            if (this.method_17369() >= maxAnvilRepairCost) {
                if (enchantOperationCost == 0 && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.renameAndRepairCosts == RenameAndRepairCost.LIMITED) {
                    this.setCost(maxAnvilRepairCost - 1);
                } else if (!hasNoLimit && !this.field_22482.method_31549().field_7477) {
                    output = class_1799.field_8037;
                }
            }
            if (!output.method_7960()) {
                int outputRepairCost = (Integer)output.method_57825(class_9334.field_49639, (Object)0);
                if (!rightInput.method_7960() && outputRepairCost < (Integer)rightInput.method_57825(class_9334.field_49639, (Object)0)) {
                    outputRepairCost = (Integer)rightInput.method_57825(class_9334.field_49639, (Object)0);
                }
                if (!(allOperationsCost <= 0 || (enchantOperationCost <= 0 || isBook && leftInput.method_31574(class_1802.field_8598) && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.penaltyFreeEnchantsForBooks) && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.penaltyFreeRenamesAndRepairs)) {
                    outputRepairCost = class_1706.method_20398((int)outputRepairCost);
                }
                if (outputRepairCost > 0) {
                    output.method_57379(class_9334.field_49639, (Object)outputRepairCost);
                }
                class_1890.method_57530((class_1799)output, (class_9304)leftEnchantments.method_57549());
            }
            this.field_22479.method_5447(0, output);
            this.method_7623();
        }
    }

    public void setCost(int cost) {
        this.method_7606(0, cost);
    }

    public void method_7595(class_1657 player) {
        class_3914 containerLevelAccess = this.field_22481;
        this.field_22481 = class_3914.field_17304;
        super.method_7595(player);
        this.field_22481 = containerLevelAccess;
    }

    public boolean method_7625(String newName) {
        if (ComponentDecomposer.getStringLength(newName = FormattedStringDecomposer.filterText(newName)) <= 50 && !Objects.equals(newName, this.field_7774)) {
            this.field_7774 = newName.trim();
            if (this.method_7611(2).method_7681()) {
                class_1799 itemStack = this.method_7611(2).method_7677();
                ModAnvilMenu.setFormattedItemName(this.field_7774, itemStack);
            }
            this.method_24928();
            return true;
        }
        return false;
    }

    public static void setFormattedItemName(String newName, class_1799 itemStack) {
        class_2561 component = ComponentDecomposer.toFormattedComponent(newName);
        if (component.getString().isEmpty()) {
            itemStack.method_57381(class_9334.field_49631);
        } else {
            itemStack.method_57379(class_9334.field_49631, (Object)component);
        }
    }
}

